/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.contract;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.mongodb.client.model.Filters;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.server.DbRequestResult;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.SchemaValidationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.guid.GUIDReader;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.administration.AbstractContractModel;
import fr.gouv.vitam.common.model.administration.ActivationStatus;
import fr.gouv.vitam.common.model.administration.IngestContractCheckState;
import fr.gouv.vitam.common.model.administration.IngestContractModel;
import fr.gouv.vitam.common.model.administration.ManagementContractModel;
import fr.gouv.vitam.common.model.administration.SignaturePolicy;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.common.IngestContract;
import fr.gouv.vitam.functional.administration.common.VitamErrorUtils;
import fr.gouv.vitam.functional.administration.common.counter.SequenceType;
import fr.gouv.vitam.functional.administration.common.counter.VitamCounterService;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialException;
import fr.gouv.vitam.functional.administration.common.server.FunctionalAdminCollections;
import fr.gouv.vitam.functional.administration.common.server.MongoDbAccessAdminImpl;
import fr.gouv.vitam.functional.administration.common.server.MongoDbAccessReferential;
import fr.gouv.vitam.functional.administration.core.backup.FunctionalBackupService;
import fr.gouv.vitam.functional.administration.core.contract.ContractHelper;
import fr.gouv.vitam.functional.administration.core.contract.ContractLogbookService;
import fr.gouv.vitam.functional.administration.core.contract.ContractService;
import fr.gouv.vitam.functional.administration.core.contract.GenericContractValidator;
import fr.gouv.vitam.functional.administration.core.contract.IngestContractValidator;
import fr.gouv.vitam.functional.administration.core.contract.ManagementContractImpl;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.metadata.api.exception.MetaDataClientServerException;
import fr.gouv.vitam.metadata.api.exception.MetaDataDocumentSizeException;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import java.time.format.DateTimeParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.bson.conversions.Bson;

public class IngestContractImpl
implements ContractService<IngestContractModel> {
    public static final String CONTRACT_BACKUP_EVENT = "STP_BACKUP_INGEST_CONTRACT";
    private static final String THE_INGEST_CONTRACT_STATUS_MUST_BE_ACTIVE_OR_INACTIVE_BUT_NOT = "The Ingest contract status must be ACTIVE or INACTIVE but not ";
    private static final String INGEST_CONTRACT_CHECK_PARENT_LINK_STATUS_NOT_IN_ENUM = "the ingest contract check parent link status in not in enum";
    private static final String INGEST_CONTRACT_NOT_FOUND = "Ingest contract not found";
    private static final String CONTRACT_IS_MANDATORY_PATAMETER = "The collection of ingest contracts is mandatory";
    private static final String EVERYFORMAT_LIST_EMPTY = "formatType field must not be empty when everyFormat is false";
    private static final String EVERYFORMAT_LIST_NOT_EMPTY = "formatType field must be empty when everyFormat is true";
    private static final String DATE_MUST_BE_VALID = "must be a valid date";
    private static final String CONTRACTS_IMPORT_EVENT = "STP_IMPORT_INGEST_CONTRACT";
    private static final String CONTRACT_UPDATE_EVENT = "STP_UPDATE_INGEST_CONTRACT";
    private static final String EMPTY_REQUIRED_FIELD = "STP_IMPORT_INGEST_CONTRACT.EMPTY_REQUIRED_FIELD.KO";
    private static final String DUPLICATE_IN_DATABASE = "STP_IMPORT_INGEST_CONTRACT.IDENTIFIER_DUPLICATION.KO";
    private static final String PROFILE_NOT_FOUND_IN_DATABASE = "STP_IMPORT_INGEST_CONTRACT.PROFILE_NOT_FOUND.KO";
    private static final String FORMAT_NOT_FOUND = "STP_IMPORT_INGEST_CONTRACT.FORMAT_NOT_FOUND.KO";
    private static final String FORMAT_MUST_BE_EMPTY = "STP_IMPORT_INGEST_CONTRACT.FORMAT_MUST_BE_EMPTY.KO";
    private static final String FORMAT_MUST_NOT_BE_EMPTY = "STP_IMPORT_INGEST_CONTRACT.FORMAT_MUST_NOT_BE_EMPTY.KO";
    private static final String MANAGEMENTCONTRACT_NOT_FOUND = "STP_IMPORT_INGEST_CONTRACT.MANAGEMENTCONTRACT_NOT_FOUND.KO";
    private static final String CONTRACT_BAD_REQUEST = "STP_IMPORT_INGEST_CONTRACT.BAD_REQUEST.KO";
    private static final String UPDATE_CONTRACT_NOT_FOUND = "STP_UPDATE_INGEST_CONTRACT.CONTRACT_NOT_FOUND.KO";
    private static final String UPDATE_CONTRACT_BAD_REQUEST = "STP_UPDATE_INGEST_CONTRACT.BAD_REQUEST.KO";
    private static final String UPDATE_VALUE_NOT_IN_ENUM = "STP_UPDATE_INGEST_CONTRACT.NOT_IN_ENUM.KO";
    private static final String UPDATE_PROFILE_NOT_FOUND = "STP_UPDATE_INGEST_CONTRACT.PROFILE_NOT_FOUND.KO";
    private static final String UPDATE_WRONG_FILEFORMAT = "STP_UPDATE_INGEST_CONTRACT.FILEFORMAT_NOT_FOUND.KO";
    private static final String UPDATE_MANAGEMENTCONTRACT_NOT_FOUND = "STP_UPDATE_INGEST_CONTRACT.MANAGEMENTCONTRACT_NOT_FOUND.KO";
    private static final String UPDATE_KO = "STP_UPDATE_INGEST_CONTRACT.KO";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(IngestContractImpl.class);
    private static final String UND_TENANT = "_tenant";
    private static final String UND_ID = "_id";
    private static final String RESULT_HITS = "$hits";
    private static final String HITS_SIZE = "size";
    private static final String CONTRACT_KEY = "IngestContract";
    private static final String CONTRACT_CHECK_KEY = "ingestContractCheck";
    private final MongoDbAccessAdminImpl mongoAccess;
    private final LogbookOperationsClient logbookClient;
    private final VitamCounterService vitamCounterService;
    private final MetaDataClient metaDataClient;
    private final FunctionalBackupService functionalBackupService;
    private final ContractService<ManagementContractModel> managementContractService;

    public IngestContractImpl(MongoDbAccessAdminImpl mongoAccess, VitamCounterService vitamCounterService) {
        this(mongoAccess, vitamCounterService, MetaDataClientFactory.getInstance().getClient(), LogbookOperationsClientFactory.getInstance().getClient(), new FunctionalBackupService(vitamCounterService), new ManagementContractImpl(mongoAccess, vitamCounterService));
    }

    @VisibleForTesting
    public IngestContractImpl(MongoDbAccessAdminImpl mongoAccess, VitamCounterService vitamCounterService, MetaDataClient metaDataClient, LogbookOperationsClient logbookClient, FunctionalBackupService functionalBackupService, ContractService<ManagementContractModel> managementContractService) {
        this.mongoAccess = mongoAccess;
        this.vitamCounterService = vitamCounterService;
        this.metaDataClient = metaDataClient;
        this.functionalBackupService = functionalBackupService;
        this.logbookClient = logbookClient;
        this.managementContractService = managementContractService;
    }

    private static VitamError<IngestContractModel> getVitamError(String vitamCode, String error) {
        return VitamErrorUtils.getVitamError((String)vitamCode, (String)error, (String)CONTRACT_KEY, (StatusCode)StatusCode.KO, IngestContractModel.class);
    }

    @Override
    public RequestResponse<IngestContractModel> createContracts(List<IngestContractModel> contractModelList) throws VitamException {
        ParametersChecker.checkParameter((String)CONTRACT_IS_MANDATORY_PATAMETER, (Object[])new Object[]{contractModelList});
        if (contractModelList.isEmpty()) {
            return new RequestResponseOK();
        }
        boolean slaveMode = this.vitamCounterService.isSlaveFunctionnalCollectionOnTenant(SequenceType.INGEST_CONTRACT_SEQUENCE.getCollection(), ParameterHelper.getTenantParameter());
        String operationId = VitamThreadUtils.getVitamSession().getRequestId();
        GUID eip = GUIDReader.getGUID((String)operationId);
        IngestContractValidationService validationService = new IngestContractValidationService(this.metaDataClient, this.managementContractService);
        ContractLogbookService logbookService = new ContractLogbookService(this.logbookClient, eip, CONTRACTS_IMPORT_EVENT, CONTRACT_UPDATE_EVENT, CONTRACT_KEY, CONTRACT_CHECK_KEY);
        logbookService.logStarted();
        VitamError error = IngestContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), "Ingest contract import error").setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
        try {
            for (IngestContractModel acm : contractModelList) {
                Set checkParentId;
                String linkParentId = acm.getLinkParentId();
                if (linkParentId != null && !validationService.checkIfUnitExist(linkParentId)) {
                    error.addToErrors(IngestContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), GenericContractValidator.GenericRejectionCause.rejectAuNotFoundInDatabase(linkParentId).getReason()));
                    continue;
                }
                String managementContractId = acm.getManagementContractId();
                if (managementContractId != null && !validationService.checkIfManagementContractExists(managementContractId)) {
                    error.addToErrors(IngestContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), GenericContractValidator.GenericRejectionCause.rejectMCNotFoundInDatabase(managementContractId).getReason()).setMessage(MANAGEMENTCONTRACT_NOT_FOUND));
                    continue;
                }
                SignaturePolicy signaturePolicy = acm.getSignaturePolicy();
                if (signaturePolicy != null) {
                    if (validationService.isInvalidSignaturePolicy(signaturePolicy)) {
                        error.addToErrors(IngestContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), GenericContractValidator.GenericRejectionCause.rejectInconsistentContract(acm.getName(), "The fields declaredSignature, declaredTimestamp, or declaredAdditionalProof are not authorized due to the signature policy").getReason()).setMessage(CONTRACT_BAD_REQUEST));
                        continue;
                    }
                    validationService.validSignatureObject(signaturePolicy);
                }
                if ((checkParentId = acm.getCheckParentId()) != null) {
                    if (!checkParentId.isEmpty() && IngestContractCheckState.UNAUTHORIZED.equals((Object)acm.getCheckParentLink())) {
                        error.addToErrors(IngestContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), GenericContractValidator.GenericRejectionCause.rejectInconsistentContract(acm.getName(), "attachments not authorized but checkParentId field is not empty").getReason()));
                        continue;
                    }
                    if (!validationService.checkIfAllUnitExist(checkParentId)) {
                        error.addToErrors(IngestContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), GenericContractValidator.GenericRejectionCause.rejectAuNotFoundInDatabase(String.join((CharSequence)" ", checkParentId)).getReason()));
                        continue;
                    }
                }
                if (null != acm.getId()) {
                    error.addToErrors(IngestContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), GenericContractValidator.GenericRejectionCause.rejectIdNotAllowedInCreate(acm.getName()).getReason()));
                    continue;
                }
                if (!acm.isEveryFormatType() && (acm.getFormatType() == null || acm.getFormatType().isEmpty())) {
                    error.addToErrors(IngestContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), EVERYFORMAT_LIST_EMPTY).setMessage(FORMAT_MUST_NOT_BE_EMPTY));
                    continue;
                }
                if (acm.isEveryFormatType() && acm.getFormatType() != null) {
                    error.addToErrors(IngestContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), EVERYFORMAT_LIST_NOT_EMPTY).setMessage(FORMAT_MUST_BE_EMPTY));
                    continue;
                }
                if (validationService.validateContract(acm, acm.getName(), (VitamError<IngestContractModel>)error)) {
                    acm.setId(GUIDFactory.newContractGUID((int)ParameterHelper.getTenantParameter()).getId());
                }
                if (acm.getTenant() == null) {
                    acm.setTenant(ParameterHelper.getTenantParameter());
                }
                if (!slaveMode) continue;
                Optional<GenericContractValidator.GenericRejectionCause> result = validationService.checkEmptyIdentifierSlaveModeValidator().validate(acm, acm.getIdentifier());
                result.ifPresent(t -> error.addToErrors(IngestContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), ((GenericContractValidator.GenericRejectionCause)result.get()).getReason()).setMessage(EMPTY_REQUIRED_FIELD)));
            }
            if (null != error.getErrors() && !error.getErrors().isEmpty()) {
                String errorsDetails = error.getErrors().stream().map(VitamError::getDescription).distinct().collect(Collectors.joining(","));
                logbookService.logValidationError(errorsDetails, CONTRACTS_IMPORT_EVENT, ((VitamError)error.getErrors().get(0)).getMessage());
                return error;
            }
            ArrayNode contractsToPersist = JsonHandler.createArrayNode();
            for (IngestContractModel acm : contractModelList) {
                JsonNode hashTenant;
                ContractHelper.setIdentifier(slaveMode, (AbstractContractModel)acm, this.vitamCounterService, SequenceType.INGEST_CONTRACT_SEQUENCE);
                ObjectNode ingestContractNode = (ObjectNode)JsonHandler.toJsonNode((Object)acm);
                JsonNode hashId = ingestContractNode.remove(VitamFieldsHelper.id());
                if (hashId != null) {
                    ingestContractNode.set(UND_ID, hashId);
                }
                if ((hashTenant = ingestContractNode.remove(VitamFieldsHelper.tenant())) != null) {
                    ingestContractNode.set(UND_TENANT, hashTenant);
                }
                contractsToPersist.add((JsonNode)ingestContractNode);
            }
            this.mongoAccess.insertDocuments(contractsToPersist, FunctionalAdminCollections.INGEST_CONTRACT).close();
            this.functionalBackupService.saveCollectionAndSequence(eip, CONTRACT_BACKUP_EVENT, FunctionalAdminCollections.INGEST_CONTRACT, eip.toString());
            logbookService.logSuccess();
            return new RequestResponseOK().addAllResults(contractModelList).setHttpCode(Response.Status.CREATED.getStatusCode());
        }
        catch (BadRequestException | SchemaValidationException exp) {
            LOGGER.error(exp);
            String err = "Import ingest contracts error > " + exp.getMessage();
            logbookService.logValidationError(err, CONTRACTS_IMPORT_EVENT, CONTRACT_BAD_REQUEST);
            return IngestContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), exp.getMessage()).setDescription(err).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
        }
        catch (Exception exp) {
            LOGGER.error((Throwable)exp);
            String err = "Import ingest contracts error > " + exp.getMessage();
            logbookService.logFatalError(err, CONTRACTS_IMPORT_EVENT);
            return error.setCode(VitamCode.GLOBAL_INTERNAL_SERVER_ERROR.getItem()).setDescription(err).setHttpCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
    }

    @Override
    public IngestContractModel findByIdentifier(String identifier) throws ReferentialException, InvalidParseOperationException {
        SanityChecker.checkParameter((String[])new String[]{identifier});
        try (DbRequestResult result = ContractHelper.findByIdentifier(identifier, FunctionalAdminCollections.INGEST_CONTRACT, (MongoDbAccessReferential)this.mongoAccess);){
            List list = result.getDocuments(IngestContract.class, IngestContractModel.class);
            if (list.isEmpty()) {
                IngestContractModel ingestContractModel = null;
                return ingestContractModel;
            }
            IngestContractModel ingestContractModel = (IngestContractModel)list.get(0);
            return ingestContractModel;
        }
    }

    @Override
    public RequestResponseOK<IngestContractModel> findContracts(JsonNode queryDsl) throws ReferentialException, InvalidParseOperationException {
        SanityChecker.checkJsonAll((JsonNode)queryDsl);
        try (DbRequestResult result = this.mongoAccess.findDocuments(queryDsl, FunctionalAdminCollections.INGEST_CONTRACT);){
            RequestResponseOK requestResponseOK = result.getRequestResponseOK(queryDsl, IngestContract.class, IngestContractModel.class);
            return requestResponseOK;
        }
    }

    public void close() {
        this.logbookClient.close();
    }

    @Override
    public RequestResponse<IngestContractModel> updateContract(String identifier, JsonNode queryDsl) throws VitamException {
        String err;
        VitamError error = IngestContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), "Ingest contract update error").setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
        if (queryDsl == null || !queryDsl.isObject()) {
            return error;
        }
        IngestContractModel ingestContractModel = this.findByIdentifier(identifier);
        if (ingestContractModel == null) {
            error.setHttpCode(Response.Status.NOT_FOUND.getStatusCode());
            return error.addToErrors(IngestContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), INGEST_CONTRACT_NOT_FOUND + identifier).setMessage(UPDATE_CONTRACT_NOT_FOUND));
        }
        String operationId = VitamThreadUtils.getVitamSession().getRequestId();
        GUID eip = GUIDReader.getGUID((String)operationId);
        RequestResponseOK response = new RequestResponseOK();
        IngestContractValidationService validationService = new IngestContractValidationService(this.metaDataClient, this.managementContractService);
        ContractLogbookService logbookService = new ContractLogbookService(this.logbookClient, eip, CONTRACTS_IMPORT_EVENT, CONTRACT_UPDATE_EVENT, CONTRACT_KEY, CONTRACT_CHECK_KEY);
        logbookService.logUpdateStarted(ingestContractModel.getId());
        JsonNode actionNode = queryDsl.get(BuilderToken.GLOBAL.ACTION.exactToken());
        for (JsonNode fieldToSet : actionNode) {
            JsonNode fieldName = fieldToSet.get(BuilderToken.UPDATEACTION.SET.exactToken());
            if (fieldName == null) continue;
            Iterator it = fieldName.fieldNames();
            while (it.hasNext()) {
                String field = (String)it.next();
                JsonNode value = fieldName.findValue(field);
                this.validateUpdateAction(validationService, ingestContractModel.getName(), (VitamError<IngestContractModel>)error, field, value, ingestContractModel);
            }
            ((ObjectNode)fieldName).remove("CreationDate");
            ((ObjectNode)fieldName).put("LastUpdate", LocalDateUtil.nowFormatted());
        }
        try {
            JsonNode signaturePolicyNode;
            DbRequestResult result;
            JsonNode archiveProfilesNode;
            String managementContractId;
            JsonNode managementContractNode;
            String linkParentId;
            JsonNode linkParentNode = queryDsl.findValue("LinkParentId");
            if (linkParentNode != null && !(linkParentId = linkParentNode.asText()).equals("") && !validationService.checkIfUnitExist(linkParentId)) {
                error.addToErrors(IngestContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), GenericContractValidator.GenericRejectionCause.rejectAuNotFoundInDatabase(linkParentId).getReason()).setMessage(UPDATE_KO));
            }
            if ((managementContractNode = queryDsl.findValue("ManagementContractId")) != null && !validationService.checkIfManagementContractExists(managementContractId = managementContractNode.asText())) {
                error.addToErrors(IngestContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), GenericContractValidator.GenericRejectionCause.rejectMCNotFoundInDatabase(managementContractId).getReason()).setMessage(UPDATE_MANAGEMENTCONTRACT_NOT_FOUND));
            }
            boolean isAttachmentAuthorized = true;
            JsonNode checkParentLink = queryDsl.findValue("CheckParentLink");
            IngestContractCheckState checkState = ingestContractModel.getCheckParentLink();
            if (checkParentLink != null) {
                if (IngestContractCheckState.contains((String)checkParentLink.asText())) {
                    checkState = IngestContractCheckState.valueOf((String)checkParentLink.asText());
                } else {
                    error.addToErrors(IngestContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), INGEST_CONTRACT_CHECK_PARENT_LINK_STATUS_NOT_IN_ENUM + checkParentLink.asText()).setMessage(UPDATE_VALUE_NOT_IN_ENUM));
                }
            }
            if (IngestContractCheckState.UNAUTHORIZED.equals((Object)checkState)) {
                isAttachmentAuthorized = false;
            }
            JsonNode checkParentIdsNode = queryDsl.findValue("CheckParentId");
            HashSet<String> checkParentIds = new HashSet<String>();
            if (checkParentIdsNode != null) {
                if (checkParentIdsNode.isArray()) {
                    for (JsonNode checkParentId : checkParentIdsNode) {
                        checkParentIds.add(checkParentId.asText());
                    }
                    if (!checkParentIds.isEmpty() && !validationService.checkIfAllUnitExist(checkParentIds)) {
                        error.addToErrors(IngestContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), GenericContractValidator.GenericRejectionCause.rejectAuNotFoundInDatabase(String.join((CharSequence)" ", checkParentIds)).getReason()).setMessage(UPDATE_KO));
                    }
                }
            } else if (ingestContractModel.getCheckParentId() != null) {
                checkParentIds.addAll(ingestContractModel.getCheckParentId());
            }
            if (!isAttachmentAuthorized && !checkParentIds.isEmpty()) {
                error.addToErrors(IngestContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), GenericContractValidator.GenericRejectionCause.rejectInconsistentContract(ingestContractModel.getName(), "attachments not authorized but checkParentId field is not empty").getReason()));
            }
            if ((archiveProfilesNode = queryDsl.findValue("ArchiveProfiles")) != null) {
                Set archiveProfiles = (Set)JsonHandler.getFromStringAsTypeReference((String)archiveProfilesNode.toString(), (TypeReference)new TypeReference<Set<String>>(){});
                IngestContractValidator validator = validationService.createCheckProfilesExistsInDatabaseValidator();
                Optional<GenericContractValidator.GenericRejectionCause> result2 = validator.validate(new IngestContractModel().setArchiveProfiles(archiveProfiles), identifier);
                result2.ifPresent(genericRejectionCause -> error.addToErrors(IngestContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), genericRejectionCause.getReason()).setMessage(UPDATE_PROFILE_NOT_FOUND)));
            }
            JsonNode fileFormatTypeNode = queryDsl.findValue("FormatType");
            Set<String> fileFormatTypes = this.getFromJsonNodeOrFromIngestContractModel(ingestContractModel, fileFormatTypeNode);
            this.checkFormatsNotEmptyWhenEveryFormatTypeIsFalse(queryDsl, fileFormatTypes, fileFormatTypeNode, (VitamError<IngestContractModel>)error);
            if (fileFormatTypes != null) {
                IngestContractValidator validator = validationService.createCheckFormatFileExistsInDatabaseValidator();
                result = validator.validate(new IngestContractModel().setFormatType(fileFormatTypes), identifier);
                result.ifPresent(genericRejectionCause -> error.addToErrors(IngestContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), genericRejectionCause.getReason()).setMessage(UPDATE_WRONG_FILEFORMAT)));
            }
            if ((signaturePolicyNode = queryDsl.findValue("SignaturePolicy")) != null) {
                try {
                    SignaturePolicy signaturePolicy = (SignaturePolicy)JsonHandler.getFromJsonNode((JsonNode)signaturePolicyNode, SignaturePolicy.class);
                    if (validationService.isInvalidSignaturePolicy(signaturePolicy)) {
                        error.addToErrors(IngestContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), GenericContractValidator.GenericRejectionCause.rejectInconsistentContract(ingestContractModel.getName(), "The fields declaredSignature, declaredTimestamp, or declaredAdditionalProof are not authorized due to the signature policy").getReason()).setMessage(UPDATE_CONTRACT_BAD_REQUEST));
                    }
                    validationService.validSignatureObject(signaturePolicy);
                    queryDsl = this.addValidatedSignatureToQueryDsl(queryDsl, signaturePolicy);
                }
                catch (InvalidParseOperationException e) {
                    throw new SchemaValidationException("Update process failure for the entry contract: incorrect value entered in the SignaturePolicy field: expected values: [ALLOWED, MANDATORY, FORBIDDEN]", e.getCause());
                }
            }
            if (error.getErrors() != null && !error.getErrors().isEmpty()) {
                String errorsDetails = error.getErrors().stream().map(VitamError::getDescription).collect(Collectors.joining(","));
                logbookService.logValidationError(errorsDetails, CONTRACT_UPDATE_EVENT, ((VitamError)error.getErrors().get(0)).getMessage());
                return error;
            }
            result = this.mongoAccess.updateData(queryDsl, FunctionalAdminCollections.INGEST_CONTRACT);
            Map updateDiffs = result.getDiffs();
            response.addAllResults(result.getDocuments(IngestContract.class, IngestContractModel.class)).setTotal(result.getTotal()).setQuery(queryDsl).setHttpCode(Response.Status.OK.getStatusCode());
            result.close();
            this.functionalBackupService.saveCollectionAndSequence(eip, CONTRACT_BACKUP_EVENT, FunctionalAdminCollections.INGEST_CONTRACT, ingestContractModel.getId());
            logbookService.logUpdateSuccess(ingestContractModel.getId(), identifier, (List)updateDiffs.get(ingestContractModel.getId()));
            return response;
        }
        catch (BadRequestException | InvalidParseOperationException | SchemaValidationException exp) {
            LOGGER.error(exp);
            err = "Update ingest contract error > " + exp.getMessage();
            logbookService.logValidationError(err, CONTRACT_UPDATE_EVENT, UPDATE_CONTRACT_BAD_REQUEST);
            return IngestContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), exp.getMessage()).setDescription(err).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            err = "Update ingest contract error > " + e.getMessage();
            logbookService.logFatalError(err, CONTRACT_UPDATE_EVENT);
            error.setCode(VitamCode.GLOBAL_INTERNAL_SERVER_ERROR.getItem()).setDescription(err).setHttpCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
            return error;
        }
    }

    private JsonNode addValidatedSignatureToQueryDsl(JsonNode queryDsl, SignaturePolicy signaturePolicy) {
        ArrayNode actions = (ArrayNode)queryDsl.get("$action");
        for (JsonNode action : actions) {
            JsonNode setAction;
            if (!action.has("$set") || !(setAction = action.get("$set")).has("SignaturePolicy")) continue;
            ObjectNode mySignaturePolicyNode = (ObjectNode)setAction.get("SignaturePolicy");
            Optional.ofNullable(signaturePolicy.isDeclaredSignature()).ifPresent(value -> mySignaturePolicyNode.put("DeclaredSignature", value));
            Optional.ofNullable(signaturePolicy.isDeclaredTimestamp()).ifPresent(value -> mySignaturePolicyNode.put("DeclaredTimestamp", value));
            Optional.ofNullable(signaturePolicy.isDeclaredAdditionalProof()).ifPresent(value -> mySignaturePolicyNode.put("DeclaredAdditionalProof", value));
        }
        return queryDsl;
    }

    private void validateUpdateAction(IngestContractValidationService validationService, String name, VitamError<IngestContractModel> error, String field, JsonNode value, IngestContractModel ingestContractModel) {
        switch (field) {
            case "Status": {
                if (ActivationStatus.ACTIVE.name().equals(value.asText()) || ActivationStatus.INACTIVE.name().equals(value.asText())) break;
                error.addToErrors(IngestContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), THE_INGEST_CONTRACT_STATUS_MUST_BE_ACTIVE_OR_INACTIVE_BUT_NOT + value.asText()).setMessage(UPDATE_VALUE_NOT_IN_ENUM));
                break;
            }
            case "LastUpdate": 
            case "CreationDate": 
            case "ActivationDate": 
            case "DeactivationDate": {
                try {
                    LocalDateUtil.getFormattedDateTimeForMongo((String)value.asText());
                    break;
                }
                catch (DateTimeParseException e) {
                    error.addToErrors(IngestContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), String.format("%s %s", field, DATE_MUST_BE_VALID)).setMessage(UPDATE_CONTRACT_BAD_REQUEST));
                }
            }
        }
    }

    private Set<String> getFromJsonNodeOrFromIngestContractModel(IngestContractModel ingestContractModel, JsonNode fileFormatTypeNode) throws InvalidParseOperationException {
        if (fileFormatTypeNode != null && fileFormatTypeNode.isArray()) {
            return (Set)JsonHandler.getFromString((String)fileFormatTypeNode.toString(), Set.class, String.class);
        }
        if (ingestContractModel.getFormatType() != null) {
            return ingestContractModel.getFormatType();
        }
        return null;
    }

    private void checkFormatsNotEmptyWhenEveryFormatTypeIsFalse(JsonNode queryDsl, Set<String> fileFormatTypes, JsonNode fileFormatTypeNode, VitamError<IngestContractModel> error) {
        JsonNode everyFileformatFlagNode = queryDsl.findValue("EveryFormatType");
        if (everyFileformatFlagNode != null || fileFormatTypeNode != null) {
            boolean canBeUpdate;
            boolean everyFileFormat = everyFileformatFlagNode != null && everyFileformatFlagNode.asBoolean();
            boolean formatsEmpty = fileFormatTypes == null || fileFormatTypes.isEmpty();
            boolean bl = canBeUpdate = !formatsEmpty || everyFileFormat;
            if (!canBeUpdate) {
                error.addToErrors(IngestContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), EVERYFORMAT_LIST_EMPTY).setMessage(UPDATE_CONTRACT_BAD_REQUEST));
            }
        }
    }

    protected static final class IngestContractValidationService {
        private final Map<IngestContractValidator, String> validators;
        private final MetaDataClient metaDataClient;
        private final ContractService<ManagementContractModel> managementContractService;

        public IngestContractValidationService(MetaDataClient metaDataClient, ContractService<ManagementContractModel> managementContractService) {
            this.metaDataClient = metaDataClient;
            this.managementContractService = managementContractService;
            this.validators = new HashMap<IngestContractValidator, String>(){
                {
                    this.put(this.createMandatoryParamsValidator(), IngestContractImpl.EMPTY_REQUIRED_FIELD);
                    this.put(this.createWrongFieldFormatValidator(), IngestContractImpl.EMPTY_REQUIRED_FIELD);
                    this.put(this.createCheckDuplicateInDatabaseValidator(), IngestContractImpl.DUPLICATE_IN_DATABASE);
                    this.put(this.createCheckProfilesExistsInDatabaseValidator(), IngestContractImpl.PROFILE_NOT_FOUND_IN_DATABASE);
                    this.put(this.createCheckFormatFileExistsInDatabaseValidator(), IngestContractImpl.FORMAT_NOT_FOUND);
                }
            };
        }

        private boolean validateContract(IngestContractModel contract, String jsonFormat, VitamError<IngestContractModel> error) {
            for (IngestContractValidator validator : this.validators.keySet()) {
                Optional<GenericContractValidator.GenericRejectionCause> result = validator.validate(contract, jsonFormat);
                if (!result.isPresent()) continue;
                error.addToErrors(IngestContractImpl.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), result.get().getReason()).setMessage(this.validators.get(validator)));
                return false;
            }
            return true;
        }

        private IngestContractValidator createMandatoryParamsValidator() {
            return (contract, jsonFormat) -> {
                GenericContractValidator.GenericRejectionCause rejection = null;
                if (contract.getName() == null || contract.getName().trim().isEmpty()) {
                    rejection = GenericContractValidator.GenericRejectionCause.rejectMandatoryMissing("Name");
                }
                return rejection == null ? Optional.empty() : Optional.of(rejection);
            };
        }

        protected boolean isInvalidSignaturePolicy(SignaturePolicy signaturePolicy) {
            return signaturePolicy.getSignedDocument() == null || signaturePolicy.getSignedDocument() == SignaturePolicy.SignedDocumentPolicyEnum.FORBIDDEN && (signaturePolicy.isDeclaredSignature() != null || signaturePolicy.isDeclaredTimestamp() != null || signaturePolicy.isDeclaredAdditionalProof() != null);
        }

        protected void validSignatureObject(SignaturePolicy signaturePolicy) {
            if (signaturePolicy.getSignedDocument().equals((Object)SignaturePolicy.SignedDocumentPolicyEnum.FORBIDDEN)) {
                signaturePolicy.setDeclaredSignature(null);
                signaturePolicy.setDeclaredTimestamp(null);
                signaturePolicy.setDeclaredAdditionalProof(null);
            } else {
                signaturePolicy.setDeclaredSignature(Boolean.valueOf(signaturePolicy.isDeclaredSignature() != null ? signaturePolicy.isDeclaredSignature() : false));
                signaturePolicy.setDeclaredAdditionalProof(Boolean.valueOf(signaturePolicy.isDeclaredAdditionalProof() != null ? signaturePolicy.isDeclaredAdditionalProof() : false));
                signaturePolicy.setDeclaredTimestamp(Boolean.valueOf(signaturePolicy.isDeclaredTimestamp() != null ? signaturePolicy.isDeclaredTimestamp() : false));
            }
        }

        private IngestContractValidator createWrongFieldFormatValidator() {
            return (contract, inputList) -> {
                GenericContractValidator.GenericRejectionCause rejection = null;
                String now = LocalDateUtil.nowFormatted();
                if (contract.getStatus() == null) {
                    contract.setStatus(ActivationStatus.INACTIVE);
                }
                if (contract.getCheckParentLink() == null) {
                    contract.setCheckParentLink(IngestContractCheckState.AUTHORIZED);
                }
                try {
                    if (contract.getCreationdate() == null || contract.getCreationdate().trim().isEmpty()) {
                        contract.setCreationdate(now);
                    } else {
                        contract.setCreationdate(LocalDateUtil.getFormattedDateTimeForMongo((String)contract.getCreationdate()));
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error ingest contract parse dates", (Throwable)e);
                    rejection = GenericContractValidator.GenericRejectionCause.rejectMandatoryMissing("Creationdate");
                }
                try {
                    if (contract.getActivationdate() == null || contract.getActivationdate().trim().isEmpty()) {
                        contract.setActivationdate(now);
                    } else {
                        contract.setActivationdate(LocalDateUtil.getFormattedDateTimeForMongo((String)contract.getActivationdate()));
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error ingest contract parse dates", (Throwable)e);
                    rejection = GenericContractValidator.GenericRejectionCause.rejectMandatoryMissing("ActivationDate");
                }
                try {
                    if (contract.getDeactivationdate() == null || contract.getDeactivationdate().trim().isEmpty()) {
                        contract.setDeactivationdate(null);
                    } else {
                        contract.setDeactivationdate(LocalDateUtil.getFormattedDateTimeForMongo((String)contract.getDeactivationdate()));
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error ingest contract parse dates", (Throwable)e);
                    rejection = GenericContractValidator.GenericRejectionCause.rejectMandatoryMissing("deactivationdate");
                }
                contract.setLastupdate(now);
                return rejection == null ? Optional.empty() : Optional.of(rejection);
            };
        }

        private IngestContractValidator createCheckDuplicateInDatabaseValidator() {
            return (contract, contractName) -> {
                if (ParametersChecker.isNotEmpty((String[])new String[]{contract.getIdentifier()})) {
                    boolean exist;
                    int tenant = ParameterHelper.getTenantParameter();
                    Bson clause = Filters.and((Bson[])new Bson[]{Filters.eq((String)IngestContractImpl.UND_TENANT, (Object)tenant), Filters.eq((String)"Identifier", (Object)contract.getIdentifier())});
                    boolean bl = exist = FunctionalAdminCollections.INGEST_CONTRACT.getCollection().countDocuments(clause) > 0L;
                    if (exist) {
                        return Optional.of(GenericContractValidator.GenericRejectionCause.rejectDuplicatedInDatabase(contract.getIdentifier()));
                    }
                }
                return Optional.empty();
            };
        }

        private IngestContractValidator checkEmptyIdentifierSlaveModeValidator() {
            return (contract, contractIdentifier) -> {
                if (contractIdentifier == null || contractIdentifier.isEmpty()) {
                    return Optional.of(GenericContractValidator.GenericRejectionCause.rejectMandatoryMissing("Identifier"));
                }
                return Optional.empty();
            };
        }

        private IngestContractValidator createCheckProfilesExistsInDatabaseValidator() {
            return (contract, contractName) -> {
                if (null == contract.getArchiveProfiles() || contract.getArchiveProfiles().size() == 0) {
                    return Optional.empty();
                }
                GenericContractValidator.GenericRejectionCause rejection = null;
                int tenant = ParameterHelper.getTenantParameter();
                Bson clause = Filters.and((Bson[])new Bson[]{Filters.eq((String)IngestContractImpl.UND_TENANT, (Object)tenant), Filters.in((String)"Identifier", (Iterable)contract.getArchiveProfiles())});
                long count = FunctionalAdminCollections.PROFILE.getCollection().countDocuments(clause);
                if (count != (long)contract.getArchiveProfiles().size()) {
                    rejection = GenericContractValidator.GenericRejectionCause.rejectArchiveProfileNotFoundInDatabase(contractName);
                }
                return rejection == null ? Optional.empty() : Optional.of(rejection);
            };
        }

        private IngestContractValidator createCheckFormatFileExistsInDatabaseValidator() {
            return (contract, contractName) -> {
                if (null == contract.getFormatType() || contract.getFormatType().size() == 0) {
                    return Optional.empty();
                }
                GenericContractValidator.GenericRejectionCause rejection = null;
                Bson clause = Filters.in((String)"PUID", (Iterable)contract.getFormatType());
                long count = FunctionalAdminCollections.FORMATS.getCollection().countDocuments(clause);
                if (count != (long)contract.getFormatType().size()) {
                    rejection = GenericContractValidator.GenericRejectionCause.rejectFormatFileTypeNotFoundInDatabase(contractName);
                }
                return rejection == null ? Optional.empty() : Optional.of(rejection);
            };
        }

        private boolean checkIfUnitExist(String unitId) throws MetaDataExecutionException, MetaDataDocumentSizeException, MetaDataClientServerException, InvalidParseOperationException {
            Select select = new Select();
            JsonNode jsonNode = this.metaDataClient.selectUnitbyId((JsonNode)select.getFinalSelect(), unitId);
            return jsonNode != null && jsonNode.get(IngestContractImpl.RESULT_HITS) != null && jsonNode.get(IngestContractImpl.RESULT_HITS).get(IngestContractImpl.HITS_SIZE).asInt() > 0;
        }

        private boolean checkIfManagementContractExists(String managementContractId) throws ReferentialException, InvalidParseOperationException {
            ManagementContractModel mc = this.managementContractService.findByIdentifier(managementContractId);
            return mc != null;
        }

        private boolean checkIfAllUnitExist(Set<String> unitIds) throws MetaDataExecutionException, MetaDataDocumentSizeException, MetaDataClientServerException, InvalidParseOperationException, InvalidCreateOperationException {
            Select select = new Select();
            select.setQuery((Query)QueryHelper.in((String)VitamFieldsHelper.id(), (String[])unitIds.toArray(new String[0])));
            JsonNode jsonNode = this.metaDataClient.selectUnits((JsonNode)select.getFinalSelect());
            return jsonNode != null && jsonNode.get(IngestContractImpl.RESULT_HITS) != null && jsonNode.get(IngestContractImpl.RESULT_HITS).get(IngestContractImpl.HITS_SIZE).asInt() > 0;
        }
    }
}

