/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.contract;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.i18n.VitamLogbookMessages;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import java.util.List;

public class ContractLogbookService {
    public static final String MC_GLOBAL_ERROR = "ManagementContract service error";
    public static final String IC_GLOBAL_ERROR = "IngestContract service error";
    public static final String AC_GLOBAL_ERROR = "AccessContract service error";
    public static final String EMPTY_REQUIRED_FIELD = ".EMPTY_REQUIRED_FIELD.KO";
    public static final String WRONG_FIELD_FORMAT = ".TO_BE_DEFINED.KO";
    public static final String DUPLICATE_IN_DATABASE = ".IDENTIFIER_DUPLICATION.KO";
    public static final String PROFILE_NOT_FOUND_IN_DATABASE = ".PROFILE_NOT_FOUND.KO";
    public static final String AGENCY_NOT_FOUND_IN_DATABASE = ".AGENCY_NOT_FOUND.KO";
    public static final String CONTRACT_VALIDATION_ERROR = ".VALIDATION_ERROR.KO";
    public static final String FORMAT_NOT_FOUND = ".FORMAT_NOT_FOUND.KO";
    public static final String FORMAT_MUST_BE_EMPTY = ".FORMAT_MUST_BE_EMPTY.KO";
    public static final String FORMAT_MUST_NOT_BE_EMPTY = ".FORMAT_MUST_NOT_BE_EMPTY.KO";
    public static final String MANAGEMENTCONTRACT_NOT_FOUND = ".MANAGEMENTCONTRACT_NOT_FOUND.KO";
    public static final String CONTRACT_BAD_REQUEST = ".BAD_REQUEST.KO";
    public static final String UPDATE_CONTRACT_NOT_FOUND = ".CONTRACT_NOT_FOUND.KO";
    public static final String UPDATE_VALUE_NOT_IN_ENUM = ".NOT_IN_ENUM.KO";
    public static final String UPDATE_WRONG_FILEFORMAT = ".FILEFORMAT_NOT_FOUND.KO";
    public static final String STRATEGY_VALIDATION_ERROR = ".STRATEGY_VALIDATION_ERROR.KO";
    public static final String VERSION_RETENTION_POLICY_VALIDATION_ERROR = ".VERSION_RETENTION_POLICY_ERROR.KO";
    public static final String PERSISTENCE_IDENTIFIER_POLICY_VALIDATION_ERROR = ".PERSISTENCE_IDENTIFIER_POLICY_ERROR.KO";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ContractLogbookService.class);
    private static final String EVDETDATA_IDENTIFIER = "identifier";
    private static final String UPDATED_DIFFS = "updatedDiffs";
    private final GUID eip;
    private final LogbookOperationsClient logbookClient;
    private final String contractsImportEventCode;
    private final String contractUpdateEventCode;
    private final String collectionType;
    private final String contractCheckKey;

    public ContractLogbookService(LogbookOperationsClient logbookClient, GUID eip, String contractsImportEventCode, String contractUpdateEventCode, String collectionType, String contractCheckKey) {
        this.logbookClient = logbookClient;
        this.eip = eip;
        this.contractsImportEventCode = contractsImportEventCode;
        this.contractUpdateEventCode = contractUpdateEventCode;
        this.collectionType = collectionType;
        this.contractCheckKey = contractCheckKey;
    }

    public void logValidationError(String errorsDetails, String eventType, String KOEventType) throws VitamException {
        LOGGER.error("There are validation errors on the input file {}", (Object)errorsDetails);
        GUID eipUsage = GUIDFactory.newOperationLogbookGUID((int)ParameterHelper.getTenantParameter());
        LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eipUsage, (String)eventType, (GUID)this.eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.KO, (String)VitamLogbookMessages.getFromFullCodeKey((String)KOEventType), (GUID)this.eip);
        logbookParameters.putParameterValue(LogbookParameterName.outcomeDetail, KOEventType);
        this.logbookMessageError(errorsDetails, logbookParameters, KOEventType);
        this.logbookClient.update(new LogbookOperationParameters[]{logbookParameters});
    }

    public void logFatalError(String errorsDetails, String eventType) throws VitamException {
        LOGGER.error("There are validation errors on the input file {}", (Object)errorsDetails);
        GUID eipUsage = GUIDFactory.newOperationLogbookGUID((int)ParameterHelper.getTenantParameter());
        LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eipUsage, (String)eventType, (GUID)this.eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.FATAL, (String)VitamLogbookMessages.getCodeOp((String)eventType, (StatusCode)StatusCode.FATAL), (GUID)this.eip);
        logbookParameters.putParameterValue(LogbookParameterName.outcomeDetail, eventType + "." + StatusCode.FATAL);
        this.logbookMessageError(errorsDetails, logbookParameters);
        this.logbookClient.update(new LogbookOperationParameters[]{logbookParameters});
    }

    private void logbookMessageError(String errorsDetails, LogbookOperationParameters logbookParameters) {
        if (null != errorsDetails && !errorsDetails.isEmpty()) {
            try {
                ObjectNode object = JsonHandler.createObjectNode();
                object.put(this.contractCheckKey, errorsDetails);
                String wellFormedJson = SanityChecker.sanitizeJson((JsonNode)object);
                logbookParameters.putParameterValue(LogbookParameterName.eventDetailData, wellFormedJson);
            }
            catch (InvalidParseOperationException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private void logbookMessageError(String errorsDetails, LogbookOperationParameters logbookParameters, String KOEventType) {
        if (null != errorsDetails && !errorsDetails.isEmpty()) {
            try {
                String detailKo;
                ObjectNode object = JsonHandler.createObjectNode();
                String evDetDataKey = null;
                switch (detailKo = KOEventType.replaceFirst(this.contractsImportEventCode, "").replaceFirst(this.contractUpdateEventCode, "")) {
                    case ".EMPTY_REQUIRED_FIELD.KO": {
                        evDetDataKey = "Mandatory Fields";
                        break;
                    }
                    case ".TO_BE_DEFINED.KO": 
                    case ".FILEFORMAT_NOT_FOUND.KO": {
                        evDetDataKey = "Incorrect Field and value";
                        break;
                    }
                    case ".IDENTIFIER_DUPLICATION.KO": {
                        evDetDataKey = "Duplicate Field";
                        break;
                    }
                    case ".CONTRACT_NOT_FOUND.KO": {
                        evDetDataKey = "Contract not found";
                        break;
                    }
                    case ".NOT_IN_ENUM.KO": {
                        evDetDataKey = "Not in Enum";
                        break;
                    }
                    case ".PROFILE_NOT_FOUND.KO": {
                        evDetDataKey = "Profile not found";
                        break;
                    }
                    case ".AGENCY_NOT_FOUND.KO": {
                        evDetDataKey = "Agency not found";
                        break;
                    }
                    case ".VALIDATION_ERROR.KO": {
                        evDetDataKey = "Validation error";
                        break;
                    }
                    case ".STRATEGY_VALIDATION_ERROR.KO": 
                    case ".BAD_REQUEST.KO": 
                    case ".FORMAT_NOT_FOUND.KO": 
                    case ".FORMAT_MUST_BE_EMPTY.KO": 
                    case ".FORMAT_MUST_NOT_BE_EMPTY.KO": 
                    case ".MANAGEMENTCONTRACT_NOT_FOUND.KO": 
                    case "AccessContract service error": 
                    case "IngestContract service error": 
                    case "ManagementContract service error": 
                    case ".VERSION_RETENTION_POLICY_ERROR.KO": 
                    case ".PERSISTENCE_IDENTIFIER_POLICY_ERROR.KO": {
                        evDetDataKey = this.contractCheckKey;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(detailKo + " not found in detail ko values");
                    }
                }
                object.put(evDetDataKey, errorsDetails);
                String wellFormedJson = SanityChecker.sanitizeJson((JsonNode)object);
                logbookParameters.putParameterValue(LogbookParameterName.eventDetailData, wellFormedJson);
            }
            catch (InvalidParseOperationException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public void logStarted() throws VitamException {
        LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)this.eip, (String)this.contractsImportEventCode, (GUID)this.eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.STARTED, (String)VitamLogbookMessages.getCodeOp((String)this.contractsImportEventCode, (StatusCode)StatusCode.STARTED), (GUID)this.eip);
        logbookParameters.putParameterValue(LogbookParameterName.outcomeDetail, this.contractsImportEventCode + "." + StatusCode.STARTED);
        this.logbookClient.create(new LogbookOperationParameters[]{logbookParameters});
    }

    public void logUpdateStarted(String id) throws VitamException {
        LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)this.eip, (String)this.contractUpdateEventCode, (GUID)this.eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.STARTED, (String)VitamLogbookMessages.getCodeOp((String)this.contractUpdateEventCode, (StatusCode)StatusCode.STARTED), (GUID)this.eip);
        logbookParameters.putParameterValue(LogbookParameterName.outcomeDetail, this.contractUpdateEventCode + "." + StatusCode.STARTED);
        if (null != id && !id.isEmpty()) {
            logbookParameters.putParameterValue(LogbookParameterName.objectIdentifier, id);
        }
        this.logbookClient.create(new LogbookOperationParameters[]{logbookParameters});
    }

    public void logSuccess() throws VitamException {
        GUID eipUsage = GUIDFactory.newOperationLogbookGUID((int)ParameterHelper.getTenantParameter());
        LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eipUsage, (String)this.contractsImportEventCode, (GUID)this.eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.OK, (String)VitamLogbookMessages.getCodeOp((String)this.contractsImportEventCode, (StatusCode)StatusCode.OK), (GUID)this.eip);
        logbookParameters.putParameterValue(LogbookParameterName.outcomeDetail, this.contractsImportEventCode + "." + StatusCode.OK);
        this.logbookClient.update(new LogbookOperationParameters[]{logbookParameters});
    }

    public void logUpdateSuccess(String id, String identifier, List<String> listDiffs) throws VitamException {
        ObjectNode evDetData = JsonHandler.createObjectNode();
        ObjectNode evDetDataContract = JsonHandler.createObjectNode();
        String diffs = listDiffs.stream().reduce("", String::concat);
        ObjectNode msg = JsonHandler.createObjectNode();
        msg.put(EVDETDATA_IDENTIFIER, identifier);
        msg.put(UPDATED_DIFFS, diffs);
        evDetDataContract.set(id, (JsonNode)msg);
        evDetData.set(this.collectionType, (JsonNode)msg);
        String wellFormedJson = SanityChecker.sanitizeJson((JsonNode)evDetData);
        GUID eipUsage = GUIDFactory.newOperationLogbookGUID((int)ParameterHelper.getTenantParameter());
        LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eipUsage, (String)this.contractUpdateEventCode, (GUID)this.eip, (LogbookTypeProcess)LogbookTypeProcess.MASTERDATA, (StatusCode)StatusCode.OK, (String)VitamLogbookMessages.getCodeOp((String)this.contractUpdateEventCode, (StatusCode)StatusCode.OK), (GUID)this.eip);
        if (null != id && !id.isEmpty()) {
            logbookParameters.putParameterValue(LogbookParameterName.objectIdentifier, id);
        }
        logbookParameters.putParameterValue(LogbookParameterName.eventDetailData, wellFormedJson);
        logbookParameters.putParameterValue(LogbookParameterName.outcomeDetail, this.contractUpdateEventCode + "." + StatusCode.OK);
        this.logbookClient.update(new LogbookOperationParameters[]{logbookParameters});
    }
}

