/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.functional.administration.core.contract;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.mongodb.BasicDBObject;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.SedaConfiguration;
import fr.gouv.vitam.common.SedaVersion;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.server.DbRequestResult;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.SchemaValidationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.guid.GUIDReader;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.administration.AbstractContractModel;
import fr.gouv.vitam.common.model.administration.AccessContractModel;
import fr.gouv.vitam.common.model.administration.ActivationStatus;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.common.AccessContract;
import fr.gouv.vitam.functional.administration.common.Agencies;
import fr.gouv.vitam.functional.administration.common.VitamErrorUtils;
import fr.gouv.vitam.functional.administration.common.counter.SequenceType;
import fr.gouv.vitam.functional.administration.common.counter.VitamCounterService;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialException;
import fr.gouv.vitam.functional.administration.common.server.FunctionalAdminCollections;
import fr.gouv.vitam.functional.administration.common.server.MongoDbAccessAdminImpl;
import fr.gouv.vitam.functional.administration.common.server.MongoDbAccessReferential;
import fr.gouv.vitam.functional.administration.core.backup.FunctionalBackupService;
import fr.gouv.vitam.functional.administration.core.contract.AccessContractValidator;
import fr.gouv.vitam.functional.administration.core.contract.ContractHelper;
import fr.gouv.vitam.functional.administration.core.contract.ContractLogbookService;
import fr.gouv.vitam.functional.administration.core.contract.ContractService;
import fr.gouv.vitam.functional.administration.core.contract.GenericContractValidator;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.metadata.api.exception.MetaDataClientServerException;
import fr.gouv.vitam.metadata.api.exception.MetaDataDocumentSizeException;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import java.io.IOException;
import java.time.format.DateTimeParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.bson.conversions.Bson;

public class AccessContractImpl
implements ContractService<AccessContractModel> {
    public static final String CONTRACT_BACKUP_EVENT = "STP_BACKUP_ACCESS_CONTRACT";
    private static final String DATA_OBJECT_VERSION_INVALID = "Data object version invalid";
    private static final String ROOT_UNIT_INVALID = "RootUnits invalid, should be a list of guid";
    private static final String EXCLUDED_ROOT_UNIT_INVALID = "ExcludedRootUnits invalid, should be a list of guid";
    private static final String ORIGINATING_AGENCIES_INVALID = "OriginatingAgencies invalid, should be a list of guid";
    private static final String THE_ACCESS_CONTRACT_EVERY_DATA_OBJECT_VERSION_MUST_BE_TRUE_OR_FALSE_BUT_NOT = "The Access contract EveryDataObjectVersion must be true or false but not ";
    private static final String THE_ACCESS_CONTRACT_EVERY_ORIGINATING_AGENCY_MUST_BE_TRUE_OR_FALSE_BUT_NOT = "The Access contract EveryOriginatingAgency must be true or false but not ";
    private static final String THE_ACCESS_CONTRACT_STATUS_MUST_BE_ACTIVE_OR_INACTIVE_BUT_NOT = "The Access contract status must be ACTIVE or INACTIVE but not ";
    private static final String DATE_MUST_BE_VALID = "must be a valid date";
    private static final String ACCESS_CONTRACT_NOT_FOUND = "Access contract not found";
    private static final String ACCESS_CONTRACT_IS_MANDATORY_PATAMETER = "The collection of access contracts is mandatory";
    private static final String UPDATE_ACCESS_CONTRACT_MANDATORY_PATAMETER = "access contracts is mandatory";
    private static final String CONTRACTS_IMPORT_EVENT = "STP_IMPORT_ACCESS_CONTRACT";
    private static final String CONTRACT_UPDATE_EVENT = "STP_UPDATE_ACCESS_CONTRACT";
    private static final String EMPTY_REQUIRED_FIELD = "STP_IMPORT_ACCESS_CONTRACT.EMPTY_REQUIRED_FIELD.KO";
    private static final String DUPLICATE_IN_DATABASE = "STP_IMPORT_ACCESS_CONTRACT.IDENTIFIER_DUPLICATION.KO";
    private static final String AGENCY_NOT_FOUND_IN_DATABASE = "STP_IMPORT_ACCESS_CONTRACT.AGENCY_NOT_FOUND.KO";
    private static final String CONTRACT_VALIDATION_ERROR = "STP_IMPORT_ACCESS_CONTRACT.VALIDATION_ERROR.KO";
    private static final String CONTRACT_BAD_REQUEST = "STP_IMPORT_ACCESS_CONTRACT.BAD_REQUEST.KO";
    private static final String UPDATE_CONTRACT_NOT_FOUND = "STP_UPDATE_ACCESS_CONTRACT.CONTRACT_NOT_FOUND.KO";
    private static final String UPDATE_CONTRACT_BAD_REQUEST = "STP_UPDATE_ACCESS_CONTRACT.BAD_REQUEST.KO";
    private static final String UPDATE_VALUE_NOT_IN_ENUM = "STP_UPDATE_ACCESS_CONTRACT.NOT_IN_ENUM.KO";
    private static final String UPDATE_AGENCY_NOT_FOUND = "STP_UPDATE_ACCESS_CONTRACT.AGENCY_NOT_FOUND.KO";
    private static final String UPDATE_KO = "STP_UPDATE_ACCESS_CONTRACT.KO";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AccessContractImpl.class);
    private static final String UND_TENANT = "_tenant";
    private static final String UND_ID = "_id";
    private static final String CONTRACT_KEY = "AccessContract";
    private static final String CONTRACT_CHECK_KEY = "accessContractCheck";
    private final MongoDbAccessAdminImpl mongoAccess;
    private final LogbookOperationsClient logbookClient;
    private final VitamCounterService vitamCounterService;
    private final MetaDataClient metaDataClient;
    private final FunctionalBackupService functionalBackupService;

    public AccessContractImpl(MongoDbAccessAdminImpl mongoAccess, VitamCounterService vitamCounterService) {
        this(mongoAccess, vitamCounterService, MetaDataClientFactory.getInstance().getClient(), LogbookOperationsClientFactory.getInstance().getClient(), new FunctionalBackupService(vitamCounterService));
    }

    @VisibleForTesting
    public AccessContractImpl(MongoDbAccessAdminImpl mongoAccess, VitamCounterService vitamCounterService, MetaDataClient metaDataClient, LogbookOperationsClient logbookClient, FunctionalBackupService functionalBackupService) {
        this.mongoAccess = mongoAccess;
        this.vitamCounterService = vitamCounterService;
        this.metaDataClient = metaDataClient;
        this.functionalBackupService = functionalBackupService;
        this.logbookClient = logbookClient;
    }

    private static Optional<GenericContractValidator.GenericRejectionCause> selectUnits(MetaDataClient metaDataClient, AccessContractModel contract, String contractName, Set<String> checkUnits, String unitType) {
        String[] rootUnitArray = checkUnits.toArray(new String[0]);
        Select select = new Select();
        try {
            select.setQuery(QueryHelper.in((String)BuilderToken.PROJECTIONARGS.ID.exactToken(), (String[])rootUnitArray).setDepthLimit(0));
            select.setProjection(JsonHandler.createObjectNode().set(BuilderToken.PROJECTION.FIELDS.exactToken(), (JsonNode)JsonHandler.createObjectNode().put(BuilderToken.PROJECTIONARGS.ID.exactToken(), 1)));
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            return Optional.of(GenericContractValidator.GenericRejectionCause.rejectExceptionOccurred(contract.getName(), "Error parse query", e));
        }
        ObjectNode queryDsl = select.getFinalSelect();
        try {
            JsonNode resp = metaDataClient.selectUnits((JsonNode)queryDsl);
            RequestResponseOK responseOK = RequestResponseOK.getFromJsonNode((JsonNode)resp);
            List result = responseOK.getResults();
            if (null == result || result.isEmpty()) {
                String guidArrayString = String.join((CharSequence)",", checkUnits);
                switch (unitType) {
                    case "AllUnits": {
                        return Optional.of(GenericContractValidator.GenericRejectionCause.rejectExcludedAndRootUnitsNotFound(contractName, guidArrayString));
                    }
                    case "ExcludedRootUnits": {
                        return Optional.of(GenericContractValidator.GenericRejectionCause.rejectExcludedRootUnitsNotFound(contractName, guidArrayString));
                    }
                }
                return Optional.of(GenericContractValidator.GenericRejectionCause.rejectRootUnitsNotFound(contractName, guidArrayString));
            }
            if (result.size() == checkUnits.size()) {
                return Optional.empty();
            }
            HashSet<String> notFoundRootUnits = new HashSet<String>(checkUnits);
            result.forEach(unit -> notFoundRootUnits.remove(unit.get(VitamFieldsHelper.id()).asText()));
            return Optional.of(GenericContractValidator.GenericRejectionCause.rejectRootUnitsNotFound(contractName, String.join((CharSequence)",", notFoundRootUnits)));
        }
        catch (InvalidParseOperationException | MetaDataClientServerException | MetaDataDocumentSizeException | MetaDataExecutionException e) {
            return Optional.of(GenericContractValidator.GenericRejectionCause.rejectExceptionOccurred(contract.getName(), "Error while select units", e));
        }
    }

    @Override
    public RequestResponse<AccessContractModel> createContracts(List<AccessContractModel> contractModelList) throws VitamException {
        ParametersChecker.checkParameter((String)ACCESS_CONTRACT_IS_MANDATORY_PATAMETER, (Object[])new Object[]{contractModelList});
        if (contractModelList.isEmpty()) {
            return new RequestResponseOK();
        }
        boolean slaveMode = this.vitamCounterService.isSlaveFunctionnalCollectionOnTenant(SequenceType.ACCESS_CONTRACT_SEQUENCE.getCollection(), ParameterHelper.getTenantParameter());
        String operationId = VitamThreadUtils.getVitamSession().getRequestId();
        GUID eip = GUIDReader.getGUID((String)operationId);
        AccessContractValidationService validationService = new AccessContractValidationService(this.metaDataClient);
        ContractLogbookService logbookService = new ContractLogbookService(this.logbookClient, eip, CONTRACTS_IMPORT_EVENT, CONTRACT_UPDATE_EVENT, CONTRACT_KEY, CONTRACT_CHECK_KEY);
        logbookService.logStarted();
        VitamError error = this.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), "Access contract import error").setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
        try {
            for (AccessContractModel acm : contractModelList) {
                if (acm.getId() != null) {
                    error.addToErrors(this.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), GenericContractValidator.GenericRejectionCause.rejectIdNotAllowedInCreate(acm.getName()).getReason()));
                    continue;
                }
                if (validationService.validateContract(acm, acm.getName(), (VitamError<AccessContractModel>)error)) {
                    acm.setId(GUIDFactory.newContractGUID((int)ParameterHelper.getTenantParameter()).getId());
                }
                if (acm.getTenant() == null) {
                    acm.setTenant(ParameterHelper.getTenantParameter());
                }
                if (!slaveMode) continue;
                Optional<GenericContractValidator.GenericRejectionCause> result = validationService.checkEmptyIdentifierSlaveModeValidator().validate(acm, acm.getIdentifier());
                result.ifPresent(genericRejectionCause -> error.addToErrors(this.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), ((GenericContractValidator.GenericRejectionCause)result.get()).getReason()).setMessage(EMPTY_REQUIRED_FIELD)));
            }
            if (error.getErrors() != null && !error.getErrors().isEmpty()) {
                String errorsDetails = error.getErrors().stream().map(VitamError::getDescription).collect(Collectors.joining(","));
                logbookService.logValidationError(errorsDetails, CONTRACTS_IMPORT_EVENT, ((VitamError)error.getErrors().get(0)).getMessage());
                return error;
            }
            ArrayNode contractsToPersist = JsonHandler.createArrayNode();
            for (AccessContractModel acm : contractModelList) {
                JsonNode hashTenant;
                ContractHelper.setIdentifier(slaveMode, (AbstractContractModel)acm, this.vitamCounterService, SequenceType.ACCESS_CONTRACT_SEQUENCE);
                acm.initializeDefaultValue();
                ObjectNode accessContractNode = (ObjectNode)JsonHandler.toJsonNode((Object)acm);
                JsonNode hashId = accessContractNode.remove(VitamFieldsHelper.id());
                if (hashId != null) {
                    accessContractNode.set(UND_ID, hashId);
                }
                if ((hashTenant = accessContractNode.remove(VitamFieldsHelper.tenant())) != null) {
                    accessContractNode.set(UND_TENANT, hashTenant);
                }
                contractsToPersist.add((JsonNode)accessContractNode);
            }
            this.mongoAccess.insertDocuments(contractsToPersist, FunctionalAdminCollections.ACCESS_CONTRACT).close();
            this.functionalBackupService.saveCollectionAndSequence(eip, CONTRACT_BACKUP_EVENT, FunctionalAdminCollections.ACCESS_CONTRACT, eip.toString());
            logbookService.logSuccess();
            return new RequestResponseOK().addAllResults(contractModelList).setHttpCode(Response.Status.CREATED.getStatusCode());
        }
        catch (BadRequestException | SchemaValidationException exp) {
            LOGGER.error(exp);
            String err = "Import access contracts error > " + exp.getMessage();
            logbookService.logValidationError(err, CONTRACTS_IMPORT_EVENT, CONTRACT_BAD_REQUEST);
            return this.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), exp.getMessage()).setDescription(err).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
        }
        catch (Exception exp) {
            LOGGER.error((Throwable)exp);
            String err = "Import access contracts error > " + exp.getMessage();
            logbookService.logFatalError(err, CONTRACTS_IMPORT_EVENT);
            return error.setCode(VitamCode.GLOBAL_INTERNAL_SERVER_ERROR.getItem()).setDescription(err).setHttpCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
    }

    @Override
    public AccessContractModel findByIdentifier(String identifier) throws ReferentialException, InvalidParseOperationException {
        SanityChecker.checkParameter((String[])new String[]{identifier});
        try (DbRequestResult result = ContractHelper.findByIdentifier(identifier, FunctionalAdminCollections.ACCESS_CONTRACT, (MongoDbAccessReferential)this.mongoAccess);){
            List list = result.getDocuments(AccessContract.class, AccessContractModel.class);
            if (list.isEmpty()) {
                AccessContractModel accessContractModel = null;
                return accessContractModel;
            }
            AccessContractModel accessContractModel = (AccessContractModel)list.get(0);
            return accessContractModel;
        }
    }

    @Override
    public RequestResponseOK<AccessContractModel> findContracts(JsonNode queryDsl) throws ReferentialException, InvalidParseOperationException {
        SanityChecker.checkJsonAll((JsonNode)queryDsl);
        try (DbRequestResult result = this.mongoAccess.findDocuments(queryDsl, FunctionalAdminCollections.ACCESS_CONTRACT);){
            RequestResponseOK requestResponseOK = result.getRequestResponseOK(queryDsl, AccessContract.class, AccessContractModel.class);
            return requestResponseOK;
        }
    }

    public void close() {
        this.logbookClient.close();
    }

    @Override
    public RequestResponse<AccessContractModel> updateContract(String identifier, JsonNode queryDsl) throws VitamException {
        String err;
        ParametersChecker.checkParameter((String)UPDATE_ACCESS_CONTRACT_MANDATORY_PATAMETER, (Object[])new Object[]{queryDsl});
        VitamError error = this.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), "Access contract update error").setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
        AccessContractModel accContractModel = this.findByIdentifier(identifier);
        if (accContractModel == null) {
            error.setHttpCode(Response.Status.NOT_FOUND.getStatusCode());
            return error.addToErrors(this.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), ACCESS_CONTRACT_NOT_FOUND + identifier).setMessage(UPDATE_CONTRACT_NOT_FOUND));
        }
        String operationId = VitamThreadUtils.getVitamSession().getRequestId();
        GUID eip = GUIDReader.getGUID((String)operationId);
        AccessContractValidationService validationService = new AccessContractValidationService(this.metaDataClient);
        ContractLogbookService logbookService = new ContractLogbookService(this.logbookClient, eip, CONTRACTS_IMPORT_EVENT, CONTRACT_UPDATE_EVENT, CONTRACT_KEY, CONTRACT_CHECK_KEY);
        RequestResponseOK response = new RequestResponseOK();
        logbookService.logUpdateStarted(accContractModel.getId());
        if (queryDsl == null || !queryDsl.isObject()) {
            return error;
        }
        JsonNode actionNode = queryDsl.get(BuilderToken.GLOBAL.ACTION.exactToken());
        for (JsonNode fieldToSet : actionNode) {
            JsonNode fieldName = fieldToSet.get(BuilderToken.UPDATEACTION.SET.exactToken());
            if (fieldName == null) continue;
            Iterator it = fieldName.fieldNames();
            while (it.hasNext()) {
                String field = (String)it.next();
                JsonNode value = fieldName.findValue(field);
                this.validateUpdateAction(validationService, accContractModel.getName(), (VitamError<AccessContractModel>)error, field, value);
            }
            ((ObjectNode)fieldName).remove("CreationDate");
            ((ObjectNode)fieldName).put("LastUpdate", LocalDateUtil.nowFormatted());
        }
        if (error.getErrors() != null && error.getErrors().size() > 0) {
            String errorsDetails = error.getErrors().stream().map(VitamError::getDescription).collect(Collectors.joining(","));
            logbookService.logValidationError(errorsDetails, CONTRACT_UPDATE_EVENT, ((VitamError)error.getErrors().get(0)).getMessage());
            return error;
        }
        try {
            Map updateDiffs;
            try (DbRequestResult result = this.mongoAccess.updateData(queryDsl, FunctionalAdminCollections.ACCESS_CONTRACT);){
                updateDiffs = result.getDiffs();
                response.addAllResults(result.getDocuments(AccessContract.class, AccessContractModel.class)).setTotal(result.getTotal()).setQuery(queryDsl).setHttpCode(Response.Status.OK.getStatusCode());
            }
            this.functionalBackupService.saveCollectionAndSequence(eip, CONTRACT_BACKUP_EVENT, FunctionalAdminCollections.ACCESS_CONTRACT, accContractModel.getId());
            logbookService.logUpdateSuccess(accContractModel.getId(), identifier, (List)updateDiffs.get(accContractModel.getId()));
            return response;
        }
        catch (BadRequestException | SchemaValidationException exp) {
            LOGGER.error(exp);
            err = "Update access contract error > " + exp.getMessage();
            logbookService.logValidationError(err, CONTRACT_UPDATE_EVENT, UPDATE_CONTRACT_BAD_REQUEST);
            return this.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), exp.getMessage()).setDescription(err).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode());
        }
        catch (Exception exp) {
            LOGGER.error((Throwable)exp);
            err = "Update access contract error > " + exp.getMessage();
            logbookService.logFatalError(err, CONTRACT_UPDATE_EVENT);
            return error.setCode(VitamCode.GLOBAL_INTERNAL_SERVER_ERROR.getItem()).setDescription(err).setHttpCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
    }

    private void validateUpdateAction(AccessContractValidationService validationService, String contractName, VitamError<AccessContractModel> error, String field, JsonNode value) {
        switch (field) {
            case "Status": {
                if (ActivationStatus.ACTIVE.name().equals(value.asText()) || ActivationStatus.INACTIVE.name().equals(value.asText())) break;
                error.addToErrors(this.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), THE_ACCESS_CONTRACT_STATUS_MUST_BE_ACTIVE_OR_INACTIVE_BUT_NOT + value.asText()).setMessage(UPDATE_VALUE_NOT_IN_ENUM));
                break;
            }
            case "LastUpdate": 
            case "CreationDate": 
            case "ActivationDate": 
            case "DeactivationDate": {
                try {
                    LocalDateUtil.getFormattedDateTimeForMongo((String)value.asText());
                }
                catch (DateTimeParseException e) {
                    error.addToErrors(this.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), String.format("%s %s", field, DATE_MUST_BE_VALID)).setMessage(UPDATE_CONTRACT_BAD_REQUEST));
                }
                break;
            }
            case "EveryOriginatingAgency": {
                if (value instanceof BooleanNode) break;
                error.addToErrors(this.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), THE_ACCESS_CONTRACT_EVERY_ORIGINATING_AGENCY_MUST_BE_TRUE_OR_FALSE_BUT_NOT + value.asText()).setMessage(UPDATE_VALUE_NOT_IN_ENUM));
                break;
            }
            case "OriginatingAgencies": {
                if (!value.isArray()) {
                    error.addToErrors(this.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), ORIGINATING_AGENCIES_INVALID + value.asText()).setMessage(UPDATE_VALUE_NOT_IN_ENUM));
                    break;
                }
                try {
                    Set originatingAgencies = (Set)JsonHandler.getFromJsonNode((JsonNode)value, (TypeReference)new TypeReference<Set<String>>(){});
                    AccessContractModel toValidate = new AccessContractModel();
                    toValidate.setOriginatingAgencies(originatingAgencies);
                    Optional<GenericContractValidator.GenericRejectionCause> rejection = validationService.checkExistenceOriginatingAgenciesValidator().validate(toValidate, contractName);
                    rejection.ifPresent(genericRejectionCause -> error.addToErrors(this.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), genericRejectionCause.getReason()).setMessage(UPDATE_AGENCY_NOT_FOUND)));
                }
                catch (InvalidParseOperationException e) {
                    error.addToErrors(this.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), ROOT_UNIT_INVALID + value.asText()));
                }
                break;
            }
            case "EveryDataObjectVersion": {
                if (value instanceof BooleanNode) break;
                error.addToErrors(this.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), THE_ACCESS_CONTRACT_EVERY_DATA_OBJECT_VERSION_MUST_BE_TRUE_OR_FALSE_BUT_NOT + value.asText()).setMessage(UPDATE_VALUE_NOT_IN_ENUM));
                break;
            }
            case "DataObjectVersion": {
                if (this.validateObjectVersion(value)) break;
                error.addToErrors(this.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), DATA_OBJECT_VERSION_INVALID + value.asText()).setMessage(UPDATE_VALUE_NOT_IN_ENUM));
                break;
            }
            case "RootUnits": {
                if (!value.isArray()) {
                    error.addToErrors(this.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), ROOT_UNIT_INVALID + value.asText()).setMessage(UPDATE_KO));
                    break;
                }
                try {
                    Set rootUnits = (Set)JsonHandler.getFromJsonNode((JsonNode)value, Set.class, String.class);
                    AccessContractModel toValidate = new AccessContractModel();
                    toValidate.setRootUnits(rootUnits);
                    Optional<GenericContractValidator.GenericRejectionCause> rejection = validationService.validateExistsArchiveUnits(this.metaDataClient).validate(toValidate, contractName);
                    rejection.ifPresent(genericRejectionCause -> error.addToErrors(this.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), genericRejectionCause.getReason()).setMessage(UPDATE_KO)));
                }
                catch (InvalidParseOperationException e) {
                    error.addToErrors(this.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), ROOT_UNIT_INVALID + value.asText()).setMessage(UPDATE_KO));
                }
                break;
            }
            case "ExcludedRootUnits": {
                if (!value.isArray()) {
                    error.addToErrors(this.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), EXCLUDED_ROOT_UNIT_INVALID + value.asText()).setMessage(UPDATE_KO));
                    break;
                }
                try {
                    Set excludedRootUnits = (Set)JsonHandler.getFromJsonNode((JsonNode)value, Set.class, String.class);
                    AccessContractModel toValidate = new AccessContractModel();
                    toValidate.setExcludedRootUnits(excludedRootUnits);
                    Optional<GenericContractValidator.GenericRejectionCause> rejection = validationService.validateExistsArchiveUnits(this.metaDataClient).validate(toValidate, contractName);
                    rejection.ifPresent(genericRejectionCause -> error.addToErrors(this.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), genericRejectionCause.getReason()).setMessage(UPDATE_KO)));
                    break;
                }
                catch (InvalidParseOperationException e) {
                    error.addToErrors(this.getVitamError(VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), ROOT_UNIT_INVALID + value.asText()).setMessage(UPDATE_KO));
                }
            }
        }
    }

    private boolean validateObjectVersion(JsonNode value) {
        if (!value.isArray()) {
            return false;
        }
        SedaVersion sedaVersion = new SedaVersion();
        try {
            sedaVersion = SedaConfiguration.getSupportedVerion();
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e);
        }
        for (JsonNode node : value) {
            if (sedaVersion.isSupportedVesion(node.asText())) continue;
            return false;
        }
        return true;
    }

    private VitamError<AccessContractModel> getVitamError(String vitamCode, String error) {
        return VitamErrorUtils.getVitamError((String)vitamCode, (String)error, (String)CONTRACT_KEY, (StatusCode)StatusCode.KO, AccessContractModel.class);
    }

    protected static final class AccessContractValidationService {
        private final Map<AccessContractValidator, String> validators;

        public AccessContractValidationService(final MetaDataClient metaDataClient) {
            this.validators = new HashMap<AccessContractValidator, String>(){
                {
                    this.put(this.createMandatoryParamsValidator(), AccessContractImpl.EMPTY_REQUIRED_FIELD);
                    this.put(this.createWrongFieldFormatValidator(), AccessContractImpl.EMPTY_REQUIRED_FIELD);
                    this.put(this.checkExistenceOriginatingAgenciesValidator(), AccessContractImpl.AGENCY_NOT_FOUND_IN_DATABASE);
                    this.put(this.createCheckDuplicateInDatabaseValidator(), AccessContractImpl.DUPLICATE_IN_DATABASE);
                    this.put(this.validateExistsArchiveUnits(metaDataClient), AccessContractImpl.CONTRACT_VALIDATION_ERROR);
                }
            };
        }

        private boolean validateContract(AccessContractModel contract, String jsonFormat, VitamError<AccessContractModel> error) {
            for (AccessContractValidator validator : this.validators.keySet()) {
                Optional<GenericContractValidator.GenericRejectionCause> result = validator.validate(contract, jsonFormat);
                if (!result.isPresent()) continue;
                error.addToErrors(VitamErrorUtils.getVitamError((String)VitamCode.CONTRACT_VALIDATION_ERROR.getItem(), (String)result.get().getReason(), (String)AccessContractImpl.CONTRACT_KEY, (StatusCode)StatusCode.KO, AccessContractModel.class).setMessage(this.validators.get(validator)).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode()));
                return false;
            }
            return true;
        }

        private AccessContractValidator createMandatoryParamsValidator() {
            return (contract, jsonFormat) -> {
                GenericContractValidator.GenericRejectionCause rejection = null;
                if (contract.getName() == null || contract.getName().trim().isEmpty()) {
                    rejection = GenericContractValidator.GenericRejectionCause.rejectMandatoryMissing("Name");
                }
                return rejection == null ? Optional.empty() : Optional.of(rejection);
            };
        }

        private AccessContractValidator createWrongFieldFormatValidator() {
            return (contract, inputList) -> {
                GenericContractValidator.GenericRejectionCause rejection = null;
                String now = LocalDateUtil.nowFormatted();
                if (contract.getStatus() == null) {
                    contract.setStatus(ActivationStatus.INACTIVE);
                }
                try {
                    if (contract.getCreationdate() == null || contract.getCreationdate().trim().isEmpty()) {
                        contract.setCreationdate(now);
                    } else {
                        contract.setCreationdate(LocalDateUtil.getFormattedDateTimeForMongo((String)contract.getCreationdate()));
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error access contract parse dates", (Throwable)e);
                    rejection = GenericContractValidator.GenericRejectionCause.rejectMandatoryMissing("Creationdate");
                }
                try {
                    if (contract.getActivationdate() == null || contract.getActivationdate().trim().isEmpty()) {
                        contract.setActivationdate(now);
                    } else {
                        contract.setActivationdate(LocalDateUtil.getFormattedDateTimeForMongo((String)contract.getActivationdate()));
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error access contract parse dates", (Throwable)e);
                    rejection = GenericContractValidator.GenericRejectionCause.rejectMandatoryMissing("ActivationDate");
                }
                try {
                    if (contract.getDeactivationdate() == null || contract.getDeactivationdate().trim().isEmpty()) {
                        contract.setDeactivationdate(null);
                    } else {
                        contract.setDeactivationdate(LocalDateUtil.getFormattedDateTimeForMongo((String)contract.getDeactivationdate()));
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error access contract parse dates", (Throwable)e);
                    rejection = GenericContractValidator.GenericRejectionCause.rejectMandatoryMissing("deactivationdate");
                }
                contract.setLastupdate(now);
                return rejection == null ? Optional.empty() : Optional.of(rejection);
            };
        }

        private AccessContractValidator checkEmptyIdentifierSlaveModeValidator() {
            return (contract, contractName) -> {
                if (contract.getIdentifier() == null || contract.getIdentifier().isEmpty()) {
                    return Optional.of(GenericContractValidator.GenericRejectionCause.rejectMandatoryMissing("Identifier"));
                }
                return Optional.empty();
            };
        }

        private AccessContractValidator createCheckDuplicateInDatabaseValidator() {
            return (contract, contractName) -> {
                if (ParametersChecker.isNotEmpty((String[])new String[]{contract.getIdentifier()})) {
                    boolean exist;
                    int tenant = ParameterHelper.getTenantParameter();
                    Bson clause = Filters.and((Bson[])new Bson[]{Filters.eq((String)AccessContractImpl.UND_TENANT, (Object)tenant), Filters.eq((String)"Identifier", (Object)contract.getIdentifier())});
                    boolean bl = exist = FunctionalAdminCollections.ACCESS_CONTRACT.getCollection().countDocuments(clause) > 0L;
                    if (exist) {
                        return Optional.of(GenericContractValidator.GenericRejectionCause.rejectDuplicatedInDatabase(contract.getIdentifier()));
                    }
                }
                return Optional.empty();
            };
        }

        private AccessContractValidator checkExistenceOriginatingAgenciesValidator() {
            return (contract, contractName) -> {
                if (null == contract.getOriginatingAgencies() || contract.getOriginatingAgencies().isEmpty()) {
                    return Optional.empty();
                }
                int tenant = ParameterHelper.getTenantParameter();
                Bson clause = Filters.and((Bson[])new Bson[]{Filters.eq((String)AccessContractImpl.UND_TENANT, (Object)tenant), Filters.in((String)"Identifier", (Iterable)contract.getOriginatingAgencies())});
                FindIterable find = FunctionalAdminCollections.AGENCIES.getCollection().find(clause).projection((Bson)new BasicDBObject("Identifier", (Object)1));
                MongoCursor it = find.iterator();
                HashSet notFound = new HashSet(contract.getOriginatingAgencies());
                while (it.hasNext()) {
                    Agencies next = (Agencies)it.next();
                    notFound.remove(next.getIdentifier());
                }
                if (!notFound.isEmpty()) {
                    return Optional.of(GenericContractValidator.GenericRejectionCause.rejectRootUnitsNotFound(contractName, String.join((CharSequence)",", notFound)));
                }
                return Optional.empty();
            };
        }

        private AccessContractValidator validateExistsArchiveUnits(MetaDataClient metaDataClient) {
            return (contract, contractName) -> {
                Set excludeUnits;
                HashSet<String> checkUnits = new HashSet();
                Set includeUnits = contract.getRootUnits() == null ? new HashSet() : contract.getRootUnits();
                Set set = excludeUnits = contract.getExcludedRootUnits() == null ? new HashSet() : contract.getExcludedRootUnits();
                if (!includeUnits.isEmpty() && !excludeUnits.isEmpty()) {
                    checkUnits.addAll(includeUnits);
                    checkUnits.addAll(excludeUnits);
                    checkUnits.removeIf(unit -> unit.trim().isEmpty());
                    if (checkUnits.isEmpty()) {
                        return Optional.empty();
                    }
                    return AccessContractImpl.selectUnits(metaDataClient, contract, contractName, checkUnits, "AllUnits");
                }
                if (!excludeUnits.isEmpty()) {
                    checkUnits = excludeUnits;
                    return AccessContractImpl.selectUnits(metaDataClient, contract, contractName, checkUnits, "ExcludedRootUnits");
                }
                if (!includeUnits.isEmpty()) {
                    checkUnits = includeUnits;
                    return AccessContractImpl.selectUnits(metaDataClient, contract, contractName, checkUnits, "RootUnits");
                }
                return Optional.empty();
            };
        }
    }
}

