/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.validation;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.client.OntologyLoader;
import fr.gouv.vitam.common.database.collections.CachedOntologyLoader;
import fr.gouv.vitam.common.model.MetadataType;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.functional.administration.client.AdminManagementOntologyLoader;
import fr.gouv.vitam.metadata.core.validation.CachedArchiveUnitProfileLoader;
import fr.gouv.vitam.metadata.core.validation.CachedSchemaValidatorLoader;
import fr.gouv.vitam.metadata.core.validation.OntologyValidator;
import fr.gouv.vitam.metadata.core.validation.UnitValidator;
import java.util.Optional;

public final class MetadataValidationProvider {
    private static MetadataValidationProvider INSTANCE = new MetadataValidationProvider();
    private OntologyValidator unitOntologyValidator;
    private OntologyValidator objectGroupOntologyValidator;
    private UnitValidator unitValidator;

    public static MetadataValidationProvider getInstance() {
        return INSTANCE;
    }

    private MetadataValidationProvider() {
    }

    @VisibleForTesting
    public MetadataValidationProvider(OntologyValidator unitOntologyValidator, OntologyValidator objectGroupOntologyValidator, UnitValidator unitValidator) {
        this.unitValidator = unitValidator;
        this.unitOntologyValidator = unitOntologyValidator;
        this.objectGroupOntologyValidator = objectGroupOntologyValidator;
    }

    public void initialize(AdminManagementClientFactory adminManagementClientFactory, int ontologyCacheMaxEntries, int ontologyCacheTimeoutInSeconds, int archiveUnitProfileCacheMaxEntries, int archiveUnitProfileCacheTimeoutInSeconds, int schemaValidatorCacheMaxEntries, int schemaValidatorCacheTimeoutInSeconds) {
        CachedArchiveUnitProfileLoader archiveUnitProfileLoader = new CachedArchiveUnitProfileLoader(adminManagementClientFactory, archiveUnitProfileCacheMaxEntries, archiveUnitProfileCacheTimeoutInSeconds);
        CachedSchemaValidatorLoader schemaValidatorLoader = new CachedSchemaValidatorLoader(schemaValidatorCacheMaxEntries, schemaValidatorCacheTimeoutInSeconds);
        CachedOntologyLoader unitOntologyLoader = new CachedOntologyLoader(ontologyCacheMaxEntries, ontologyCacheTimeoutInSeconds, (OntologyLoader)new AdminManagementOntologyLoader(adminManagementClientFactory, Optional.of(MetadataType.UNIT.getName())));
        CachedOntologyLoader objectGroupOntologyLoader = new CachedOntologyLoader(ontologyCacheMaxEntries, ontologyCacheTimeoutInSeconds, (OntologyLoader)new AdminManagementOntologyLoader(adminManagementClientFactory, Optional.of(MetadataType.OBJECTGROUP.getName())));
        this.unitOntologyValidator = new OntologyValidator((OntologyLoader)unitOntologyLoader);
        this.objectGroupOntologyValidator = new OntologyValidator((OntologyLoader)objectGroupOntologyLoader);
        this.unitValidator = new UnitValidator(archiveUnitProfileLoader, schemaValidatorLoader);
    }

    public OntologyValidator getUnitOntologyValidator() {
        return this.unitOntologyValidator;
    }

    public OntologyValidator getObjectGroupOntologyValidator() {
        return this.objectGroupOntologyValidator;
    }

    public UnitValidator getUnitValidator() {
        return this.unitValidator;
    }
}

