/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.builder.query.BooleanQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.parser.query.ParserTokens;
import fr.gouv.vitam.common.database.parser.request.multiple.SelectParserMultiple;
import fr.gouv.vitam.common.database.utils.ScrollSpliterator;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.i18n.VitamLogbookMessages;
import fr.gouv.vitam.common.iterables.SpliteratorIterator;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.DeleteGotVersionsRequest;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.objectgroup.ObjectGroupResponse;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleUnitParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.metadata.api.exception.MetaDataClientServerException;
import fr.gouv.vitam.metadata.api.exception.MetaDataDocumentSizeException;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.distribution.JsonLineModel;
import fr.gouv.vitam.worker.core.distribution.JsonLineWriter;
import fr.gouv.vitam.worker.core.plugin.ScrollSpliteratorHelper;
import fr.gouv.vitam.worker.core.utils.GroupByObjectIterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class PluginHelper {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PluginHelper.class);

    private PluginHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static ItemStatus buildItemStatus(String action, StatusCode statusCode) {
        return PluginHelper.buildItemStatus(action, statusCode, null);
    }

    public static <TEventDetails> ItemStatus buildItemStatus(String action, StatusCode statusCode, TEventDetails eventDetails) {
        ItemStatus itemStatus = new ItemStatus(action);
        itemStatus.increment(statusCode);
        PluginHelper.setEvDetData(itemStatus, eventDetails);
        return new ItemStatus(action).setItemsStatus(action, itemStatus);
    }

    public static ItemStatus buildItemStatusWithMessage(String action, StatusCode statusCode, String message) {
        ItemStatus itemStatus = new ItemStatus(action);
        itemStatus.increment(statusCode);
        itemStatus.setMessage(message);
        PluginHelper.setEvDetData(itemStatus, EventDetails.of(message));
        return new ItemStatus(action).setItemsStatus(action, itemStatus).setMessage(message);
    }

    public static <TEventDetails> ItemStatus buildItemStatusWithMasterData(String action, StatusCode statusCode, TEventDetails eventDetails, Object masterDataValue) {
        ItemStatus itemStatus = new ItemStatus(action);
        itemStatus.increment(statusCode);
        PluginHelper.setEvDetData(itemStatus, eventDetails);
        itemStatus.setMasterData(LogbookParameterName.eventDetailData.name(), masterDataValue);
        return new ItemStatus(action).setItemsStatus(action, itemStatus);
    }

    public static <T> ItemStatus buildItemStatusSubItems(String itemId, Stream<String> subItemIds, StatusCode statusCode, T eventDetails) {
        ItemStatus itemStatus = new ItemStatus(itemId);
        itemStatus.increment(statusCode);
        PluginHelper.setEvDetData(itemStatus, eventDetails);
        Map<String, ItemStatus> obIds = subItemIds.collect(Collectors.toMap(id -> id, id -> new ItemStatus(itemId)));
        itemStatus.setSubTasksStatus(obIds);
        return new ItemStatus(itemId).setItemsStatus(itemId, itemStatus);
    }

    private static <TEventDetails> void setEvDetData(ItemStatus itemStatus, TEventDetails eventDetails) {
        if (eventDetails != null) {
            try {
                itemStatus.setEvDetailData(JsonHandler.unprettyPrint((Object)JsonHandler.toJsonNode(eventDetails)));
            }
            catch (InvalidParseOperationException e1) {
                throw new VitamRuntimeException("Could not serialize event details" + eventDetails, (Throwable)e1);
            }
        }
    }

    public static ObjectNode eventDetails(Throwable e) {
        return JsonHandler.createObjectNode().put("error", e.getMessage());
    }

    public static List<ItemStatus> buildBulkItemStatus(WorkerParameters param, String action, StatusCode statusCode) {
        ArrayList<ItemStatus> itemStatuses = new ArrayList<ItemStatus>();
        for (int i = 0; i < param.getObjectNameList().size(); ++i) {
            ItemStatus itemStatus = new ItemStatus(action);
            itemStatus.increment(statusCode);
            ItemStatus itemsStatus = new ItemStatus(action).setItemsStatus(action, itemStatus);
            itemStatuses.add(itemsStatus);
        }
        return itemStatuses;
    }

    public static <TEventDetails> List<ItemStatus> buildBulkItemStatus(WorkerParameters param, String action, StatusCode statusCode, TEventDetails eventDetails) {
        ArrayList<ItemStatus> itemStatuses = new ArrayList<ItemStatus>();
        for (int i = 0; i < param.getObjectNameList().size(); ++i) {
            ItemStatus itemStatus = new ItemStatus(action);
            itemStatus.increment(statusCode);
            ItemStatus itemsStatus = new ItemStatus(action).setItemsStatus(action, itemStatus);
            PluginHelper.setEvDetData(itemStatus, eventDetails);
            itemStatuses.add(itemsStatus);
        }
        return itemStatuses;
    }

    public static <TEventDetails> LogbookLifeCycleUnitParameters createParameters(GUID eventIdentifierProcess, StatusCode logbookOutcome, GUID objectIdentifier, String action, TEventDetails eventDetails, LogbookTypeProcess logbookTypeProcess) {
        GUID updateGuid = GUIDFactory.newEventGUID((int)ParameterHelper.getTenantParameter());
        LogbookLifeCycleUnitParameters parameters = LogbookParameterHelper.newLogbookLifeCycleUnitParameters((GUID)updateGuid, (String)VitamLogbookMessages.getEventTypeLfc((String)action), (GUID)eventIdentifierProcess, (LogbookTypeProcess)logbookTypeProcess, (StatusCode)logbookOutcome, (String)VitamLogbookMessages.getOutcomeDetailLfc((String)action, (StatusCode)logbookOutcome), (String)VitamLogbookMessages.getCodeLfc((String)action, (StatusCode)logbookOutcome), (GUID)objectIdentifier);
        if (eventDetails != null) {
            try {
                parameters.putParameterValue(LogbookParameterName.eventDetailData, JsonHandler.unprettyPrint((Object)JsonHandler.toJsonNode(eventDetails)));
            }
            catch (InvalidParseOperationException e1) {
                throw new VitamRuntimeException("Could not serialize event details" + eventDetails);
            }
        }
        return parameters;
    }

    public static InputStream createUnitsByGotFile(MetaDataClient metaDataClient, DeleteGotVersionsRequest deleteGotVersionsRequest, HandlerIO handler) throws VitamException {
        SelectMultiQuery selectMultiQuery = PluginHelper.prepareUnitsWithObjectGroupsQuery(deleteGotVersionsRequest.getDslQuery());
        ScrollSpliterator<JsonNode> scrollRequest = ScrollSpliteratorHelper.createUnitScrollSplitIterator(metaDataClient, selectMultiQuery);
        SpliteratorIterator iterator = new SpliteratorIterator(scrollRequest);
        Iterator<Pair<String, String>> gotIdUnitIdIterator = PluginHelper.getGotIdUnitIdIterator((Iterator<JsonNode>)iterator);
        UnmodifiableIterator bulksUnitsByObjectGroup = Iterators.partition((Iterator)new GroupByObjectIterator(gotIdUnitIdIterator), (int)VitamConfiguration.getBatchSize());
        return PluginHelper.generateUnitsByGotFile((Iterator<List<Pair<String, List<String>>>>)bulksUnitsByObjectGroup, handler);
    }

    private static SelectMultiQuery prepareUnitsWithObjectGroupsQuery(JsonNode initialQuery) {
        try {
            SelectParserMultiple parser = new SelectParserMultiple();
            parser.parse(initialQuery);
            SelectMultiQuery selectMultiQuery = parser.getRequest();
            selectMultiQuery.resetUsageProjection();
            selectMultiQuery.addUsedProjection(new String[]{ParserTokens.PROJECTIONARGS.ID.exactToken(), ParserTokens.PROJECTIONARGS.OBJECT.exactToken()});
            selectMultiQuery.addOrderByAscFilter(new String[]{ParserTokens.PROJECTIONARGS.OBJECT.exactToken()});
            ArrayList queryList = new ArrayList(parser.getRequest().getQueries());
            if (queryList.isEmpty()) {
                selectMultiQuery.addQueries(new Query[]{QueryHelper.and().add(new Query[]{QueryHelper.exists((String)ParserTokens.PROJECTIONARGS.OBJECT.exactToken())}).setDepthLimit(0)});
                return selectMultiQuery;
            }
            Query query = (Query)queryList.get(queryList.size() - 1);
            BooleanQuery restrictedQuery = QueryHelper.and().add(new Query[]{QueryHelper.exists((String)ParserTokens.PROJECTIONARGS.OBJECT.exactToken()), query});
            parser.getRequest().getQueries().set(queryList.size() - 1, restrictedQuery);
            return selectMultiQuery;
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Iterator<Pair<String, String>> getGotIdUnitIdIterator(Iterator<JsonNode> iterator) {
        return IteratorUtils.transformedIterator(iterator, item -> new ImmutablePair((Object)item.get(ParserTokens.PROJECTIONARGS.OBJECT.exactToken()).asText(), (Object)item.get(ParserTokens.PROJECTIONARGS.ID.exactToken()).asText()));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static InputStream generateUnitsByGotFile(Iterator<List<Pair<String, List<String>>>> unitsByObjectGroup, HandlerIO handler) throws VitamException {
        File unitsByGotTempFile = handler.getNewLocalFile("unitsByGotTempFile.jsonl");
        try (FileOutputStream outputStream = new FileOutputStream(unitsByGotTempFile);){
            FileInputStream fileInputStream;
            try (JsonLineWriter writer = new JsonLineWriter((OutputStream)outputStream);){
                while (unitsByObjectGroup.hasNext()) {
                    List<Pair<String, List<String>>> unitsByObjectGroupByRange = unitsByObjectGroup.next();
                    for (Pair<String, List<String>> unitsByGot : unitsByObjectGroupByRange) {
                        writer.addEntry(new JsonLineModel((String)unitsByGot.getLeft(), null, JsonHandler.toJsonNode((Object)unitsByGot.getRight())));
                    }
                }
                fileInputStream = new FileInputStream(unitsByGotTempFile);
            }
            return fileInputStream;
        }
        catch (IOException e) {
            throw new VitamException("Could not save distribution file", (Throwable)e);
        }
    }

    public static Map<String, ObjectGroupResponse> getObjectGroups(String[] gotIds, MetaDataClient metadataClient) throws ProcessingException {
        try {
            Select select = new Select();
            select.setQuery((Query)QueryHelper.in((String)"#id", (String[])gotIds));
            ObjectNode finalSelect = select.getFinalSelect();
            JsonNode response = metadataClient.selectObjectGroups((JsonNode)finalSelect);
            List resultsResponse = (List)JsonHandler.getFromJsonNode((JsonNode)response.get("$results"), (TypeReference)new TypeReference<List<ObjectGroupResponse>>(){});
            if (resultsResponse.isEmpty() || resultsResponse.size() != gotIds.length) {
                throw new IllegalStateException("Object groups are missing from database!");
            }
            return resultsResponse.stream().collect(Collectors.toMap(ObjectGroupResponse::getId, objectGroup -> objectGroup));
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException | MetaDataClientServerException | MetaDataDocumentSizeException | MetaDataExecutionException e) {
            throw new ProcessingException("A problem occured when retrieving ObjectGroups :  " + e.getMessage());
        }
    }

    public static class EventDetails {
        public String event;
        public String secondEvent;

        private EventDetails(String event) {
            this.event = event;
        }

        private EventDetails(String event, String secondEvent) {
            this.event = event;
            this.secondEvent = secondEvent;
        }

        public static EventDetails of(String event) {
            return new EventDetails(event);
        }

        public static EventDetails of(String event, String secondEvent) {
            return new EventDetails(event, secondEvent);
        }
    }
}

