/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.utils;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.ProcessQuery;
import fr.gouv.vitam.common.model.ProcessState;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.processing.ProcessDetail;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClient;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClientFactory;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class LightweightWorkflowLock {
    private final ProcessingManagementClientFactory processingManagementClientFactory;

    public LightweightWorkflowLock() {
        this(ProcessingManagementClientFactory.getInstance());
    }

    @VisibleForTesting
    LightweightWorkflowLock(ProcessingManagementClientFactory processingManagementClientFactory) {
        this.processingManagementClientFactory = processingManagementClientFactory;
    }

    public List<ProcessDetail> listConcurrentWorkflows(List<String> workflowIds, String currentProcessId) throws VitamClientException {
        try (ProcessingManagementClient client = this.processingManagementClientFactory.getClient();){
            ProcessQuery query = new ProcessQuery();
            query.setStates(Arrays.stream(ProcessState.values()).filter(state -> state.compareTo((Enum)ProcessState.COMPLETED) < 0).map(Enum::name).collect(Collectors.toList()));
            query.setWorkflows(workflowIds);
            RequestResponse processDetailRequestResponse = client.listOperationsDetails(query);
            if (!processDetailRequestResponse.isOk()) {
                VitamError error = (VitamError)processDetailRequestResponse;
                throw new VitamClientException("Could not check concurrent workflows " + error.getDescription() + " - " + error.getMessage());
            }
            List processDetails = ((RequestResponseOK)processDetailRequestResponse).getResults();
            List<ProcessDetail> list = processDetails.stream().filter(processDetail -> !currentProcessId.equals(processDetail.getOperationId())).collect(Collectors.toList());
            return list;
        }
    }
}

