/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.utils;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.worker.common.HandlerIO;
import java.io.File;

public class JsonLineDataBase {
    private final HandlerIO handlerIO;
    private final String baseDir;

    public JsonLineDataBase(HandlerIO handlerIO, String baseDir) {
        this.handlerIO = handlerIO;
        this.baseDir = baseDir;
    }

    public void write(String id, JsonNode object) {
        File file = this.handlerIO.getNewLocalFile(this.baseDir + File.separator + id + ".json");
        try {
            JsonHandler.writeAsFile((Object)object, (File)file);
        }
        catch (InvalidParseOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public JsonNode read(String id) {
        try {
            File file = this.handlerIO.getNewLocalFile(this.baseDir + File.separator + id + ".json");
            return JsonHandler.getFromFile((File)file);
        }
        catch (InvalidParseOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

