/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.utils;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.rules.InheritedRuleCategoryResponseModel;
import fr.gouv.vitam.common.model.rules.InheritedRuleResponseModel;
import fr.gouv.vitam.common.model.rules.UnitInheritedRulesResponseModel;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class HoldRuleUtils {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(HoldRuleUtils.class);

    private HoldRuleUtils() {
    }

    public static InheritedRuleCategoryResponseModel parseHoldRuleCategory(JsonNode unit) throws ProcessingStatusException {
        try {
            JsonNode inheritedRules = unit.get("InheritedRules");
            UnitInheritedRulesResponseModel unitInheritedRulesResponseModel = (UnitInheritedRulesResponseModel)JsonHandler.getFromJsonNode((JsonNode)inheritedRules, UnitInheritedRulesResponseModel.class);
            return (InheritedRuleCategoryResponseModel)unitInheritedRulesResponseModel.getRuleCategories().get("HoldRule");
        }
        catch (InvalidParseOperationException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not parse unit information", e);
        }
    }

    public static Set<InheritedRuleResponseModel> listActiveHoldRules(String unitId, List<InheritedRuleResponseModel> holdRules, LocalDate expirationDate) {
        if (holdRules.isEmpty()) {
            LOGGER.debug("No hold rules found for unit " + unitId);
            return Collections.emptySet();
        }
        Set<InheritedRuleResponseModel> activeHoldRules = holdRules.stream().filter(holdRule -> {
            LocalDate endDate = LocalDateUtil.parseDate((String)holdRule.getEndDate());
            return endDate == null || expirationDate.isBefore(endDate);
        }).collect(Collectors.toSet());
        if (activeHoldRules.isEmpty()) {
            LOGGER.debug("No active hold rule as of " + expirationDate + " for unit " + unitId);
        } else {
            LOGGER.info("Active hold rule(s) found " + activeHoldRules + " for unit " + unitId);
        }
        return activeHoldRules;
    }
}

