/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class FastValueAccessMap<K, V>
implements Map<K, V> {
    private final Object NULL_VALUE_OBJ = new Object();
    Map<Object, Integer> valuesReferenceCounter = new HashMap<Object, Integer>();
    Map<K, V> innerMap = new HashMap();

    @Override
    public int size() {
        return this.innerMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.innerMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.innerMap.containsKey(o);
    }

    @Override
    public boolean containsValue(Object v) {
        return this.valuesReferenceCounter.containsKey(this.wrapNullValue(v));
    }

    @Override
    public V get(Object o) {
        return this.innerMap.get(o);
    }

    @Override
    public V put(K k, V v) {
        if (this.innerMap.containsKey(k)) {
            V oldValue = this.innerMap.get(k);
            this.removeValue(oldValue);
        }
        this.addValue(v);
        return this.innerMap.put(k, v);
    }

    @Override
    public V remove(Object k) {
        if (this.innerMap.containsKey(k)) {
            V oldValue = this.innerMap.get(k);
            this.removeValue(oldValue);
        }
        return this.innerMap.remove(k);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.innerMap.clear();
        this.valuesReferenceCounter.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.innerMap.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.innerMap.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.innerMap.entrySet();
    }

    private void addValue(V value) {
        Object wrappedValue = this.wrapNullValue(value);
        this.valuesReferenceCounter.merge(wrappedValue, 1, Integer::sum);
    }

    private void removeValue(V value) {
        Object wrappedValue = this.wrapNullValue(value);
        Integer cpt = this.valuesReferenceCounter.get(wrappedValue);
        if (cpt == 1) {
            this.valuesReferenceCounter.remove(wrappedValue);
        } else {
            this.valuesReferenceCounter.put(wrappedValue, cpt - 1);
        }
    }

    private Object wrapNullValue(Object v) {
        if (v == null) {
            return this.NULL_VALUE_OBJ;
        }
        return v;
    }
}

