/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.utils;

import fr.gouv.vitam.common.model.administration.DataObjectVersionType;
import fr.gouv.vitam.common.model.dip.DataObjectVersions;
import fr.gouv.vitam.common.model.dip.QualifierVersion;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class DataObjectVersionToPatternsConvertor {
    private DataObjectVersionToPatternsConvertor() {
    }

    public static Map<DataObjectVersionType, Set<QualifierVersion>> computeDataObjectVersionsPatterns(@Nullable DataObjectVersions data) {
        DataObjectVersions nonNullPData = Optional.ofNullable(data).orElse(new DataObjectVersions(Set.of()));
        Set dataObjectVersions = nonNullPData.getDataObjectVersions();
        Map dataObjectVersionsPatterns = nonNullPData.getDataObjectVersionsPatterns();
        if (dataObjectVersions.isEmpty()) {
            return Objects.requireNonNullElseGet(dataObjectVersionsPatterns, () -> Arrays.stream(DataObjectVersionType.values()).collect(Collectors.toMap(Function.identity(), s -> Set.of(QualifierVersion.LAST))));
        }
        return dataObjectVersions.stream().map(DataObjectVersionType::fromName).collect(Collectors.toMap(Function.identity(), s -> Set.of(QualifierVersion.LAST)));
    }
}

