/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.transfer.reply.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.distribution.JsonLineGenericIterator;
import fr.gouv.vitam.worker.core.distribution.JsonLineModel;
import fr.gouv.vitam.worker.core.distribution.JsonLineWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;

public class SortedLevelJsonLineWriter
implements AutoCloseable {
    private static final TypeReference<JsonLineModel> TYPE_REFERENCE = new TypeReference<JsonLineModel>(){};
    private static final int MAX_LEVELS = 100;
    private final HandlerIO handler;
    private Map<Integer, File> filesByLevel = new HashMap<Integer, File>();
    private Map<Integer, JsonLineWriter> writersByLevel = new HashMap<Integer, JsonLineWriter>();

    public SortedLevelJsonLineWriter(HandlerIO handler) {
        this.handler = handler;
    }

    public void addEntry(JsonLineModel line) throws IOException {
        if (line.getDistribGroup() == null) {
            throw new IllegalArgumentException("Null distribution group " + JsonHandler.unprettyPrint((Object)line));
        }
        if (!this.filesByLevel.containsKey(line.getDistribGroup())) {
            if (this.filesByLevel.size() >= 100) {
                throw new IllegalStateException("Too many levels 100");
            }
            File newLocalFile = this.handler.getNewLocalFile(GUIDFactory.newGUID().toString());
            this.filesByLevel.put(line.getDistribGroup(), newLocalFile);
            this.writersByLevel.put(line.getDistribGroup(), new JsonLineWriter((OutputStream)new FileOutputStream(newLocalFile)));
        }
        JsonLineWriter jsonLineWriter = this.writersByLevel.get(line.getDistribGroup());
        jsonLineWriter.addEntry(line);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportToWorkspace(String filename, boolean ascending) throws IOException, ProcessingException {
        for (JsonLineWriter value : this.writersByLevel.values()) {
            value.close();
        }
        File combinedSortedJsonLineFile = this.handler.getNewLocalFile(GUIDFactory.newGUID().toString());
        try {
            try (FileOutputStream outputStream = new FileOutputStream(combinedSortedJsonLineFile);
                 JsonLineWriter writer = new JsonLineWriter((OutputStream)outputStream);){
                List levels = this.filesByLevel.keySet().stream().sorted(ascending ? Comparator.naturalOrder() : Comparator.reverseOrder()).collect(Collectors.toList());
                for (Integer level : levels) {
                    File fileLevel = this.filesByLevel.get(level);
                    try (FileInputStream is = new FileInputStream(fileLevel);
                         JsonLineGenericIterator lineGenericIterator = new JsonLineGenericIterator((InputStream)is, TYPE_REFERENCE);){
                        while (lineGenericIterator.hasNext()) {
                            writer.addEntry((JsonLineModel)lineGenericIterator.next());
                        }
                    }
                }
            }
            this.handler.transferFileToWorkspace(filename, combinedSortedJsonLineFile, true, false);
        }
        finally {
            for (File file : this.filesByLevel.values()) {
                FileUtils.deleteQuietly((File)file);
            }
        }
    }

    @Override
    public void close() throws IOException {
        for (JsonLineWriter value : this.writersByLevel.values()) {
            value.close();
        }
        for (File file : this.filesByLevel.values()) {
            FileUtils.deleteQuietly((File)file);
        }
    }
}

