/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.transfer.reply;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.culture.archivesdefrance.seda.v2.IdentifierType;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.logbook.LogbookEventOperation;
import fr.gouv.vitam.common.model.logbook.LogbookOperation;
import fr.gouv.vitam.common.utils.SupportedSedaVersions;
import fr.gouv.vitam.common.xml.XmlNamespaceUtils;
import fr.gouv.vitam.logbook.common.exception.LogbookClientException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientNotFoundException;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.utils.AtrParser;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;
import javax.xml.bind.UnmarshalException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang3.StringUtils;

public class VerifyAtrPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(VerifyAtrPlugin.class);
    public static final String PLUGIN_NAME = "VERIFY_ARCHIVAL_TRANSFER_REPLY";
    public static final String ATR_FOR_TRANSFER_REPLY = "ATR-for-transfer-reply-in-workspace.xml";
    private final LogbookOperationsClientFactory logbookOperationsClientFactory;
    private final AtrParser atrParser;

    public VerifyAtrPlugin() {
        this(LogbookOperationsClientFactory.getInstance(), new AtrParser());
    }

    @VisibleForTesting
    public VerifyAtrPlugin(LogbookOperationsClientFactory logbookOperationsClientFactory, AtrParser atrParser) {
        this.logbookOperationsClientFactory = logbookOperationsClientFactory;
        this.atrParser = atrParser;
    }

    /*
     * Exception decompiling
     */
    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private InputStream getTransformedXmlAsInputStream(HandlerIO handlerIO) throws TransformerException, IOException, ContentAddressableStorageNotFoundException, ContentAddressableStorageServerException, ProcessingStatusException, XMLStreamException, UnmarshalException {
        File originalATR = handlerIO.getFileFromWorkspace(ATR_FOR_TRANSFER_REPLY);
        File transformedATR = handlerIO.getNewLocalFile("transformed-ATR-for-transfer-reply-in-workspace.xml");
        SupportedSedaVersions sedaVersion = VerifyAtrPlugin.parseSedaVersion(originalATR);
        try (FileInputStream originalATRInputStream = new FileInputStream(originalATR);
             FileOutputStream transformedATROutputStream = new FileOutputStream(transformedATR);){
            XmlNamespaceUtils.transformXMLNamespace((InputStream)originalATRInputStream, (OutputStream)transformedATROutputStream, (String)sedaVersion.getNamespaceURI(), (String)"fr:gouv:culture:archivesdefrance:seda:v2");
        }
        return new FileInputStream(transformedATR);
    }

    private static SupportedSedaVersions parseSedaVersion(File originalATR) throws IOException, XMLStreamException, UnmarshalException {
        try (FileInputStream originalATRInputStream = new FileInputStream(originalATR);){
            String xmlNamespace = XmlNamespaceUtils.parseXmlNamespace((InputStream)originalATRInputStream);
            Optional supportedSedaVersionByXmlNamespace = SupportedSedaVersions.getSupportedSedaVersionByXmlNamespace((String)xmlNamespace);
            if (supportedSedaVersionByXmlNamespace.isEmpty()) {
                LOGGER.error("Unsupported ATR or seda version. Unknown xml namespace: '" + xmlNamespace + "'");
                throw new UnmarshalException("Invalid ATR. Unsupported namespace");
            }
            SupportedSedaVersions supportedSedaVersions = (SupportedSedaVersions)supportedSedaVersionByXmlNamespace.get();
            return supportedSedaVersions;
        }
    }

    private boolean hasReplyCode(String replyCode) {
        return replyCode.equals("OK") || replyCode.equals("WARNING");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasExistingTransferOperation(IdentifierType messageRequestIdentifier) throws InvalidParseOperationException, LogbookClientException {
        if (messageRequestIdentifier == null) return false;
        if (StringUtils.isBlank((CharSequence)messageRequestIdentifier.getValue())) {
            return false;
        }
        try (LogbookOperationsClient client = this.logbookOperationsClientFactory.getClient();){
            JsonNode result = client.selectOperationById(messageRequestIdentifier.getValue());
            RequestResponseOK resultResponseOk = RequestResponseOK.getFromJsonNode((JsonNode)result);
            if (resultResponseOk.isEmpty() || !resultResponseOk.isOk()) {
                boolean bl = false;
                return bl;
            }
            LogbookOperation transferOperation = (LogbookOperation)JsonHandler.getFromJsonNode((JsonNode)((JsonNode)resultResponseOk.getFirstResult()), LogbookOperation.class);
            if (!transferOperation.getEvType().equals(LogbookTypeProcess.ARCHIVE_TRANSFER.name())) {
                boolean bl = false;
                return bl;
            }
            List events = transferOperation.getEvents();
            if (events.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            LogbookEventOperation lastTransferEventOperation = (LogbookEventOperation)events.get(events.size() - 1);
            if (lastTransferEventOperation.getOutcome().equals(StatusCode.OK.name())) return true;
            if (lastTransferEventOperation.getOutcome().equals(StatusCode.WARNING.name())) return true;
            boolean bl = false;
            return bl;
        }
        catch (LogbookClientNotFoundException e) {
            return false;
        }
    }

    private void closeXmlReader(XMLStreamReader xmlStreamReader) throws ProcessingException {
        try {
            if (xmlStreamReader != null) {
                xmlStreamReader.close();
            }
        }
        catch (XMLStreamException e) {
            throw new ProcessingException((Throwable)e);
        }
    }
}

