/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.transfer.reply;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import fr.gouv.culture.archivesdefrance.seda.v2.ArchiveTransferReplyType;
import fr.gouv.culture.archivesdefrance.seda.v2.IdentifierType;
import fr.gouv.culture.archivesdefrance.seda.v2.OrganizationType;
import fr.gouv.vitam.batch.report.model.entry.TransferReplyUnitReportEntry;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.accesslog.AccessLogUtils;
import fr.gouv.vitam.common.collection.CloseableIterator;
import fr.gouv.vitam.common.collection.CloseableIteratorUtils;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.stream.StreamUtils;
import fr.gouv.vitam.common.stream.VitamAsyncInputStream;
import fr.gouv.vitam.common.utils.BufferedConsumer;
import fr.gouv.vitam.metadata.api.exception.MetaDataClientServerException;
import fr.gouv.vitam.metadata.api.exception.MetaDataDocumentSizeException;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageUnavailableDataFromAsyncOfferClientException;
import fr.gouv.vitam.storage.engine.common.exception.StorageNotFoundException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.distribution.JsonLineGenericIterator;
import fr.gouv.vitam.worker.core.distribution.JsonLineModel;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.transfer.reply.TransferReplyReportService;
import fr.gouv.vitam.worker.core.plugin.transfer.reply.TransferReplyUnitStatus;
import fr.gouv.vitam.worker.core.plugin.transfer.reply.model.TransferReplyContext;
import fr.gouv.vitam.worker.core.plugin.transfer.reply.utils.SortedLevelJsonLineWriter;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.SetUtils;

public class TransferReplyUnitPreparationHandler
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(TransferReplyUnitPreparationHandler.class);
    private static final String TRANSFER_REPLY_UNIT_PREPARATION = "TRANSFER_REPLY_UNIT_PREPARATION";
    private static final int TRANSFER_REPLY_CONTEXT_IN_RANK = 0;
    private static final int TRANSFER_REPLY_ATR_RANK = 1;
    private static final String UNITS_TO_DELETE_JSONL = "units_to_delete.jsonl";
    public static final TypeReference<JsonLineModel> JSON_NODE_TYPE_REFERENCE = new TypeReference<JsonLineModel>(){};
    public static final String PERSISTENT_IDENTIFIER_FIELD = "PersistentIdentifier";
    public static final String ARCHIVAL_AGENCY_IDENTIFIER = "#archivalAgencyIdentifier";
    private final MetaDataClientFactory metaDataClientFactory;
    private final StorageClientFactory storageClientFactory;
    private final TransferReplyReportService transferReplyReportService;

    public TransferReplyUnitPreparationHandler() {
        this(MetaDataClientFactory.getInstance(), StorageClientFactory.getInstance(), new TransferReplyReportService());
    }

    @VisibleForTesting
    TransferReplyUnitPreparationHandler(MetaDataClientFactory metaDataClientFactory, StorageClientFactory storageClientFactory, TransferReplyReportService transferReplyReportService) {
        this.metaDataClientFactory = metaDataClientFactory;
        this.storageClientFactory = storageClientFactory;
        this.transferReplyReportService = transferReplyReportService;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        ItemStatus itemStatus;
        block8: {
            CloseableIterator<String> transferUnitIdIterator = this.loadUnitIdsFromTransferReport(handler);
            try {
                this.exportUnitDistributionFiles(transferUnitIdIterator, handler);
                LOGGER.info("Transfer reply unit preparation succeeded");
                itemStatus = PluginHelper.buildItemStatus(TRANSFER_REPLY_UNIT_PREPARATION, StatusCode.OK, null);
                if (transferUnitIdIterator == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (transferUnitIdIterator != null) {
                        try {
                            transferUnitIdIterator.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ProcessingStatusException e) {
                    LOGGER.error("Transfer reply unit preparation failed with status [" + e.getStatusCode() + "]", (Throwable)e);
                    return PluginHelper.buildItemStatus(TRANSFER_REPLY_UNIT_PREPARATION, e.getStatusCode(), null);
                }
            }
            transferUnitIdIterator.close();
        }
        return itemStatus;
    }

    private void exportUnitDistributionFiles(CloseableIterator<String> transferUnitIdIterator, HandlerIO handler) throws ProcessingStatusException {
        ArchiveTransferReplyType archiveTransferReplyType = (ArchiveTransferReplyType)handler.getInput(1);
        try (MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();
             BufferedConsumer<TransferReplyUnitReportEntry> reportAppender = this.createReportAppender(handler.getContainerName());
             SortedLevelJsonLineWriter unitToPurgeWriter = new SortedLevelJsonLineWriter(handler);){
            UnmodifiableIterator bulkUnitIds = Iterators.partition(transferUnitIdIterator, (int)VitamConfiguration.getBatchSize());
            while (bulkUnitIds.hasNext()) {
                HashSet<String> unitIds = new HashSet<String>((Collection)bulkUnitIds.next());
                List<JsonNode> jsonUnits = this.selectUnits(metaDataClient, unitIds);
                Set foundUnitIds = jsonUnits.stream().map(unit -> unit.get(VitamFieldsHelper.id()).asText()).collect(Collectors.toSet());
                SetUtils.SetView notFoundUnitIds = SetUtils.difference(unitIds, foundUnitIds);
                for (String notFoundUnitId : notFoundUnitIds) {
                    reportAppender.accept((Object)new TransferReplyUnitReportEntry(notFoundUnitId, TransferReplyUnitStatus.ALREADY_DELETED.name(), null));
                }
                for (JsonNode unit2 : jsonUnits) {
                    String unitId = unit2.get(VitamFieldsHelper.id()).asText();
                    int level = unit2.get(VitamFieldsHelper.max()).asInt();
                    if (unit2.isObject()) {
                        ((ObjectNode)unit2).put(ARCHIVAL_AGENCY_IDENTIFIER, (String)Optional.ofNullable(archiveTransferReplyType).map(ArchiveTransferReplyType::getArchivalAgency).map(OrganizationType::getIdentifier).map(IdentifierType::getValue).orElse(null));
                    }
                    unitToPurgeWriter.addEntry(new JsonLineModel(unitId, Integer.valueOf(level), unit2));
                }
            }
            unitToPurgeWriter.exportToWorkspace(UNITS_TO_DELETE_JSONL, false);
        }
        catch (ProcessingException | IOException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "An error occurred during transfer reply distribution generation", e);
        }
    }

    private BufferedConsumer<TransferReplyUnitReportEntry> createReportAppender(String processId) {
        return new BufferedConsumer(VitamConfiguration.getBatchSize(), entries -> {
            try {
                this.transferReplyReportService.appendEntries(processId, entries);
            }
            catch (ProcessingStatusException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private List<JsonNode> selectUnits(MetaDataClient metaDataClient, Collection<String> unitIds) throws ProcessingStatusException {
        try {
            SelectMultiQuery request = TransferReplyUnitPreparationHandler.buildRequestWithProjection(unitIds);
            JsonNode selectUnits = metaDataClient.selectUnits((JsonNode)request.getFinalSelect());
            RequestResponseOK requestResponseOK = RequestResponseOK.getFromJsonNode((JsonNode)selectUnits);
            return requestResponseOK.getResults();
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException | MetaDataClientServerException | MetaDataDocumentSizeException | MetaDataExecutionException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not select units", e);
        }
    }

    private static SelectMultiQuery buildRequestWithProjection(Collection<String> ids) throws InvalidCreateOperationException, InvalidParseOperationException {
        SelectMultiQuery selectQuery = new SelectMultiQuery();
        selectQuery.setQuery((Query)QueryHelper.in((String)VitamFieldsHelper.id(), (String[])ids.toArray(new String[0])));
        selectQuery.addUsedProjection(new String[]{VitamFieldsHelper.id(), VitamFieldsHelper.object(), VitamFieldsHelper.initialOperation(), VitamFieldsHelper.originatingAgency(), VitamFieldsHelper.max(), VitamFieldsHelper.storage(), PERSISTENT_IDENTIFIER_FIELD});
        return selectQuery;
    }

    private CloseableIterator<String> loadUnitIdsFromTransferReport(HandlerIO handler) throws ProcessingStatusException {
        InputStream inputStream = null;
        try {
            TransferReplyContext transferReplyContext = (TransferReplyContext)JsonHandler.getFromFile((File)((File)handler.getInput(0)), TransferReplyContext.class);
            inputStream = this.loadTransferReport(transferReplyContext.getTransferMessageRequestIdentifier());
            JsonLineGenericIterator lineGenericIterator = new JsonLineGenericIterator(inputStream, JSON_NODE_TYPE_REFERENCE);
            lineGenericIterator.skip();
            lineGenericIterator.skip();
            return CloseableIteratorUtils.map((CloseableIterator)lineGenericIterator, JsonLineModel::getId);
        }
        catch (InvalidParseOperationException | StorageServerClientException | StorageUnavailableDataFromAsyncOfferClientException | StorageNotFoundException | UncheckedIOException e) {
            StreamUtils.closeSilently(inputStream);
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not load transfer report", e);
        }
    }

    private InputStream loadTransferReport(String transferRequestId) throws StorageNotFoundException, StorageServerClientException, StorageUnavailableDataFromAsyncOfferClientException {
        try (StorageClient storageClient = this.storageClientFactory.getClient();){
            VitamAsyncInputStream vitamAsyncInputStream = new VitamAsyncInputStream(storageClient.getContainerAsync(VitamConfiguration.getDefaultStrategy(), transferRequestId + ".jsonl", DataCategory.REPORT, AccessLogUtils.getNoLogAccessLog()));
            return vitamAsyncInputStream;
        }
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }

    public static String getId() {
        return TRANSFER_REPLY_UNIT_PREPARATION;
    }
}

