/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.transfer.reply;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.batch.report.model.ReportType;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.logbook.LogbookOperation;
import fr.gouv.vitam.logbook.common.exception.LogbookClientException;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.plugin.GenericReportGenerationHandler;
import fr.gouv.vitam.worker.core.plugin.transfer.reply.TransferReplyReportService;

public class TransferReplyReportGenerationHandler
extends GenericReportGenerationHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(TransferReplyReportGenerationHandler.class);
    private static final String TRANSFER_REPLY_REPORT_GENERATION = "TRANSFER_REPLY_REPORT_GENERATION";
    private static final String LOGBOOK_ACTION_KEY = "TRANSFER_REPLY_DELETE_UNIT";
    private final LogbookOperationsClientFactory logbookOperationsClientFactory;

    public TransferReplyReportGenerationHandler() {
        this(new TransferReplyReportService(), LogbookOperationsClientFactory.getInstance());
    }

    @VisibleForTesting
    TransferReplyReportGenerationHandler(TransferReplyReportService transferReplyReportService, LogbookOperationsClientFactory logbookOperationsClientFactory) {
        super(transferReplyReportService);
        this.logbookOperationsClientFactory = logbookOperationsClientFactory;
    }

    @Override
    protected LogbookOperation getLogbookInformation(WorkerParameters param) throws ProcessingException {
        LogbookOperation logbookOperation;
        block8: {
            LogbookOperationsClient logbookClient = this.logbookOperationsClientFactory.getClient();
            try {
                JsonNode response = logbookClient.selectOperationById(param.getContainerName());
                RequestResponseOK logbookResponse = RequestResponseOK.getFromJsonNode((JsonNode)response);
                logbookOperation = (LogbookOperation)JsonHandler.getFromJsonNode((JsonNode)((JsonNode)logbookResponse.getFirstResult()), LogbookOperation.class);
                if (logbookClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (logbookClient != null) {
                        try {
                            logbookClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException | LogbookClientException e) {
                    throw new ProcessingException(e);
                }
            }
            logbookClient.close();
        }
        return logbookOperation;
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }

    public static String getId() {
        return TRANSFER_REPLY_REPORT_GENERATION;
    }

    @Override
    protected String getPluginId() {
        return TRANSFER_REPLY_REPORT_GENERATION;
    }

    @Override
    public ReportType getReportType() {
        return ReportType.TRANSFER_REPLY;
    }

    @Override
    public String getLogbookActionKey() {
        return LOGBOOK_ACTION_KEY;
    }
}

