/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.transfer.reply;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.purge.PurgeReportService;
import fr.gouv.vitam.worker.core.plugin.transfer.reply.TransferReplyReportService;
import fr.gouv.vitam.worker.core.utils.PluginHelper;

public class TransferReplyFinalizationPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(TransferReplyFinalizationPlugin.class);
    private static final String TRANSFER_REPLY_FINALIZATION = "TRANSFER_REPLY_FINALIZATION";
    private final TransferReplyReportService transferReplyReportService;
    private final PurgeReportService purgeReportService;

    public TransferReplyFinalizationPlugin() {
        this(new TransferReplyReportService(), new PurgeReportService());
    }

    @VisibleForTesting
    TransferReplyFinalizationPlugin(TransferReplyReportService TransferReplyReportService2, PurgeReportService purgeReportService) {
        this.transferReplyReportService = TransferReplyReportService2;
        this.purgeReportService = purgeReportService;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        try {
            this.transferReplyReportService.cleanupReport(param.getContainerName());
            this.purgeReportService.cleanupReport(param.getContainerName());
            LOGGER.info("Transfer reply finalization succeeded");
            return PluginHelper.buildItemStatus(TRANSFER_REPLY_FINALIZATION, StatusCode.OK, null);
        }
        catch (ProcessingStatusException e) {
            LOGGER.error(String.format("Transfer reply finalization failed with status [%s]", e.getStatusCode()), (Throwable)e);
            return PluginHelper.buildItemStatus(TRANSFER_REPLY_FINALIZATION, e.getStatusCode(), e.getEventDetails());
        }
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }

    public static String getId() {
        return TRANSFER_REPLY_FINALIZATION;
    }
}

