/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.transfer.reply;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.transfer.reply.SaveAtrPlugin;
import fr.gouv.vitam.worker.core.plugin.transfer.reply.model.TransferReplyContext;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import java.io.File;

public class TransferReplyDeleteSIP
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(SaveAtrPlugin.class);
    private static final String PLUGIN_NAME = "TRANSFER_REPLY_DELETE_SIP";
    private static final int TRANSFER_REPLY_CONTEXT_IN_RANK = 0;

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) {
        try (WorkspaceClient workspaceClient = handler.getWorkspaceClientFactory().getClient();){
            TransferReplyContext transferReplyContext = (TransferReplyContext)JsonHandler.getFromFile((File)((File)handler.getInput(0)), TransferReplyContext.class);
            String optId = transferReplyContext.getTransferMessageRequestIdentifier();
            String tenantFolder = Integer.toString(VitamThreadUtils.getVitamSession().getTenantId());
            workspaceClient.deleteObject("TRANSFER", tenantFolder + "/" + optId);
        }
        catch (InvalidParseOperationException | ContentAddressableStorageServerException e) {
            LOGGER.error(e);
            return PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.FATAL, PluginHelper.EventDetails.of(e.getMessage()));
        }
        catch (ContentAddressableStorageNotFoundException e) {
            return PluginHelper.buildItemStatusWithMessage(PLUGIN_NAME, StatusCode.WARNING, "File not found");
        }
        return PluginHelper.buildItemStatusWithMessage(PLUGIN_NAME, StatusCode.OK, "Delete SIP ok.");
    }
}

