/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.transfer.reply;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.culture.archivesdefrance.seda.v2.ArchiveTransferReplyType;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageAlreadyExistsClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageNotFoundClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.request.ObjectDescription;
import fr.gouv.vitam.storage.engine.common.model.response.StoredInfoResult;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.BinaryEventData;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.util.Collections;

public class SaveAtrPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(SaveAtrPlugin.class);
    public static final String PLUGIN_NAME = "SAVE_ARCHIVAL_TRANSFER_REPLY";
    private final StorageClientFactory storageClientFactory;

    public SaveAtrPlugin() {
        this(StorageClientFactory.getInstance());
    }

    @VisibleForTesting
    public SaveAtrPlugin(StorageClientFactory storageClientFactory) {
        this.storageClientFactory = storageClientFactory;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        ItemStatus itemStatus;
        block9: {
            ArchiveTransferReplyType atr = (ArchiveTransferReplyType)handler.getInput(0);
            StorageClient storageClient = this.storageClientFactory.getClient();
            try {
                String messageIdentifier = atr.getMessageIdentifier();
                ObjectDescription description = this.getDescription(messageIdentifier, handler.getContainerName());
                StoredInfoResult storedInfo = storageClient.storeFileFromWorkspace(VitamConfiguration.getDefaultStrategy(), description.getType(), description.getObjectName(), description);
                handler.addOutputResult(0, (Object)atr);
                itemStatus = PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.OK, Collections.singletonMap(messageIdentifier, BinaryEventData.from(storedInfo)));
                if (storageClient == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (storageClient != null) {
                        try {
                            storageClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (StorageAlreadyExistsClientException e) {
                    LOGGER.warn((Throwable)e);
                    return PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.WARNING, PluginHelper.EventDetails.of(e.getMessage(), "ATR already exists but it will continue."));
                }
                catch (StorageNotFoundClientException | StorageServerClientException e) {
                    LOGGER.error(e);
                    return PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.FATAL, PluginHelper.EventDetails.of(e.getMessage()));
                }
            }
            storageClient.close();
        }
        return itemStatus;
    }

    private ObjectDescription getDescription(String messageIdentifier, String containerName) {
        ObjectDescription description = new ObjectDescription();
        description.setWorkspaceContainerGUID(containerName);
        description.setObjectName(messageIdentifier);
        description.setWorkspaceObjectURI("ATR-for-transfer-reply-in-workspace.xml");
        description.setType(DataCategory.ARCHIVAL_TRANSFER_REPLY);
        return description;
    }
}

