/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.transfer.reply;

import fr.gouv.culture.archivesdefrance.seda.v2.ArchiveTransferReplyType;
import fr.gouv.culture.archivesdefrance.seda.v2.IdentifierType;
import fr.gouv.culture.archivesdefrance.seda.v2.OrganizationType;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.transfer.reply.model.TransferReplyContext;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.io.FileUtils;

public class CheckAtrAndAddItToWorkspacePlugin
extends ActionHandler {
    public static final String PLUGIN_NAME = "CHECK_ATR_AND_ADD_IT_TO_WORKSPACE";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(CheckAtrAndAddItToWorkspacePlugin.class);
    private static final int TRANSFER_REPLY_CONTEXT_OUT_RANK = 0;
    private static final int TRANSFER_REPLY_ATR_RANK = 1;

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        ArchiveTransferReplyType atr = (ArchiveTransferReplyType)handler.getInput(0);
        try {
            String messageIdentifier = atr.getMessageIdentifier();
            if (!this.isValidStatus(atr)) {
                return PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.KO, PluginHelper.EventDetails.of(String.format("ATR '%s' is KO, workflow will stop here.", messageIdentifier)));
            }
            File tempFile = handler.getNewLocalFile(handler.getOutput(0).getPath());
            FileUtils.copyInputStreamToFile((InputStream)this.streamFromIds(atr), (File)tempFile);
            handler.addOutputResult(0, (Object)tempFile, true, false);
            handler.addOutputResult(1, (Object)atr);
            return PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.OK, PluginHelper.EventDetails.of(String.format("ATR '%s' is OK.", messageIdentifier)));
        }
        catch (InvalidParseOperationException | IOException e) {
            LOGGER.error(e);
            return PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.FATAL, PluginHelper.EventDetails.of(e.getMessage()));
        }
    }

    private boolean isValidStatus(ArchiveTransferReplyType atr) {
        return StatusCode.OK.name().equalsIgnoreCase(atr.getReplyCode()) || StatusCode.WARNING.name().equalsIgnoreCase(atr.getReplyCode());
    }

    private InputStream streamFromIds(ArchiveTransferReplyType atr) throws InvalidParseOperationException {
        return JsonHandler.writeToInpustream((Object)new TransferReplyContext(atr.getMessageRequestIdentifier().getValue(), atr.getMessageIdentifier(), Optional.ofNullable(atr).map(ArchiveTransferReplyType::getArchivalAgency).map(OrganizationType::getIdentifier).map(IdentifierType::getValue).orElse(null)));
    }
}

