/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.traceability;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.batch.report.model.TraceabilityError;
import fr.gouv.vitam.batch.report.model.entry.TraceabilityReportEntry;
import fr.gouv.vitam.common.BaseXx;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.logbook.common.traceability.TimeStampService;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.handler.HandlerUtils;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.ess.SigningCertificateV2;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TSPValidationException;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;

public class VerifyTimeStampActionHandler
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(VerifyTimeStampActionHandler.class);
    private static final String HANDLER_ID = "VERIFY_TIMESTAMP";
    private static final int TRACEABILITY_EVENT_DETAIL_RANK = 0;
    private static final String TIMESTAMP_FILENAME = "token.tsp";
    private static final String HANDLER_SUB_ACTION_COMPARE_TOKEN_TIMESTAMP = "COMPARE_TOKEN_TIMESTAMP";
    private static final String HANDLER_SUB_ACTION_VALIDATE_TOKEN_TIMESTAMP = "VALIDATE_TOKEN_TIMESTAMP";
    private static final String HANDLER_SUB_ACTION_VERIFY_TOKEN_TIMESTAMP = "VERIFY_TOKEN_TIMESTAMP";

    public static final String getId() {
        return HANDLER_ID;
    }

    public ItemStatus execute(WorkerParameters params, HandlerIO handler) throws ProcessingException {
        if (handler.isExistingFileInWorkspace(params.getObjectName() + File.separator + "error")) {
            return PluginHelper.buildItemStatus(HANDLER_ID, StatusCode.KO);
        }
        ItemStatus itemStatus = new ItemStatus(HANDLER_ID);
        try {
            JsonNode traceabilityEvent = JsonHandler.getFromFile((File)((File)handler.getInput(0)));
            String encodedTimeStampToken = this.getEncodedTimeStampToken(params, handler);
            ItemStatus subItemStatusTokenComparison = new ItemStatus(HANDLER_SUB_ACTION_COMPARE_TOKEN_TIMESTAMP);
            try {
                this.compareTimeStamps(encodedTimeStampToken, traceabilityEvent);
                itemStatus.setItemsStatus(HANDLER_SUB_ACTION_COMPARE_TOKEN_TIMESTAMP, subItemStatusTokenComparison.increment(StatusCode.OK));
            }
            catch (ProcessingException e) {
                LOGGER.error("Timestamps are not equal", (Throwable)e);
                itemStatus.setItemsStatus(HANDLER_SUB_ACTION_COMPARE_TOKEN_TIMESTAMP, subItemStatusTokenComparison.increment(StatusCode.KO));
                this.updateReport(params, handler, t -> t.setStatus(itemStatus.getGlobalStatus().name()).setError(TraceabilityError.INEQUAL_TIMESTAMP).setMessage("Timestamps are not equal"));
                HandlerUtils.save(handler, (Object)"", params.getObjectName() + File.separator + "error");
                return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
            }
            ItemStatus subItemStatusTokenValidation = new ItemStatus(HANDLER_SUB_ACTION_VALIDATE_TOKEN_TIMESTAMP);
            try {
                this.validateTimestamp(encodedTimeStampToken);
                itemStatus.setItemsStatus(HANDLER_SUB_ACTION_VALIDATE_TOKEN_TIMESTAMP, subItemStatusTokenValidation.increment(StatusCode.OK));
            }
            catch (ProcessingException e) {
                LOGGER.error("Timestamps is not valid", (Throwable)e);
                itemStatus.setItemsStatus(HANDLER_SUB_ACTION_VALIDATE_TOKEN_TIMESTAMP, subItemStatusTokenValidation.increment(StatusCode.KO));
                this.updateReport(params, handler, t -> t.setStatus(itemStatus.getGlobalStatus().name()).setError(TraceabilityError.INVALID_TIMESTAMP).setMessage("Timestamps is not valid"));
                HandlerUtils.save(handler, (Object)"", params.getObjectName() + File.separator + "error");
                return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
            }
            ItemStatus subItemStatusTokenVerification = new ItemStatus(HANDLER_SUB_ACTION_VERIFY_TOKEN_TIMESTAMP);
            try {
                String computingInformationPath = "traceabilityOperation" + File.separator + params.getObjectName() + File.separator + "computing_information.txt";
                String merkleTreePath = "traceabilityOperation" + File.separator + params.getObjectName() + File.separator + "merkleTree.json";
                this.verifyTimestamp(encodedTimeStampToken, computingInformationPath, merkleTreePath, handler);
                itemStatus.setItemsStatus(HANDLER_SUB_ACTION_VERIFY_TOKEN_TIMESTAMP, subItemStatusTokenVerification.increment(StatusCode.OK));
            }
            catch (ProcessingException e) {
                LOGGER.error("Timestamps is not valid", (Throwable)e);
                itemStatus.setItemsStatus(HANDLER_SUB_ACTION_VERIFY_TOKEN_TIMESTAMP, subItemStatusTokenVerification.increment(StatusCode.KO));
                this.updateReport(params, handler, t -> t.setStatus(itemStatus.getGlobalStatus().name()).setError(TraceabilityError.INVALID_TIMESTAMP).setMessage("Timestamps is not valid"));
                HandlerUtils.save(handler, (Object)"", params.getObjectName() + File.separator + "error");
                return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
            }
            this.updateReport(params, handler, t -> t.setStatus(itemStatus.getGlobalStatus().name()));
        }
        catch (InvalidParseOperationException | ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException | IOException e) {
            LOGGER.error(e);
            itemStatus.increment(StatusCode.FATAL);
        }
        return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
    }

    private void updateReport(WorkerParameters param, HandlerIO handlerIO, Consumer<TraceabilityReportEntry> updater) throws IOException, ProcessingException, InvalidParseOperationException {
        String path = param.getObjectName() + File.separator + "report.json";
        TraceabilityReportEntry traceabilityReportEntry = (TraceabilityReportEntry)JsonHandler.getFromJsonNode((JsonNode)handlerIO.getJsonFromWorkspace(path), TraceabilityReportEntry.class);
        updater.accept(traceabilityReportEntry);
        HandlerUtils.save(handlerIO, (Object)traceabilityReportEntry, path);
    }

    private String getEncodedTimeStampToken(WorkerParameters param, HandlerIO handler) throws IOException, ContentAddressableStorageNotFoundException, ContentAddressableStorageServerException {
        String operationFilePath = "traceabilityOperation" + File.separator + param.getObjectName() + File.separator + TIMESTAMP_FILENAME;
        try (InputStream tokenFile = handler.getInputStreamFromWorkspace(operationFilePath);){
            String string = IOUtils.toString((InputStream)tokenFile, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    private void verifyTimestamp(String encodedTimeStampToken, String computingInformationPath, String merkleTreePath, HandlerIO handler) throws ProcessingException {
        try (InputStream computingInformation = handler.getInputStreamFromWorkspace(computingInformationPath);
             InputStream merkleTreeInformation = handler.getInputStreamFromWorkspace(merkleTreePath);){
            Properties computingProperties = new Properties();
            computingProperties.load(computingInformation);
            String merkleTreeDigest = JsonHandler.getFromInputStream((InputStream)merkleTreeInformation).get("Root").asText();
            String computingCurrentDigest = computingProperties.getProperty("currentHash");
            if (!Objects.equals(merkleTreeDigest, computingCurrentDigest)) {
                throw new ProcessingException(String.format("Not same digest %s %s.", merkleTreeDigest, computingCurrentDigest));
            }
            TimeStampService timeStampService = new TimeStampService();
            byte[] rootMerkleTree = timeStampService.getDigestAsBytes(computingCurrentDigest);
            byte[] prevTimeStampToken = timeStampService.getDigestAsBytes(computingProperties.getProperty("previousTimestampToken"));
            byte[] prevTimestampTokenMinusOneMonth = timeStampService.getDigestAsBytes(computingProperties.getProperty("previousTimestampTokenMinusOneMonth"));
            byte[] prevTimestampTokenMinusOneYear = timeStampService.getDigestAsBytes(computingProperties.getProperty("previousTimestampTokenMinusOneYear"));
            TimeStampToken timeStampToken = timeStampService.getTimeStampFrom(encodedTimeStampToken);
            byte[] timeStampDataFromFile = timeStampToken.getTimeStampInfo().getMessageImprintDigest();
            byte[] computedTimeStampData = timeStampService.getDigestFrom((byte[][])new byte[][]{rootMerkleTree, prevTimeStampToken, prevTimestampTokenMinusOneMonth, prevTimestampTokenMinusOneYear});
            if (!Arrays.equals(timeStampDataFromFile, computedTimeStampData)) {
                throw new ProcessingException(String.format("Not same digest %s %s.", BaseXx.getBase16((byte[])timeStampDataFromFile), BaseXx.getBase16((byte[])computedTimeStampData)));
            }
        }
        catch (Exception e) {
            throw new ProcessingException((Throwable)e);
        }
    }

    private void compareTimeStamps(String timeStampToken, JsonNode traceabilityEvent) throws ProcessingException {
        String traceabilityTimeStamp = traceabilityEvent.get("TimeStampToken").asText();
        if (!timeStampToken.equals(traceabilityTimeStamp)) {
            throw new ProcessingException("TimeStamp tokens are different");
        }
    }

    private void validateTimestamp(String encodedTimeStampToken) throws ProcessingException {
        try {
            TimeStampService timeStampService = new TimeStampService();
            TimeStampToken tsToken = timeStampService.getTimeStampFrom(encodedTimeStampToken);
            AttributeTable table = tsToken.getSignedAttributes();
            Attribute attribute = table.get(PKCSObjectIdentifiers.id_aa_signingCertificate);
            if (attribute == null) {
                attribute = table.get(PKCSObjectIdentifiers.id_aa_signingCertificateV2);
            }
            SigningCertificateV2 sigCertV2 = SigningCertificateV2.getInstance((Object)attribute.getAttributeValues()[0]);
            try {
                X509CertificateHolder x509Certificate = this.retriveCertificate(tsToken);
                SignerInformationVerifier sigVerifier = new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(x509Certificate);
                if (!tsToken.isSignatureValid(sigVerifier)) {
                    LOGGER.error("Signature from timestamp token is incorrect");
                    throw new ProcessingException("Signature from timestamp token is incorrect");
                }
                tsToken.validate(sigVerifier);
                BcDigestCalculatorProvider digestCalculatorProvider = new BcDigestCalculatorProvider();
                DigestCalculator digCalc = digestCalculatorProvider.get(new AlgorithmIdentifier(tsToken.getTimeStampInfo().getMessageImprintAlgOID()));
                OutputStream dOut = digCalc.getOutputStream();
                dOut.write(x509Certificate.getEncoded());
                dOut.close();
                byte[] certHash = digCalc.getDigest();
                if (!Arrays.equals(sigCertV2.getCerts()[0].getCertHash(), certHash)) {
                    LOGGER.error("Hash from certificates are different");
                    throw new ProcessingException("Hash from certificates are different");
                }
            }
            catch (TSPValidationException e) {
                LOGGER.error((Throwable)e);
                throw new ProcessingException("TimeStampToken fails to validate", (Throwable)e);
            }
            catch (IllegalArgumentException | TSPException e) {
                LOGGER.error(e);
                throw new ProcessingException("Error while getting keystore", e);
            }
        }
        catch (IOException | CertificateException | OperatorCreationException | TSPException e) {
            LOGGER.error(e);
            throw new ProcessingException("TimeStamp tokens couldnt be validated", e);
        }
    }

    private X509CertificateHolder retriveCertificate(TimeStampToken tsToken) {
        Store storeTt = tsToken.getCertificates();
        SignerId sid = tsToken.getSID();
        Collection collTt = storeTt.getMatches((Selector)sid);
        Iterator certIt2 = collTt.iterator();
        return (X509CertificateHolder)certIt2.next();
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }
}

