/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.traceability;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.batch.report.model.TraceabilityError;
import fr.gouv.vitam.batch.report.model.entry.TraceabilityReportEntry;
import fr.gouv.vitam.common.BaseXx;
import fr.gouv.vitam.common.digest.DigestType;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.security.merkletree.MerkleTree;
import fr.gouv.vitam.common.security.merkletree.MerkleTreeAlgo;
import fr.gouv.vitam.logbook.common.model.TraceabilityEvent;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.handler.HandlerUtils;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class VerifyMerkleTreeActionHandler
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(VerifyMerkleTreeActionHandler.class);
    private static final String ROOT = "Root";
    private static final String MERKLE_TREE_JSON = "merkleTree.json";
    static final String DATA_FILE = "data.txt";
    private static final String HANDLER_ID = "CHECK_MERKLE_TREE";
    private static final String HANDLER_SUB_ACTION_COMPARE_WITH_SAVED_HASH = "COMPARE_MERKLE_HASH_WITH_SAVED_HASH";
    private static final String HANDLER_SUB_ACTION_COMPARE_WITH_INDEXED_HASH = "COMPARE_MERKLE_HASH_WITH_INDEXED_HASH";
    private static final int TRACEABILITY_EVENT_DETAIL_RANK = 0;
    private static final int END_OF_STREAM = -1;
    private static final char NEW_LINE_SEPARATOR = '\n';

    public static String getId() {
        return HANDLER_ID;
    }

    public ItemStatus execute(WorkerParameters params, HandlerIO handler) throws ProcessingException {
        if (handler.isExistingFileInWorkspace(params.getObjectName() + File.separator + "error")) {
            return PluginHelper.buildItemStatus(HANDLER_ID, StatusCode.KO);
        }
        ItemStatus itemStatus = new ItemStatus(HANDLER_ID);
        String zipDataFolder = "traceabilityOperation" + File.separator + params.getObjectName();
        String dataFilePath = zipDataFolder + File.separator + DATA_FILE;
        File traceabilityFile = (File)handler.getInput(0, File.class);
        try (InputStream operationsInputStream = handler.getInputStreamFromWorkspace(dataFilePath);){
            TraceabilityEvent traceabilityEvent = (TraceabilityEvent)JsonHandler.getFromFile((File)traceabilityFile, TraceabilityEvent.class);
            MerkleTreeAlgo merkleTreeAlgo = VerifyMerkleTreeActionHandler.computeMerkleTree(operationsInputStream, traceabilityEvent.getDigestAlgorithm());
            String currentRootHash = this.currentRootHash(merkleTreeAlgo);
            ItemStatus subSecuredItem = this.compareToSecuredHash(handler, zipDataFolder + File.separator + MERKLE_TREE_JSON, currentRootHash);
            itemStatus.setItemsStatus(HANDLER_SUB_ACTION_COMPARE_WITH_SAVED_HASH, subSecuredItem);
            ItemStatus subLoggedItemStatus = this.compareToLoggedHash(currentRootHash, traceabilityEvent);
            itemStatus.setItemsStatus(HANDLER_SUB_ACTION_COMPARE_WITH_INDEXED_HASH, subLoggedItemStatus);
            if (itemStatus.getGlobalStatus().equals((Object)StatusCode.KO)) {
                this.updateReport(params, handler, t -> t.setStatus(itemStatus.getGlobalStatus().name()).setError(TraceabilityError.INCORRECT_MERKLE_TREE).setMessage("Error checking merkle tree"));
                HandlerUtils.save(handler, (Object)"", params.getObjectName() + File.separator + "error");
            } else {
                this.updateReport(params, handler, t -> t.setStatus(itemStatus.getGlobalStatus().name()));
            }
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            itemStatus.increment(StatusCode.FATAL);
        }
        return new ItemStatus(HANDLER_ID).setItemsStatus(HANDLER_ID, itemStatus);
    }

    private void updateReport(WorkerParameters param, HandlerIO handlerIO, Consumer<TraceabilityReportEntry> updater) throws IOException, ProcessingException, InvalidParseOperationException {
        String path = param.getObjectName() + File.separator + "report.json";
        TraceabilityReportEntry traceabilityReportEntry = (TraceabilityReportEntry)JsonHandler.getFromJsonNode((JsonNode)handlerIO.getJsonFromWorkspace(path), TraceabilityReportEntry.class);
        updater.accept(traceabilityReportEntry);
        HandlerUtils.save(handlerIO, (Object)traceabilityReportEntry, path);
    }

    ItemStatus compareToLoggedHash(String currentRootHash, TraceabilityEvent traceabilityEvent) {
        ItemStatus subLoggedItemStatus = new ItemStatus(HANDLER_SUB_ACTION_COMPARE_WITH_INDEXED_HASH);
        if (!currentRootHash.equals(traceabilityEvent.getHash())) {
            return subLoggedItemStatus.increment(StatusCode.KO);
        }
        return subLoggedItemStatus.increment(StatusCode.OK);
    }

    private ItemStatus compareToSecuredHash(HandlerIO handler, String merkleTreeFile, String currentRootHash) throws ProcessingException {
        ItemStatus subItemStatus = new ItemStatus(HANDLER_SUB_ACTION_COMPARE_WITH_SAVED_HASH);
        JsonNode merkleTree = handler.getJsonFromWorkspace(merkleTreeFile);
        String securedRootHash = merkleTree.get(ROOT).asText();
        if (currentRootHash == null || !currentRootHash.equals(securedRootHash)) {
            return subItemStatus.increment(StatusCode.KO);
        }
        return subItemStatus.increment(StatusCode.OK);
    }

    private String currentRootHash(MerkleTreeAlgo merkleTreeAlgo) {
        MerkleTree currentMerkleTree = merkleTreeAlgo.generateMerkle();
        return BaseXx.getBase64((byte[])currentMerkleTree.getRoot());
    }

    public static MerkleTreeAlgo computeMerkleTree(InputStream inputStream, DigestType digestType) throws ProcessingException {
        MerkleTreeAlgo merkleTreeAlgo = new MerkleTreeAlgo(digestType);
        try (BufferedInputStream bis = new BufferedInputStream(inputStream);
             ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
            int c;
            while (-1 != (c = bis.read())) {
                if (c != 10) {
                    buffer.write(c);
                    continue;
                }
                merkleTreeAlgo.addLeaf(buffer.toByteArray());
                buffer.reset();
            }
            if (buffer.size() > 0) {
                merkleTreeAlgo.addLeaf(buffer.toByteArray());
            }
        }
        catch (IOException e) {
            throw new ProcessingException((Throwable)e);
        }
        return merkleTreeAlgo;
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }
}

