/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.traceability;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.parser.request.single.SelectParserSingle;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.logbook.common.exception.LogbookClientException;
import fr.gouv.vitam.logbook.common.parameters.Contexts;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookMongoDbName;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.distribution.JsonLineModel;
import fr.gouv.vitam.worker.core.distribution.JsonLineWriter;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;

public class TraceabilityLinkedCheckPreparePlugin
extends ActionHandler {
    private static final String PLUGIN_NAME = "TRACEABILITY_LINKED_CHECK_PREPARE";
    private static final String[] EVENT_TRACEABILITY_TYPES = new String[]{Contexts.LOGBOOK_TRACEABILITY.getEventType(), Contexts.LOGBOOK_STORAGE_TRACEABILITY.getEventType(), Contexts.UNIT_LFC_TRACEABILITY.getEventType(), Contexts.OBJECTGROUP_LFC_TRACEABILITY.getEventType()};
    static final String LOGBOOK_OPERATIONS_JSONL_FILE = "logbookOperations.jsonl";
    private final LogbookOperationsClientFactory logbookOperationsClientFactory;

    public TraceabilityLinkedCheckPreparePlugin() {
        this(LogbookOperationsClientFactory.getInstance());
    }

    @VisibleForTesting
    TraceabilityLinkedCheckPreparePlugin(LogbookOperationsClientFactory logbookOperationsClientFactory) {
        this.logbookOperationsClientFactory = logbookOperationsClientFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        ItemStatus itemStatus = new ItemStatus(PLUGIN_NAME);
        JsonNode dslQuery = this.filterQuery(handler.getJsonFromWorkspace("query.json"));
        File logbookOperationDistributionFile = handler.getNewLocalFile(LOGBOOK_OPERATIONS_JSONL_FILE);
        ArrayList<String> skippedOperations = new ArrayList<String>();
        try (LogbookOperationsClient logbookOperationsClient = this.logbookOperationsClientFactory.getClient();){
            JsonNode logbookOperations = logbookOperationsClient.selectOperation(dslQuery);
            JsonNode results = logbookOperations.get("$results");
            try (JsonLineWriter logbookOperationsWriter = new JsonLineWriter((OutputStream)new FileOutputStream(logbookOperationDistributionFile));){
                for (int i = 0; i < results.size(); ++i) {
                    JsonNode logbookOperation = results.get(i);
                    JsonNode eventDetail = JsonHandler.getFromString((String)logbookOperation.get(LogbookMongoDbName.eventDetailData.getDbname()).asText());
                    if (eventDetail instanceof NullNode || eventDetail.isEmpty()) {
                        skippedOperations.add(logbookOperation.get("evId").asText());
                        continue;
                    }
                    JsonLineModel entry = new JsonLineModel(logbookOperation.get("evId").textValue(), null, eventDetail);
                    logbookOperationsWriter.addEntry(entry);
                }
            }
            handler.transferFileToWorkspace(LOGBOOK_OPERATIONS_JSONL_FILE, logbookOperationDistributionFile, true, false);
        }
        catch (InvalidParseOperationException | LogbookClientException | IOException e) {
            ItemStatus itemStatus2 = PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.FATAL, e.getMessage());
            return itemStatus2;
        }
        finally {
            FileUtils.deleteQuietly((File)logbookOperationDistributionFile);
        }
        if (!skippedOperations.isEmpty()) {
            itemStatus.setItemsStatus(PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.WARNING, PluginHelper.EventDetails.of(String.format("These operations %s does not contains data. they will be skipped !", ((Object)skippedOperations).toString()))));
            return itemStatus;
        }
        itemStatus.setItemsStatus(PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.OK));
        return itemStatus;
    }

    private JsonNode filterQuery(JsonNode dslQuery) throws ProcessingException {
        try {
            SelectParserSingle parser = new SelectParserSingle();
            parser.parse(dslQuery);
            parser.addCondition((Query)QueryHelper.in((String)"evType", (String[])EVENT_TRACEABILITY_TYPES));
            return parser.getRootNode();
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            throw new ProcessingException(e);
        }
    }
}

