/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.traceability;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.batch.report.model.OperationSummary;
import fr.gouv.vitam.batch.report.model.Report;
import fr.gouv.vitam.batch.report.model.ReportResults;
import fr.gouv.vitam.batch.report.model.ReportSummary;
import fr.gouv.vitam.batch.report.model.ReportType;
import fr.gouv.vitam.batch.report.model.entry.TraceabilityReportEntry;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.logbook.common.exception.LogbookClientException;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameterName;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.distribution.JsonLineGenericIterator;
import fr.gouv.vitam.worker.core.distribution.JsonLineModel;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.traceability.service.TraceabilityReportService;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class TraceabilityFinalizationPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(TraceabilityFinalizationPlugin.class);
    private static final String PLUGIN_NAME = "TRACEABILITY_FINALIZATION";
    private static final String QUERY = "query";
    private static final String OBJECT_ID = "objectId";
    private final TraceabilityReportService traceabilityReportService;
    private final LogbookOperationsClientFactory logbookOperationsClientFactory;

    public TraceabilityFinalizationPlugin() {
        this(new TraceabilityReportService(), LogbookOperationsClientFactory.getInstance());
    }

    @VisibleForTesting
    TraceabilityFinalizationPlugin(TraceabilityReportService traceabilityReportService, LogbookOperationsClientFactory logbookOperationsClientFactory) {
        this.traceabilityReportService = traceabilityReportService;
        this.logbookOperationsClientFactory = logbookOperationsClientFactory;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        try {
            this.storeReportEntriesToOffers(param, handler);
            this.generateTraceabilityReportToWorkspace(param, handler);
            this.storeReportToOffers(param.getContainerName());
            this.cleanupReport(param);
            LOGGER.info("Audit object finalization succeeded");
            return PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.OK, null);
        }
        catch (ProcessingStatusException e) {
            LOGGER.error(String.format("Audit object  finalization failed with status [%s]", e.getStatusCode()), (Throwable)e);
            return PluginHelper.buildItemStatus(PLUGIN_NAME, e.getStatusCode(), null);
        }
    }

    private void storeReportEntriesToOffers(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        try {
            if (handler.isExistingFileInWorkspace("logbookOperations.jsonl")) {
                ArrayList operationsId = new ArrayList();
                JsonLineGenericIterator iterator = new JsonLineGenericIterator(handler.getInputStreamFromWorkspace("logbookOperations.jsonl"), (TypeReference)new TypeReference<JsonLineModel>(){});
                iterator.forEachRemaining(lineModel -> operationsId.add(lineModel.getId()));
                List reports = operationsId.stream().map(operationId -> {
                    try {
                        return handler.getJsonFromWorkspace(operationId + File.separator + "report.json");
                    }
                    catch (ProcessingException e) {
                        LOGGER.error((Throwable)e);
                        return null;
                    }
                }).filter(Objects::nonNull).map(jsonNode -> {
                    try {
                        return (TraceabilityReportEntry)JsonHandler.getFromJsonNode((JsonNode)jsonNode, TraceabilityReportEntry.class);
                    }
                    catch (InvalidParseOperationException e) {
                        LOGGER.error((Throwable)e);
                        return null;
                    }
                }).filter(Objects::nonNull).collect(Collectors.toList());
                this.traceabilityReportService.appendEntries(param.getContainerName(), reports);
            }
        }
        catch (ProcessingStatusException | ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException | IOException e) {
            throw new ProcessingException(e);
        }
    }

    private void generateTraceabilityReportToWorkspace(WorkerParameters param, HandlerIO handler) throws ProcessingStatusException, ProcessingException {
        if (this.traceabilityReportService.isReportWrittenInWorkspace(param.getContainerName())) {
            return;
        }
        Map mapParameters = param.getMapParameters();
        JsonNode initialQuery = handler.getJsonFromWorkspace("query.json");
        JsonNode logbookOperation = this.getLogbookOperation(param.getContainerName());
        OperationSummary operationSummary = this.computeLogbookInformation(param.getContainerName(), logbookOperation);
        ReportSummary reportSummary = this.computeReportSummary(logbookOperation);
        ObjectNode context = JsonHandler.createObjectNode();
        if (mapParameters.containsKey(WorkerParameterName.objectId)) {
            context.put(OBJECT_ID, (String)mapParameters.get(WorkerParameterName.objectId));
        }
        context.set(QUERY, initialQuery);
        Report reportInfo = new Report(operationSummary, reportSummary, (JsonNode)context);
        this.traceabilityReportService.storeReportToWorkspace(reportInfo);
    }

    private OperationSummary computeLogbookInformation(String processId, JsonNode logbookOperation) throws ProcessingStatusException {
        try {
            if (!logbookOperation.has("events") || !logbookOperation.get("events").isArray()) {
                throw new ProcessingStatusException(StatusCode.FATAL, "Could not generate report summary : no events");
            }
            ArrayNode events = (ArrayNode)logbookOperation.get("events");
            if (events.size() <= 2) {
                throw new ProcessingStatusException(StatusCode.FATAL, "Could not generate report summary : not enougth events");
            }
            JsonNode lastEvent = events.get(events.size() - 2);
            Integer tenantId = logbookOperation.get("_tenant").asInt();
            String evType = logbookOperation.get("evType").asText();
            String outcome = lastEvent.get("outcome").asText();
            String outDetail = lastEvent.get("outDetail").asText();
            String outMsg = lastEvent.get("outMessg").asText();
            JsonNode evDetData = JsonHandler.getFromString((String)lastEvent.get("evDetData").asText());
            JsonNode rSI = JsonHandler.getFromString((String)logbookOperation.get("rightsStatementIdentifier").asText());
            return new OperationSummary(tenantId, processId, evType, outcome, outDetail, outMsg, rSI, evDetData);
        }
        catch (InvalidParseOperationException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not generate report", e);
        }
    }

    private ReportSummary computeReportSummary(JsonNode logbookOperation) {
        String startDate = logbookOperation.get("evDateTime").asText();
        String endDate = LocalDateUtil.nowFormatted();
        ReportType reportType = ReportType.TRACEABILITY;
        ReportResults vitamResults = new ReportResults();
        ObjectNode extendedInfo = JsonHandler.createObjectNode();
        return new ReportSummary(startDate, endDate, reportType, vitamResults, (JsonNode)extendedInfo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonNode getLogbookOperation(String operationId) throws ProcessingStatusException {
        try (LogbookOperationsClient client = this.logbookOperationsClientFactory.getClient();){
            JsonNode logbookResponse = client.selectOperationById(operationId);
            if (!logbookResponse.has("$results")) throw new ProcessingStatusException(StatusCode.FATAL, "Could not find operation in logbook");
            if (!logbookResponse.get("$results").isArray()) throw new ProcessingStatusException(StatusCode.FATAL, "Could not find operation in logbook");
            ArrayNode results = (ArrayNode)logbookResponse.get("$results");
            if (results.size() <= 0) throw new ProcessingStatusException(StatusCode.FATAL, "Could not find operation in logbook");
            JsonNode jsonNode = results.get(0);
            return jsonNode;
        }
        catch (InvalidParseOperationException | LogbookClientException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Error while retrieving logbook operation", e);
        }
    }

    private void storeReportToOffers(String containerName) throws ProcessingStatusException {
        this.traceabilityReportService.storeReportToOffers(containerName);
    }

    private void cleanupReport(WorkerParameters param) throws ProcessingStatusException {
        this.traceabilityReportService.cleanupReport(param.getContainerName());
    }
}

