/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.traceability;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import fr.gouv.vitam.batch.report.model.TraceabilityError;
import fr.gouv.vitam.batch.report.model.entry.TraceabilityReportEntry;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.logbook.common.model.TraceabilityEvent;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageNotFoundClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.handler.HandlerUtils;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.io.File;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class RetrieveSecureTraceabilityDataFilePlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(RetrieveSecureTraceabilityDataFilePlugin.class);
    private static final String PLUGIN_NAME = "RETRIEVE_SECURE_TRACEABILITY_DATA_FILE";
    private static final int TRACEABILITY_EVENT_OUT_RANK = 0;
    private static final int DIGEST_OUT_RANK = 1;
    private static final String DIGEST = "digest";
    private final StorageClientFactory storageClientFactory;

    public RetrieveSecureTraceabilityDataFilePlugin() {
        this(StorageClientFactory.getInstance());
    }

    @VisibleForTesting
    RetrieveSecureTraceabilityDataFilePlugin(StorageClientFactory storageClientFactory) {
        this.storageClientFactory = storageClientFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        try (StorageClient storageClient = this.storageClientFactory.getClient();){
            JsonNode eventDetail = param.getObjectMetadata();
            TraceabilityEvent traceabilityEvent = (TraceabilityEvent)JsonHandler.getFromJsonNode((JsonNode)eventDetail, TraceabilityEvent.class);
            DataCategory dataCategory = this.getDataCategory(traceabilityEvent);
            HashMap<String, String> digests = new HashMap<String, String>();
            List offerIds = storageClient.getOffers(VitamConfiguration.getDefaultStrategy());
            HashMap existsMap = new HashMap(storageClient.exists(VitamConfiguration.getDefaultStrategy(), dataCategory, traceabilityEvent.getFileName(), offerIds));
            boolean exists = existsMap.values().stream().allMatch(e -> e);
            if (!exists) {
                existsMap.values().removeIf(Predicate.isEqual(Boolean.TRUE));
                ItemStatus result = PluginHelper.buildItemStatusWithMessage(PLUGIN_NAME, StatusCode.KO, String.format("Unable to find data file with name %s in all offers %s", traceabilityEvent.getFileName(), existsMap.keySet().toString()));
                this.saveReport(param, handler, this.createTraceabilityReportEntry(param, traceabilityEvent, digests, result, TraceabilityError.FILE_NOT_FOUND));
                HandlerUtils.save(handler, (Object)"", param.getObjectName() + File.separator + "error");
                ItemStatus itemStatus = result;
                return itemStatus;
            }
            digests.putAll(this.getOfferDigests(storageClient, dataCategory, traceabilityEvent.getFileName(), VitamConfiguration.getDefaultStrategy(), offerIds));
            HashSet hashes = new HashSet(digests.values());
            if (hashes.isEmpty()) {
                ItemStatus result = PluginHelper.buildItemStatusWithMessage(PLUGIN_NAME, StatusCode.KO, "Error: unable to retrive all hashes!");
                this.saveReport(param, handler, this.createTraceabilityReportEntry(param, traceabilityEvent, digests, result, TraceabilityError.HASH_NOT_FOUND));
                HandlerUtils.save(handler, (Object)"", param.getObjectName() + File.separator + "error");
                ItemStatus itemStatus = result;
                return itemStatus;
            }
            try {
                String digest = (String)Iterables.getOnlyElement(hashes);
                HandlerUtils.save(handler, (Object)traceabilityEvent, 0);
                handler.addOutputResult(1, (Object)digest);
            }
            catch (IllegalArgumentException e2) {
                ItemStatus result = PluginHelper.buildItemStatusWithMessage(PLUGIN_NAME, StatusCode.KO, "Error: hashes are not equals!");
                this.saveReport(param, handler, this.createTraceabilityReportEntry(param, traceabilityEvent, digests, result, TraceabilityError.INEQUAL_HASHES));
                HandlerUtils.save(handler, (Object)"", param.getObjectName() + File.separator + "error");
                ItemStatus itemStatus = result;
                if (storageClient == null) return itemStatus;
                storageClient.close();
                return itemStatus;
            }
            ItemStatus result = PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.OK);
            this.saveReport(param, handler, this.createTraceabilityReportEntry(param, traceabilityEvent, digests, result, null));
            ItemStatus itemStatus = result;
            return itemStatus;
        }
        catch (InvalidParseOperationException | StorageNotFoundClientException | StorageServerClientException | IOException e3) {
            throw new ProcessingException(e3);
        }
    }

    private TraceabilityReportEntry createTraceabilityReportEntry(WorkerParameters param, TraceabilityEvent traceabilityEvent, Map<String, String> digests, ItemStatus result, TraceabilityError error) {
        return new TraceabilityReportEntry(param.getObjectName(), traceabilityEvent.getLogType().name(), result.getGlobalStatus().name(), result.getMessage(), error, null, digests, traceabilityEvent.getFileName(), null);
    }

    private void saveReport(WorkerParameters param, HandlerIO handlerIO, TraceabilityReportEntry traceabilityReportEntry) throws IOException, ProcessingException {
        HandlerUtils.save(handlerIO, (Object)traceabilityReportEntry, param.getObjectName() + File.separator + "report.json");
    }

    private DataCategory getDataCategory(TraceabilityEvent traceabilityEvent) {
        if (traceabilityEvent.getLogType() == null) {
            throw new IllegalStateException("Missing traceability event type");
        }
        switch (traceabilityEvent.getLogType()) {
            case OPERATION: 
            case UNIT_LIFECYCLE: 
            case OBJECTGROUP_LIFECYCLE: {
                return DataCategory.LOGBOOK;
            }
            case STORAGE: {
                return DataCategory.STORAGETRACEABILITY;
            }
        }
        throw new IllegalStateException("Invalid traceability event type " + traceabilityEvent.getLogType());
    }

    private Map<String, String> getOfferDigests(StorageClient storageClient, DataCategory dataCategory, String objectGuid, String strategyId, List<String> offerIds) throws StorageNotFoundClientException, StorageServerClientException {
        JsonNode information = storageClient.getInformation(strategyId, dataCategory, objectGuid, offerIds, true);
        return offerIds.stream().map(e -> new AbstractMap.SimpleEntry<String, JsonNode>((String)e, information.get(e))).filter(e -> Objects.nonNull(e.getValue())).filter(e -> !((JsonNode)e.getValue()).isMissingNode()).filter(e -> !((JsonNode)e.getValue()).isNull()).map(e -> new AbstractMap.SimpleEntry<String, String>((String)e.getKey(), ((JsonNode)e.getValue()).get(DIGEST).textValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

