/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.traceability;

import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageException;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ExtractSecureTraceabilityDataFilePlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ExtractSecureTraceabilityDataFilePlugin.class);
    private static final String PLUGIN_NAME = "EXTRACT_SECURE_TRACEABILITY_DATA_FILE";
    private static final int TRACEABILITY_FILE_IN_RANK = 0;
    private final WorkspaceClientFactory workspaceClientFactory;

    public ExtractSecureTraceabilityDataFilePlugin() {
        this(WorkspaceClientFactory.getInstance((WorkspaceType)WorkspaceType.VITAM));
    }

    public ExtractSecureTraceabilityDataFilePlugin(WorkspaceClientFactory workspaceClientFactory) {
        this.workspaceClientFactory = workspaceClientFactory;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        if (handler.isExistingFileInWorkspace(param.getObjectName() + File.separator + "error")) {
            return PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.KO);
        }
        try (WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();){
            File traceabilityFile = (File)handler.getInput(0);
            String zipContainer = "traceabilityOperation" + File.separator + param.getObjectName();
            if (workspaceClient.isExistingFolder(param.getContainerName(), zipContainer)) {
                workspaceClient.deleteObject(param.getContainerName(), zipContainer);
                LOGGER.warn("folder was already existing, re-extracting audit zip");
            }
            workspaceClient.uncompressObject(param.getContainerName(), zipContainer, "application/zip", (InputStream)new FileInputStream(traceabilityFile));
        }
        catch (ContentAddressableStorageException | IOException e) {
            LOGGER.error(e);
            return PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.FATAL, null);
        }
        return PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.OK, null);
    }
}

