/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.traceability;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import fr.gouv.vitam.batch.report.model.TraceabilityError;
import fr.gouv.vitam.batch.report.model.entry.TraceabilityReportEntry;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.accesslog.AccessLogUtils;
import fr.gouv.vitam.common.digest.Digest;
import fr.gouv.vitam.common.digest.DigestType;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.logbook.common.model.TraceabilityEvent;
import fr.gouv.vitam.logbook.common.model.TraceabilityType;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageNotFoundClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageUnavailableDataFromAsyncOfferClientException;
import fr.gouv.vitam.storage.engine.common.exception.StorageNotFoundException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.handler.HandlerUtils;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;

public class ChecksSecureTraceabilityDataStoragelogPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ChecksSecureTraceabilityDataStoragelogPlugin.class);
    private static final String PLUGIN_NAME = "CHECKS_SECURE_TRACEABILITY_DATA_STORAGELOG";
    private static final int EVENT_DETAIL_DATA_IN_RANK = 0;
    private static final String DIGEST = "digest";
    private final StorageClientFactory storageClientFactory;

    public ChecksSecureTraceabilityDataStoragelogPlugin() {
        this(StorageClientFactory.getInstance());
    }

    @VisibleForTesting
    ChecksSecureTraceabilityDataStoragelogPlugin(StorageClientFactory storageClientFactory) {
        this.storageClientFactory = storageClientFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        if (handler.isExistingFileInWorkspace(param.getObjectName() + File.separator + "error")) {
            return PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.KO);
        }
        try (StorageClient storageClient = this.storageClientFactory.getClient();){
            File traceabilityEventJsonFile = (File)handler.getInput(0);
            TraceabilityEvent traceabilityEvent = (TraceabilityEvent)JsonHandler.getFromFile((File)traceabilityEventJsonFile, TraceabilityEvent.class);
            if (traceabilityEvent.getLogType().equals((Object)TraceabilityType.STORAGE)) {
                String dataFilePath = "traceabilityOperation" + File.separator + param.getObjectName() + File.separator + "data.txt";
                TraceabilityEvent traceabilityDataEvent = (TraceabilityEvent)JsonHandler.getFromJsonNode((JsonNode)handler.getJsonFromWorkspace(dataFilePath), TraceabilityEvent.class);
                HashMap<String, String> digests = new HashMap<String, String>();
                List offerIds = storageClient.getOffers(VitamConfiguration.getDefaultStrategy());
                HashMap existsMap = new HashMap(storageClient.exists(VitamConfiguration.getDefaultStrategy(), DataCategory.STORAGELOG, traceabilityDataEvent.getFileName(), offerIds));
                boolean exists = existsMap.values().stream().allMatch(e -> e);
                if (!exists) {
                    existsMap.values().removeIf(Predicate.isEqual(Boolean.TRUE));
                    ItemStatus result = PluginHelper.buildItemStatusWithMessage(PLUGIN_NAME, StatusCode.KO, String.format("Cannot find storagelog data with filename %s in offers %s", traceabilityDataEvent.getFileName(), existsMap.keySet().toString()));
                    this.updateReport(param, handler, t -> t.setStatus(result.getGlobalStatus().name()).setMessage(result.getMessage()).setError(TraceabilityError.FILE_NOT_FOUND).appendExtraData(Map.of("fileId", traceabilityDataEvent.getFileName(), "offersHashes", digests)));
                    ItemStatus itemStatus = result;
                    return itemStatus;
                }
                digests.putAll(this.getOfferDigests(storageClient, traceabilityDataEvent.getFileName(), VitamConfiguration.getDefaultStrategy(), offerIds));
                HashSet hashes = new HashSet(digests.values());
                if (hashes.isEmpty()) {
                    ItemStatus result = PluginHelper.buildItemStatusWithMessage(PLUGIN_NAME, StatusCode.KO, "Error: unable to retrive all hashes!");
                    this.updateReport(param, handler, t -> t.setStatus(result.getGlobalStatus().name()).setMessage(result.getMessage()).setError(TraceabilityError.HASH_NOT_FOUND).appendExtraData(Map.of("offersHashes", digests)));
                    ItemStatus itemStatus = result;
                    return itemStatus;
                }
                String digest = (String)Iterables.getOnlyElement(hashes);
                Response response = storageClient.getContainerAsync(VitamConfiguration.getDefaultStrategy(), traceabilityDataEvent.getFileName(), DataCategory.STORAGELOG, AccessLogUtils.getNoLogAccessLog());
                DigestType digestType = traceabilityDataEvent.getDigestAlgorithm() != null ? traceabilityDataEvent.getDigestAlgorithm() : VitamConfiguration.getDefaultDigestType();
                Digest eventDigest = new Digest(digestType);
                eventDigest.update((InputStream)response.readEntity(InputStream.class));
                if (!eventDigest.digestHex().equals(digest)) {
                    ItemStatus result = PluginHelper.buildItemStatusWithMessage(PLUGIN_NAME, StatusCode.KO, "Storagelog data fingerprint invalid");
                    this.updateReport(param, handler, t -> t.setStatus(result.getGlobalStatus().name()).setMessage(result.getMessage()).setError(TraceabilityError.INVALID_FINGERPRINT).appendExtraData(Map.of("offersHashes", digests, "securedHash", eventDigest.digestHex())));
                    ItemStatus itemStatus = result;
                    return itemStatus;
                }
                ItemStatus result = PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.OK);
                this.updateReport(param, handler, t -> t.setStatus(result.getGlobalStatus().name()).setMessage(result.getMessage()));
                ItemStatus itemStatus = result;
                return itemStatus;
            }
            ItemStatus itemStatus = PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.OK);
            return itemStatus;
        }
        catch (InvalidParseOperationException | StorageNotFoundClientException | StorageServerClientException | StorageUnavailableDataFromAsyncOfferClientException | StorageNotFoundException | IOException e2) {
            throw new ProcessingException(e2);
        }
    }

    private void updateReport(WorkerParameters param, HandlerIO handlerIO, Consumer<TraceabilityReportEntry> updater) throws IOException, ProcessingException, InvalidParseOperationException {
        String path = param.getObjectName() + File.separator + "report.json";
        TraceabilityReportEntry traceabilityReportEntry = (TraceabilityReportEntry)JsonHandler.getFromJsonNode((JsonNode)handlerIO.getJsonFromWorkspace(path), TraceabilityReportEntry.class);
        updater.accept(traceabilityReportEntry);
        HandlerUtils.save(handlerIO, (Object)traceabilityReportEntry, path);
    }

    private Map<String, String> getOfferDigests(StorageClient storageClient, String objectGuid, String strategyId, List<String> offerIds) throws StorageNotFoundClientException, StorageServerClientException {
        JsonNode information = storageClient.getInformation(strategyId, DataCategory.STORAGELOG, objectGuid, offerIds, true);
        return offerIds.stream().map(e -> new AbstractMap.SimpleEntry<String, JsonNode>((String)e, information.get(e))).filter(e -> Objects.nonNull(e.getValue())).filter(e -> !((JsonNode)e.getValue()).isMissingNode()).filter(e -> !((JsonNode)e.getValue()).isNull()).map(e -> new AbstractMap.SimpleEntry<String, String>((String)e.getKey(), ((JsonNode)e.getValue()).get(DIGEST).textValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static /* synthetic */ void lambda$execute$4(ItemStatus result, Map digests, TraceabilityReportEntry t) {
        t.setStatus(result.getGlobalStatus().name()).setMessage(result.getMessage()).setError(TraceabilityError.INEQUAL_HASHES).appendExtraData(Map.of("offersHashes", digests));
    }
}

