/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.traceability;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.batch.report.model.TraceabilityError;
import fr.gouv.vitam.batch.report.model.entry.TraceabilityReportEntry;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.accesslog.AccessLogUtils;
import fr.gouv.vitam.common.digest.Digest;
import fr.gouv.vitam.common.digest.DigestType;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.logbook.common.model.TraceabilityEvent;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageUnavailableDataFromAsyncOfferClientException;
import fr.gouv.vitam.storage.engine.common.exception.StorageNotFoundException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.handler.HandlerUtils;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;
import javax.ws.rs.core.Response;

public class ChecksSecureTraceabilityDataHashesPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ChecksSecureTraceabilityDataHashesPlugin.class);
    private static final String PLUGIN_NAME = "CHECKS_SECURE_TRACEABILITY_DATA_HASHES";
    private static final int TRACEABILITY_EVENT_IN_RANK = 0;
    private static final int DIGEST_IN_RANK = 1;
    private StorageClientFactory storageClientFactory;

    public ChecksSecureTraceabilityDataHashesPlugin() {
        this(StorageClientFactory.getInstance());
    }

    @VisibleForTesting
    protected ChecksSecureTraceabilityDataHashesPlugin(StorageClientFactory storageClientFactory) {
        this.storageClientFactory = storageClientFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        if (handler.isExistingFileInWorkspace(param.getObjectName() + File.separator + "error")) {
            return PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.KO);
        }
        try (StorageClient storageClient = this.storageClientFactory.getClient();){
            File traceabilityEventJsonFile = (File)handler.getInput(0);
            TraceabilityEvent traceabilityEvent = (TraceabilityEvent)JsonHandler.getFromFile((File)traceabilityEventJsonFile, TraceabilityEvent.class);
            String digest = String.valueOf(handler.getInput(1));
            DataCategory dataCategory = this.getDataCategory(traceabilityEvent);
            Response response = storageClient.getContainerAsync(VitamConfiguration.getDefaultStrategy(), traceabilityEvent.getFileName(), dataCategory, AccessLogUtils.getNoLogAccessLog());
            File traceabilityFile = (File)response.readEntity(File.class);
            DigestType digestType = traceabilityEvent.getDigestAlgorithm() != null ? traceabilityEvent.getDigestAlgorithm() : VitamConfiguration.getDefaultDigestType();
            Digest eventDigest = new Digest(digestType);
            eventDigest.update(traceabilityFile);
            if (!eventDigest.digestHex().equals(digest)) {
                ItemStatus result = PluginHelper.buildItemStatusWithMessage(PLUGIN_NAME, StatusCode.KO, "Invalid data fingerprint");
                this.updateReport(param, handler, report -> report.setMessage(result.getMessage()).setSecuredHash(eventDigest.digestHex()).setError(TraceabilityError.INVALID_FINGERPRINT));
                HandlerUtils.save(handler, (Object)"", param.getObjectName() + File.separator + "error");
                ItemStatus itemStatus2 = result;
                return itemStatus2;
            }
            handler.addOutputResult(0, (Object)traceabilityFile, false);
            ItemStatus result = PluginHelper.buildItemStatus(PLUGIN_NAME, StatusCode.OK);
            this.updateReport(param, handler, report -> report.setMessage(result.getMessage()).setSecuredHash(eventDigest.digestHex()));
            ItemStatus itemStatus = result;
            return itemStatus;
        }
        catch (InvalidParseOperationException | StorageServerClientException | StorageUnavailableDataFromAsyncOfferClientException | StorageNotFoundException | IOException e) {
            throw new ProcessingException(e);
        }
    }

    private void updateReport(WorkerParameters param, HandlerIO handlerIO, Consumer<TraceabilityReportEntry> updater) throws IOException, ProcessingException, InvalidParseOperationException {
        String path = param.getObjectName() + File.separator + "report.json";
        TraceabilityReportEntry traceabilityReportEntry = (TraceabilityReportEntry)JsonHandler.getFromJsonNode((JsonNode)handlerIO.getJsonFromWorkspace(path), TraceabilityReportEntry.class);
        updater.accept(traceabilityReportEntry);
        HandlerUtils.save(handlerIO, (Object)traceabilityReportEntry, path);
    }

    private DataCategory getDataCategory(TraceabilityEvent traceabilityEvent) {
        if (traceabilityEvent.getLogType() == null) {
            throw new IllegalStateException("Missing traceability event type");
        }
        switch (traceabilityEvent.getLogType()) {
            case OPERATION: 
            case UNIT_LIFECYCLE: 
            case OBJECTGROUP_LIFECYCLE: {
                return DataCategory.LOGBOOK;
            }
            case STORAGE: {
                return DataCategory.STORAGETRACEABILITY;
            }
        }
        throw new IllegalStateException("Invalid traceability event type " + traceabilityEvent.getLogType());
    }
}

