/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.signingInformation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import fr.gouv.vitam.common.model.administration.IngestContractModel;
import fr.gouv.vitam.common.model.administration.SignaturePolicy;
import fr.gouv.vitam.worker.core.plugin.signingInformation.SigningInformationEnum;
import fr.gouv.vitam.worker.core.plugin.signingInformation.exception.SigningInformationException;

public class IngestContractChecker {
    private static final String TAG_ARCHIVE_UNIT = "ArchiveUnit";
    private static final String TAG_SIGNING_INFORMATION = "SigningInformation";
    private static final String PATH_SIGNING_INFORMATION = "ArchiveUnit.SigningInformation";
    private static final String TAG_SIGNING_ROLE = "SigningRole";
    private static final String TAG_DETACHED_SIGNING_ROLE = "DetachedSigningRole";
    private static final String SIGNATURE = "Signature";
    private static final String TIMESTAMP = "Timestamp";
    private static final String ADDITIONAL_PROOF = "AdditionalProof";
    private static final String SIGNED_DOCUMENT = "SignedDocument";
    private JsonNode archiveUnit;
    private IngestContractModel ingestContractModel;

    public IngestContractChecker(JsonNode archiveUnit, IngestContractModel ingestContractModel) {
        this.archiveUnit = archiveUnit;
        this.ingestContractModel = ingestContractModel;
    }

    public void check() throws SigningInformationException {
        SignaturePolicy signaturePolicy = this.ingestContractModel.getSignaturePolicy();
        if (signaturePolicy != null && signaturePolicy.getSignedDocument() != null) {
            this.validateSignedDocumentPolicy(signaturePolicy);
        }
    }

    private void validateSignedDocumentPolicy(SignaturePolicy signaturePolicy) throws SigningInformationException {
        SignaturePolicy.SignedDocumentPolicyEnum signedDocumentPolicy = signaturePolicy.getSignedDocument();
        switch (signedDocumentPolicy) {
            case MANDATORY: {
                this.validateMandatorySignedDocument();
                if (!this.hasSigningInformation() || !this.verifySigningRoleValue(SIGNED_DOCUMENT)) break;
                this.validateDeclaredFields(signaturePolicy);
                break;
            }
            case FORBIDDEN: {
                this.validateForbiddenSignedDocument();
                break;
            }
            case ALLOWED: {
                if (!this.hasSigningInformation() || !this.verifySigningRoleValue(SIGNED_DOCUMENT)) break;
                this.validateDeclaredFields(signaturePolicy);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown SignedDocument policy");
            }
        }
    }

    private void validateMandatorySignedDocument() throws SigningInformationException {
        if (!this.hasSigningInformation()) {
            throw new SigningInformationException(SigningInformationEnum.MANDATORY_SIGNED_DOCUMENT);
        }
    }

    private void validateForbiddenSignedDocument() throws SigningInformationException {
        if (this.hasSigningInformation()) {
            throw new SigningInformationException(SigningInformationEnum.FORBIDDEN_SIGNED_DOCUMENT);
        }
    }

    private boolean hasSigningInformation() {
        JsonNode signingInformationNode = this.archiveUnit.path(TAG_ARCHIVE_UNIT).path(TAG_SIGNING_INFORMATION);
        return !signingInformationNode.isMissingNode();
    }

    private void validateDeclaredFields(SignaturePolicy signaturePolicy) throws SigningInformationException {
        this.validateFieldIfRequired(signaturePolicy.isDeclaredSignature(), SigningInformationEnum.MISSING_DECLARED_SIGNATURE, SIGNATURE);
        this.validateFieldIfRequired(signaturePolicy.isDeclaredTimestamp(), SigningInformationEnum.MISSING_DECLARED_TIMESTAMP, TIMESTAMP);
        this.validateFieldIfRequired(signaturePolicy.isDeclaredAdditionalProof(), SigningInformationEnum.MISSING_DECLARED_ADDITIONAL_PROOF, ADDITIONAL_PROOF);
    }

    private void validateFieldIfRequired(Boolean isDeclared, SigningInformationEnum signingInformationEnum, String value) throws SigningInformationException {
        if (Boolean.TRUE.equals(isDeclared) && !this.hasSigningRoleAttributeWithValue(value)) {
            throw new SigningInformationException(signingInformationEnum);
        }
    }

    private boolean verifySigningRoleValue(String value) {
        JsonNode signingInformationNode = this.archiveUnit.path(TAG_ARCHIVE_UNIT).path(TAG_SIGNING_INFORMATION);
        ArrayNode signingRoleNode = (ArrayNode)signingInformationNode.path(TAG_SIGNING_ROLE);
        return this.hasValue(signingRoleNode, value);
    }

    private boolean hasSigningRoleAttributeWithValue(String value) {
        JsonNode signingInformationNode = this.archiveUnit.path(TAG_ARCHIVE_UNIT).path(TAG_SIGNING_INFORMATION);
        JsonNode detachedSigningRoleNode = signingInformationNode.path(TAG_DETACHED_SIGNING_ROLE);
        return this.verifySigningRoleValue(value) || !detachedSigningRoleNode.isMissingNode() && this.hasValue((ArrayNode)detachedSigningRoleNode, value);
    }

    private boolean hasValue(ArrayNode arrayNode, String targetValue) {
        for (JsonNode node : arrayNode) {
            if (!node.isTextual() || !targetValue.equals(node.asText())) continue;
            return true;
        }
        return false;
    }
}

