/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.revertupdate;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.parser.request.multiple.SelectParserMultiple;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.logbook.LogbookOperation;
import fr.gouv.vitam.common.model.revertupdate.RevertUpdateOptions;
import fr.gouv.vitam.logbook.common.exception.LogbookClientException;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClient;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClientFactory;
import fr.gouv.vitam.metadata.api.exception.MetaDataClientServerException;
import fr.gouv.vitam.metadata.api.exception.MetaDataDocumentSizeException;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.bson.Document;

public class RevertUpdateUnitCheckPlugin
extends ActionHandler {
    @VisibleForTesting
    static final String REVERT_UPDATE_UNITS_JSONL_FILE = "revertUpdateUnits.jsonl";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(RevertUpdateUnitCheckPlugin.class);
    private static final String PLUGIN_ID = "REVERT_CHECK";
    private static final String REGEX_START = "^[+\\-]\\s+\\\"";
    private static final String REGEX_END = "\" :.*$";
    private static final List<List<String>> AUTORIZED_FIELDS = List.of(List.of("^[+\\-]\\s+\\\"Title\" :.*$", "^[+\\-]\\s+\\\"Description\" :.*$", "^[+\\-]\\s+\\\"DescriptionLevel\" :.*$"), List.of("^[+\\-]\\s+\\\"Title\" :.*$", "^[+\\-]\\s+\\\"Title_\\..*\" :.*$", "^[+\\-]\\s+\\\"Description\" :.*$", "^[+\\-]\\s+\\\"Description_\\..*\" :.*$", "^[+\\-]\\s+\\\"DescriptionLevel\" :.*$"));
    private final MetaDataClientFactory metaDataClientFactory;
    private final LogbookLifeCyclesClientFactory logbookLifeCyclesClientFactory;

    public RevertUpdateUnitCheckPlugin() {
        this(MetaDataClientFactory.getInstance(), LogbookLifeCyclesClientFactory.getInstance());
    }

    @VisibleForTesting
    public RevertUpdateUnitCheckPlugin(MetaDataClientFactory metaDataClientFactory, LogbookLifeCyclesClientFactory logbookLifeCyclesClientFactory) {
        this.metaDataClientFactory = metaDataClientFactory;
        this.logbookLifeCyclesClientFactory = logbookLifeCyclesClientFactory;
    }

    /*
     * Exception decompiling
     */
    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 24[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nonnull
    private Map<String, Document> getUnitsLFC(String operationId, List<JsonNode> units) throws LogbookClientException, InvalidParseOperationException {
        try (LogbookLifeCyclesClient logbookLifeCyclesClient = this.logbookLifeCyclesClientFactory.getClient();){
            List unitsId = units.stream().map(e -> e.get(VitamFieldsHelper.id())).map(JsonNode::asText).collect(Collectors.toList());
            List unitLifeCycleByIds = logbookLifeCyclesClient.getRawUnitLifeCycleByIds(unitsId);
            List events = JsonHandler.getFromJsonNodeList((List)unitLifeCycleByIds, (TypeReference)new TypeReference<LogbookOperation>(){});
            Map<String, Document> map = events.stream().map(e -> e.getEvents().stream().filter(t -> t.getEvIdProc().equals(operationId)).findFirst()).map(Optional::get).map(e -> new AbstractMap.SimpleEntry<String, Document>(e.getObId(), Document.parse((String)e.getEvDetData()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            return map;
        }
    }

    private boolean isCanBeDone(String operationId, List<JsonNode> unitIds) {
        return unitIds.stream().map(e -> e.get(VitamFieldsHelper.operations())).map(e -> StreamSupport.stream(e.spliterator(), false).map(JsonNode::asText).collect(Collectors.toList())).map(e -> e.indexOf(operationId) == e.size() - 1).reduce(true, Boolean::logicalAnd);
    }

    private JsonNode retriveUnits(RevertUpdateOptions options, String operationId) throws InvalidParseOperationException, InvalidCreateOperationException, MetaDataExecutionException, MetaDataDocumentSizeException, MetaDataClientServerException {
        try (MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();){
            SelectParserMultiple parser = new SelectParserMultiple();
            parser.parse(options.getDslRequest());
            parser.getRequest().addQueries(new Query[]{QueryHelper.and().add(new Query[]{QueryHelper.in((String)VitamFieldsHelper.operations(), (String[])new String[]{operationId}), QueryHelper.ne((String)VitamFieldsHelper.initialOperation(), (String)operationId)})});
            parser.getRequest().setProjection(JsonHandler.createObjectNode().set(BuilderToken.PROJECTION.FIELDS.exactToken(), (JsonNode)JsonHandler.createObjectNode().put(VitamFieldsHelper.id(), 1).put(VitamFieldsHelper.operations(), 1)));
            JsonNode jsonNode = metaDataClient.selectUnits((JsonNode)parser.getRequest().getFinalSelect());
            return jsonNode;
        }
    }

    private static /* synthetic */ String[] lambda$execute$15(int x$0) {
        return new String[x$0];
    }

    private static /* synthetic */ AbstractMap.SimpleEntry lambda$execute$14(Map oldValues, String e) {
        return new AbstractMap.SimpleEntry<String, String>(e, (String)oldValues.get(e));
    }

    private static /* synthetic */ AbstractMap.SimpleEntry lambda$execute$13(Map oldValues, String e) {
        return new AbstractMap.SimpleEntry<String, String>(e, (String)oldValues.get(e));
    }

    private static /* synthetic */ String lambda$execute$12(String[] e) {
        return e[1];
    }

    private static /* synthetic */ String lambda$execute$11(String[] e) {
        return e[0];
    }

    private static /* synthetic */ String[] lambda$execute$10(String e) {
        return e.replaceAll("^\"", "").replaceAll("\"$", "").split("\" : \"");
    }

    private static /* synthetic */ String lambda$execute$9(String e) {
        return e.replaceFirst("\\+\\s+", "");
    }

    private static /* synthetic */ boolean lambda$execute$8(String e) {
        return e.startsWith("+");
    }

    private static /* synthetic */ String lambda$execute$7(String[] e) {
        return e[1];
    }

    private static /* synthetic */ String lambda$execute$6(String[] e) {
        return e[0];
    }

    private static /* synthetic */ String[] lambda$execute$5(String e) {
        return e.replaceAll("^\"", "").replaceAll("\"$", "").split("\" : \"");
    }

    private static /* synthetic */ String lambda$execute$4(String e) {
        return e.replaceFirst("-\\s+", "");
    }

    private static /* synthetic */ boolean lambda$execute$3(String e) {
        return e.startsWith("-");
    }

    private static /* synthetic */ boolean lambda$execute$2(RevertUpdateOptions options, String e) {
        return options.getFields().stream().anyMatch(t -> e.contains("\"" + t + "\" :"));
    }

    private static /* synthetic */ boolean lambda$execute$0(int version, String e) {
        return AUTORIZED_FIELDS.get(version).stream().anyMatch(e::matches);
    }
}

