/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.reclassification.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.utils.AccessContractRestrictionHelper;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamDBException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.administration.AccessContractModel;
import fr.gouv.vitam.common.model.rules.InheritedRuleCategoryResponseModel;
import fr.gouv.vitam.common.model.rules.UnitInheritedRulesResponseModel;
import fr.gouv.vitam.metadata.api.exception.MetaDataClientServerException;
import fr.gouv.vitam.metadata.api.exception.MetaDataDocumentSizeException;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.worker.core.plugin.reclassification.model.UnitGraphInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;

public class UnitGraphInfoLoader {
    static final int MAX_ELASTIC_SEARCH_IN_REQUEST_SIZE = 1000;
    private static final String RESULTS = "$results";

    public Set<String> selectUnitsByQueryDslAndAccessContract(MetaDataClient metaDataClient, SelectMultiQuery select, AccessContractModel accessContractModel) throws InvalidParseOperationException, VitamDBException, MetaDataDocumentSizeException, MetaDataExecutionException, MetaDataClientServerException, InvalidCreateOperationException {
        select.addUsedProjection(new String[]{VitamFieldsHelper.id()});
        JsonNode selectWithAccessContractFilter = AccessContractRestrictionHelper.applyAccessContractRestrictionForUnitForSelect((JsonNode)select.getFinalSelect(), (AccessContractModel)accessContractModel);
        JsonNode resultJson = metaDataClient.selectUnits(selectWithAccessContractFilter);
        HashSet<String> foundUnitIds = new HashSet<String>();
        for (JsonNode node : resultJson.get(RESULTS)) {
            String id = node.get(VitamFieldsHelper.id()).asText();
            foundUnitIds.add(id);
        }
        return foundUnitIds;
    }

    public Set<String> selectUnitsByIdsAndAccessContract(MetaDataClient metaDataClient, Set<String> unitIds, AccessContractModel accessContractModel) throws InvalidParseOperationException, InvalidCreateOperationException, VitamDBException, MetaDataDocumentSizeException, MetaDataExecutionException, MetaDataClientServerException {
        HashSet<String> foundUnitIds = new HashSet<String>();
        for (List ids : ListUtils.partition(new ArrayList<String>(unitIds), (int)1000)) {
            SelectMultiQuery select = new SelectMultiQuery();
            select.setQuery((Query)QueryHelper.in((String)VitamFieldsHelper.id(), (String[])ids.toArray(new String[0])));
            foundUnitIds.addAll(this.selectUnitsByQueryDslAndAccessContract(metaDataClient, select, accessContractModel));
        }
        return foundUnitIds;
    }

    public Map<String, UnitGraphInfo> selectAllUnitGraphByIds(MetaDataClient metaDataClient, Set<String> unitIds) throws InvalidParseOperationException, MetaDataExecutionException, MetaDataDocumentSizeException, MetaDataClientServerException, InvalidCreateOperationException {
        HashMap<String, UnitGraphInfo> unitGraphById = new HashMap<String, UnitGraphInfo>();
        HashSet<String> unitsToLoad = new HashSet<String>(unitIds);
        while (!unitsToLoad.isEmpty()) {
            Set<String> bulkIds = unitsToLoad.stream().limit(1000L).collect(Collectors.toSet());
            for (String bulkId : bulkIds) {
                unitGraphById.put(bulkId, null);
            }
            List<UnitGraphInfo> loadedUnits = this.loadBulkUnitGraph(metaDataClient, bulkIds);
            for (UnitGraphInfo loadedUnit : loadedUnits) {
                unitGraphById.put(loadedUnit.getId(), loadedUnit);
                for (String up : loadedUnit.getUp()) {
                    if (unitGraphById.containsKey(up)) continue;
                    unitsToLoad.add(up);
                }
            }
            unitsToLoad.removeAll(bulkIds);
        }
        return unitGraphById;
    }

    private List<UnitGraphInfo> loadBulkUnitGraph(MetaDataClient metaDataClient, Collection<String> bulkIds) throws InvalidCreateOperationException, InvalidParseOperationException, MetaDataExecutionException, MetaDataDocumentSizeException, MetaDataClientServerException {
        SelectMultiQuery select = new SelectMultiQuery();
        select.setQuery((Query)QueryHelper.in((String)VitamFieldsHelper.id(), (String[])bulkIds.toArray(new String[0])));
        ObjectNode projection = JsonHandler.createObjectNode();
        ObjectNode fields = JsonHandler.createObjectNode();
        fields.put(VitamFieldsHelper.id(), 1);
        fields.put(VitamFieldsHelper.unitups(), 1);
        fields.put(VitamFieldsHelper.unitType(), 1);
        select.setProjection((JsonNode)projection);
        JsonNode resultJson = metaDataClient.selectUnits((JsonNode)select.getFinalSelect()).get(RESULTS);
        UnitGraphInfo[] unitGraphInfo = (UnitGraphInfo[])JsonHandler.getFromJsonNode((JsonNode)resultJson, UnitGraphInfo[].class);
        return Arrays.asList(unitGraphInfo);
    }

    public Map<String, InheritedRuleCategoryResponseModel> loadInheritedHoldRules(MetaDataClient metaDataClient, Set<String> unitsIdToRearrange) throws InvalidCreateOperationException, InvalidParseOperationException, MetaDataDocumentSizeException, MetaDataExecutionException, MetaDataClientServerException {
        HashMap<String, InheritedRuleCategoryResponseModel> result = new HashMap<String, InheritedRuleCategoryResponseModel>();
        UnmodifiableIterator idIterator = Iterators.partition(unitsIdToRearrange.iterator(), (int)1000);
        while (idIterator.hasNext()) {
            List bulkIds = (List)idIterator.next();
            SelectMultiQuery select = new SelectMultiQuery();
            select.setQuery((Query)QueryHelper.in((String)VitamFieldsHelper.id(), (String[])bulkIds.toArray(new String[0])));
            select.addUsedProjection(new String[]{VitamFieldsHelper.id()});
            JsonNode resultJson = metaDataClient.selectUnitsWithInheritedRules((JsonNode)select.getFinalSelect());
            RequestResponseOK requestResponseOK = RequestResponseOK.getFromJsonNode((JsonNode)resultJson);
            for (JsonNode unitJson : requestResponseOK.getResults()) {
                String unitId = unitJson.get(VitamFieldsHelper.id()).asText();
                JsonNode inheritedRules = unitJson.get("InheritedRules");
                UnitInheritedRulesResponseModel unitInheritedRulesResponseModel = (UnitInheritedRulesResponseModel)JsonHandler.getFromJsonNode((JsonNode)inheritedRules, UnitInheritedRulesResponseModel.class);
                InheritedRuleCategoryResponseModel inheritedHoldRules = (InheritedRuleCategoryResponseModel)unitInheritedRulesResponseModel.getRuleCategories().get("HoldRule");
                result.put(unitId, inheritedHoldRules);
            }
        }
        return result;
    }
}

