/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.reclassification.utils;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;

public class GraphCycleDetector {
    private MultiValuedMap<String, String> childToParents = new HashSetValuedHashMap();
    private MultiValuedMap<String, String> parentToChildren = new HashSetValuedHashMap();

    public void addRelations(String child, Collection<String> parents) {
        this.childToParents.putAll((Object)child, parents);
        for (String parent : parents) {
            this.parentToChildren.put((Object)parent, (Object)child);
        }
    }

    public void removeRelations(String child, Collection<String> parents) {
        for (String parent : parents) {
            this.childToParents.removeMapping((Object)child, (Object)parent);
            this.parentToChildren.removeMapping((Object)parent, (Object)child);
        }
    }

    public Set<String> checkCycles() {
        this.removeNodesWithoutParents();
        this.removeNodesWithoutChildren();
        return this.getCycles();
    }

    private void removeNodesWithoutParents() {
        List rootParents;
        block0: while (!(rootParents = this.parentToChildren.keySet().stream().filter(node -> !this.childToParents.containsKey(node)).collect(Collectors.toList())).isEmpty()) {
            Iterator iterator = rootParents.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                String rootParent = (String)iterator.next();
                for (String child : this.parentToChildren.get((Object)rootParent)) {
                    this.childToParents.removeMapping((Object)child, (Object)rootParent);
                }
                this.parentToChildren.remove((Object)rootParent);
            }
            break;
        }
        return;
    }

    private void removeNodesWithoutChildren() {
        List leaves;
        block0: while (!(leaves = this.childToParents.keySet().stream().filter(node -> !this.parentToChildren.containsKey(node)).collect(Collectors.toList())).isEmpty()) {
            Iterator iterator = leaves.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                String leaf = (String)iterator.next();
                for (String child : this.childToParents.get((Object)leaf)) {
                    this.parentToChildren.removeMapping((Object)child, (Object)leaf);
                }
                this.childToParents.remove((Object)leaf);
            }
            break;
        }
        return;
    }

    private Set<String> getCycles() {
        return this.childToParents.keySet();
    }

    @VisibleForTesting
    MultiValuedMap<String, String> getChildToParents() {
        return this.childToParents;
    }

    @VisibleForTesting
    MultiValuedMap<String, String> getParentToChildren() {
        return this.parentToChildren;
    }
}

