/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.reclassification.dsl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.parser.request.multiple.SelectParserMultiple;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.worker.core.plugin.reclassification.dsl.ParsedReclassificationDslRequest;
import fr.gouv.vitam.worker.core.plugin.reclassification.dsl.ParsedReclassificationDslRequestEntry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.collections4.SetUtils;

public class ReclassificationRequestDslParser {
    private static final String QUERY = "$query";
    private static final String ROOTS = "$roots";

    public ParsedReclassificationDslRequest parseReclassificationRequest(JsonNode reclassificationDslJson) throws InvalidParseOperationException {
        if (!reclassificationDslJson.isArray() || reclassificationDslJson.size() == 0) {
            throw new InvalidParseOperationException("Expected array of reclassification updates DSLs");
        }
        ArrayList<ParsedReclassificationDslRequestEntry> entries = new ArrayList<ParsedReclassificationDslRequestEntry>();
        for (JsonNode singleReclassificationDslJson : reclassificationDslJson) {
            SelectMultiQuery selectMultiQuery = this.parseSelectMultiQuery(singleReclassificationDslJson);
            Set<String> attachments = this.parseReclassificationDslAttachments(singleReclassificationDslJson);
            Set<String> detachments = this.parseReclassificationDslDetachments(singleReclassificationDslJson);
            entries.add(new ParsedReclassificationDslRequestEntry(selectMultiQuery, attachments, detachments));
        }
        return new ParsedReclassificationDslRequest(entries);
    }

    private SelectMultiQuery parseSelectMultiQuery(JsonNode singleReclassificationDslJson) throws InvalidParseOperationException {
        JsonNode query = singleReclassificationDslJson.get(QUERY);
        JsonNode roots = singleReclassificationDslJson.get(ROOTS);
        ObjectNode selectDsl = JsonHandler.createObjectNode();
        selectDsl.set(QUERY, query);
        if (roots != null) {
            selectDsl.set(ROOTS, roots);
        }
        SelectParserMultiple selectParserMultiple = new SelectParserMultiple();
        selectParserMultiple.parse((JsonNode)selectDsl);
        return selectParserMultiple.getRequest();
    }

    private Set<String> parseReclassificationDslAttachments(JsonNode singleReclassificationDslJson) throws InvalidParseOperationException {
        return this.parseReclassificationDslAction(singleReclassificationDslJson, BuilderToken.UPDATEACTION.ADD.exactToken());
    }

    private Set<String> parseReclassificationDslDetachments(JsonNode singleReclassificationDslJson) throws InvalidParseOperationException {
        return this.parseReclassificationDslAction(singleReclassificationDslJson, BuilderToken.UPDATEACTION.PULL.exactToken());
    }

    private Set<String> parseReclassificationDslAction(JsonNode singleReclassificationDslJson, String action) throws InvalidParseOperationException {
        Set<String> result = null;
        JsonNode actionNode = singleReclassificationDslJson.get("$action");
        if (null == actionNode || !actionNode.isArray()) {
            throw new InvalidParseOperationException("Expected action array");
        }
        for (JsonNode actionEntry : actionNode) {
            if (!actionEntry.isObject()) {
                throw new InvalidParseOperationException("Expected object action entry");
            }
            Iterator it = actionEntry.fieldNames();
            while (it.hasNext()) {
                String actionName = (String)it.next();
                if (!action.equals(actionName)) continue;
                if (result != null) {
                    throw new InvalidParseOperationException("Duplicate action " + actionName);
                }
                result = this.parseReclassificationAction(actionName, actionEntry);
            }
        }
        if (result == null) {
            return SetUtils.emptySet();
        }
        return result;
    }

    private Set<String> parseReclassificationAction(String actionName, JsonNode actionEntry) throws InvalidParseOperationException {
        HashSet<String> result = new HashSet<String>();
        JsonNode actionJsonNode = actionEntry.get(actionName);
        if (!actionJsonNode.isObject()) {
            throw new InvalidParseOperationException("Expected object node for action " + actionName);
        }
        ObjectNode actionObjectNode = (ObjectNode)actionJsonNode;
        if (actionObjectNode.size() != 1) {
            throw new InvalidParseOperationException("Expected single field name for action " + actionName);
        }
        String fieldName = (String)actionObjectNode.fieldNames().next();
        if (!VitamFieldsHelper.unitups().equals(fieldName)) {
            throw new InvalidParseOperationException("Invalid field name for reclassification action " + fieldName);
        }
        JsonNode idsJsonNode = actionObjectNode.get(fieldName);
        if (!idsJsonNode.isArray() || idsJsonNode.size() == 0) {
            throw new InvalidParseOperationException("Expected array node of unit ids");
        }
        for (JsonNode jsonNode : idsJsonNode) {
            if (!jsonNode.isTextual()) {
                throw new InvalidParseOperationException("Expected unit id node");
            }
            result.add(jsonNode.asText());
        }
        return result;
    }
}

