/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.reclassification;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.query.action.Action;
import fr.gouv.vitam.common.database.builder.query.action.UpdateActionHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.UpdateMultiQuery;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.guid.GUIDReader;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.LifeCycleStatusCode;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleUnitParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClient;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClientFactory;
import fr.gouv.vitam.metadata.api.exception.MetaDataClientServerException;
import fr.gouv.vitam.metadata.api.exception.MetaDataDocumentSizeException;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.api.exception.MetaDataNotFoundException;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.reclassification.model.ReclassificationEventDetails;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.util.Set;

public class UnitAttachmentPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(UnitAttachmentPlugin.class);
    private static final String UNIT_ATTACHMENT = "UNIT_ATTACHMENT";
    private static final String UNITS_TO_ATTACH_DIR = "UnitsToAttach";
    private final LogbookLifeCyclesClientFactory logbookLifeCyclesClientFactory;
    private final MetaDataClientFactory metaDataClientFactory;

    public UnitAttachmentPlugin() {
        this(LogbookLifeCyclesClientFactory.getInstance(), MetaDataClientFactory.getInstance());
    }

    @VisibleForTesting
    UnitAttachmentPlugin(LogbookLifeCyclesClientFactory logbookLifeCyclesClientFactory, MetaDataClientFactory metaDataClientFactory) {
        this.logbookLifeCyclesClientFactory = logbookLifeCyclesClientFactory;
        this.metaDataClientFactory = metaDataClientFactory;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        String unitId = param.getObjectName();
        try {
            Set<String> parentUnitsToAdd = this.getParentsToAdd(handler, unitId);
            this.updateUnit(unitId, parentUnitsToAdd);
            this.updateUnitLifeCycle(param, unitId, parentUnitsToAdd);
        }
        catch (ProcessingStatusException e) {
            LOGGER.error("Unit attachment failed with status [" + e.getStatusCode() + "]", (Throwable)e);
            return PluginHelper.buildItemStatus(UNIT_ATTACHMENT, e.getStatusCode(), e.getEventDetails());
        }
        LOGGER.debug("Unit attachment succeeded: " + unitId);
        return PluginHelper.buildItemStatus(UNIT_ATTACHMENT, StatusCode.OK, null);
    }

    private Set<String> getParentsToAdd(HandlerIO handler, String unitId) throws ProcessingException, ProcessingStatusException {
        try {
            JsonNode attachmentJson = handler.getJsonFromWorkspace("UnitsToAttach/" + unitId);
            return (Set)JsonHandler.getFromJsonNode((JsonNode)attachmentJson, Set.class);
        }
        catch (InvalidParseOperationException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not parse attachment json", e);
        }
    }

    private void updateUnit(String unitId, Set<String> parentUnitsToAdd) throws ProcessingStatusException {
        try (MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();){
            UpdateMultiQuery updateMultiQuery = new UpdateMultiQuery();
            updateMultiQuery.addActions(new Action[]{UpdateActionHelper.add((String)VitamFieldsHelper.unitups(), (String[])parentUnitsToAdd.toArray(new String[0])), UpdateActionHelper.add((String)VitamFieldsHelper.operations(), (String[])new String[]{VitamThreadUtils.getVitamSession().getRequestId()})});
            metaDataClient.updateUnitById((JsonNode)updateMultiQuery.getFinalUpdate(), unitId);
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException | MetaDataClientServerException | MetaDataDocumentSizeException | MetaDataExecutionException | MetaDataNotFoundException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "An error occurred during unit attachment", e);
        }
    }

    private void updateUnitLifeCycle(WorkerParameters param, String unitId, Set<String> parentUnitsToAdd) throws ProcessingStatusException {
        try (LogbookLifeCyclesClient logbookLifeCyclesClient = this.logbookLifeCyclesClientFactory.getClient();){
            ReclassificationEventDetails eventDetails = new ReclassificationEventDetails().setAddedParents(parentUnitsToAdd);
            LogbookLifeCycleUnitParameters logbookLCParam = PluginHelper.createParameters(GUIDReader.getGUID((String)param.getContainerName()), StatusCode.OK, GUIDReader.getGUID((String)unitId), UNIT_ATTACHMENT, eventDetails, LogbookTypeProcess.RECLASSIFICATION);
            logbookLifeCyclesClient.update((LogbookLifeCycleParameters)logbookLCParam, LifeCycleStatusCode.LIFE_CYCLE_COMMITTED);
        }
        catch (VitamException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "An error occurred during lifecycle update for unit " + unitId, e);
        }
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }
}

