/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.reclassification;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.reclassification.model.ReclassificationOrders;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.apache.commons.collections4.SetUtils;

public class ReclassificationPreparationUpdateDistributionHandler
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ReclassificationPreparationUpdateDistributionHandler.class);
    private static final String RECLASSIFICATION_PREPARATION_UPDATE_DISTRIBUTION = "RECLASSIFICATION_PREPARATION_UPDATE_DISTRIBUTION";
    private static final int RECLASSIFICATION_ORDERS_PARAMETER_RANK = 0;
    private static final String UNITS_TO_DETACH_DIR = "UnitsToDetach";
    private static final String UNITS_TO_ATTACH_DIR = "UnitsToAttach";
    private static final String UNITS_TO_UPDATE_JSONL_FILE = "UnitsToUpdate.jsonl";
    private static final String OG_TO_UPDATE_JSONL_FILE = "ObjectGroupsToUpdate.jsonl";
    private static final String COULD_NOT_EXPORT_THE_LIST_OF_UNITS_AND_OBJECT_GROUPS_TO_UPDATE = "Could not export the list of units and object groups to update";
    private final MetaDataClientFactory metaDataClientFactory;

    public ReclassificationPreparationUpdateDistributionHandler() {
        this(MetaDataClientFactory.getInstance());
    }

    @VisibleForTesting
    ReclassificationPreparationUpdateDistributionHandler(MetaDataClientFactory metaDataClientFactory) {
        this.metaDataClientFactory = metaDataClientFactory;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        try {
            ReclassificationOrders reclassificationOrders = this.loadReclassificationOrders(handler);
            this.prepareUpdates(reclassificationOrders, handler);
        }
        catch (ProcessingStatusException e) {
            LOGGER.error("Reclassification update distribution failed with status [" + e.getStatusCode() + "]", (Throwable)e);
            return PluginHelper.buildItemStatus(RECLASSIFICATION_PREPARATION_UPDATE_DISTRIBUTION, e.getStatusCode(), e.getEventDetails());
        }
        LOGGER.info("Reclassification update distribution succeeded");
        return PluginHelper.buildItemStatus(RECLASSIFICATION_PREPARATION_UPDATE_DISTRIBUTION, StatusCode.OK, null);
    }

    private ReclassificationOrders loadReclassificationOrders(HandlerIO handler) {
        return (ReclassificationOrders)handler.getInput(0);
    }

    private void prepareUpdates(ReclassificationOrders reclassificationUpdates, HandlerIO handler) throws ProcessingStatusException {
        this.prepareDetachments(reclassificationUpdates, handler);
        this.prepareAttachments(reclassificationUpdates, handler);
        this.prepareUnitAndObjectGroupGraphUpdates(reclassificationUpdates);
    }

    private void prepareDetachments(ReclassificationOrders reclassificationOrders, HandlerIO handler) throws ProcessingStatusException {
        for (String childUnitId : reclassificationOrders.getChildToParentDetachments().keySet()) {
            this.storeToWorkspace(handler, reclassificationOrders.getChildToParentDetachments().get((Object)childUnitId), "UnitsToDetach/" + childUnitId);
        }
    }

    private void prepareAttachments(ReclassificationOrders reclassificationOrders, HandlerIO handler) throws ProcessingStatusException {
        for (String childUnitId : reclassificationOrders.getChildToParentAttachments().keySet()) {
            this.storeToWorkspace(handler, reclassificationOrders.getChildToParentAttachments().get((Object)childUnitId), "UnitsToAttach/" + childUnitId);
        }
    }

    private void prepareUnitAndObjectGroupGraphUpdates(ReclassificationOrders reclassificationOrders) throws ProcessingStatusException {
        try (MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();){
            SetUtils.SetView unitIds = SetUtils.union((Set)reclassificationOrders.getChildToParentAttachments().keySet(), (Set)reclassificationOrders.getChildToParentDetachments().keySet());
            metaDataClient.exportReclassificationChildNodes((Set)unitIds, UNITS_TO_UPDATE_JSONL_FILE, OG_TO_UPDATE_JSONL_FILE);
        }
        catch (VitamClientException | MetaDataExecutionException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, COULD_NOT_EXPORT_THE_LIST_OF_UNITS_AND_OBJECT_GROUPS_TO_UPDATE, e);
        }
    }

    private void storeToWorkspace(HandlerIO handler, Object data, String filePath) throws ProcessingStatusException {
        try (InputStream inputStream = JsonHandler.writeToInpustream((Object)data);){
            handler.transferInputStreamToWorkspace(filePath, inputStream, null, false);
        }
        catch (InvalidParseOperationException | ProcessingException | IOException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not store to workspace: " + filePath, e);
        }
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }

    public static String getId() {
        return RECLASSIFICATION_PREPARATION_UPDATE_DISTRIBUTION;
    }
}

