/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.reclassification;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.builder.query.BooleanQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamDBException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.administration.AccessContractModel;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.client.AdminManagementClient;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.functional.administration.common.exception.AdminManagementClientServerException;
import fr.gouv.vitam.metadata.api.exception.MetaDataClientServerException;
import fr.gouv.vitam.metadata.api.exception.MetaDataDocumentSizeException;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.reclassification.dsl.ParsedReclassificationDslRequest;
import fr.gouv.vitam.worker.core.plugin.reclassification.dsl.ParsedReclassificationDslRequestEntry;
import fr.gouv.vitam.worker.core.plugin.reclassification.dsl.ReclassificationRequestDslParser;
import fr.gouv.vitam.worker.core.plugin.reclassification.model.ReclassificationEventDetails;
import fr.gouv.vitam.worker.core.plugin.reclassification.model.ReclassificationOrders;
import fr.gouv.vitam.worker.core.plugin.reclassification.utils.UnitGraphInfoLoader;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;

public class ReclassificationPreparationLoadRequestHandler
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ReclassificationPreparationLoadRequestHandler.class);
    private static final String RECLASSIFICATION_PREPARATION_LOAD_REQUEST = "RECLASSIFICATION_PREPARATION_LOAD_REQUEST";
    private static final int RECLASSIFICATION_ORDERS_PARAMETER_RANK = 0;
    private static final String ACCESS_CONTRACT_ACTIVE_STATUS = "ACTIVE";
    private static final String COULD_NOT_LOAD_REQUEST_FROM_WORKSPACE = "Could not load request from workspace";
    static final String COULD_NOT_PARSE_RECLASSIFICATION_REQUEST = "Could not parse reclassification request";
    static final String NO_ACCESS_CONTRACT_PROVIDED = "No access contract provided";
    static final String ACCESS_CONTRACT_NOT_FOUND_OR_NOT_ACTIVE = "Access contract not found or not active";
    static final String ACCESS_DENIED_OR_MISSING_UNITS = "Access denied or missing units.";
    static final String NO_UNITS_TO_UPDATE = "No units to update.";
    static final String CANNOT_ATTACH_DETACH_SAME_PARENT_UNITS = "Cannot attach & detach same parent units";
    private final int maxBulkThreshold;
    private final int maxUnitsThreshold;
    private final int maxGuildListSizeInLogbookOperation;
    private final AdminManagementClientFactory adminManagementClientFactory;
    private final MetaDataClientFactory metaDataClientFactory;
    private final UnitGraphInfoLoader unitGraphInfoLoader;
    private final ReclassificationRequestDslParser reclassificationRequestDslParser;

    public ReclassificationPreparationLoadRequestHandler() {
        this(AdminManagementClientFactory.getInstance(), MetaDataClientFactory.getInstance(), new UnitGraphInfoLoader(), new ReclassificationRequestDslParser(), VitamConfiguration.getReclassificationMaxBulkThreshold(), VitamConfiguration.getReclassificationMaxUnitsThreshold(), VitamConfiguration.getReclassificationMaxGuildListSizeInLogbookOperation());
    }

    @VisibleForTesting
    ReclassificationPreparationLoadRequestHandler(AdminManagementClientFactory adminManagementClientFactory, MetaDataClientFactory metaDataClientFactory, UnitGraphInfoLoader unitGraphInfoLoader, ReclassificationRequestDslParser reclassificationRequestDslParser, int maxBulkThreshold, int maxUnitsThreshold, int maxGuildListSizeInLogbookOperation) {
        this.adminManagementClientFactory = adminManagementClientFactory;
        this.metaDataClientFactory = metaDataClientFactory;
        this.unitGraphInfoLoader = unitGraphInfoLoader;
        this.reclassificationRequestDslParser = reclassificationRequestDslParser;
        this.maxBulkThreshold = maxBulkThreshold;
        this.maxUnitsThreshold = maxUnitsThreshold;
        this.maxGuildListSizeInLogbookOperation = maxGuildListSizeInLogbookOperation;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        try {
            JsonNode reclassificationDslJson = this.loadReclassificationRequestJsonFromWorkspace(handler);
            ParsedReclassificationDslRequest parsedReclassificationDslRequest = this.parseReclassificationDslRequest(reclassificationDslJson);
            this.checkMaxRequestCount(parsedReclassificationDslRequest);
            AccessContractModel accessContractModel = this.getAccessContract();
            this.checkParentAccessContract(parsedReclassificationDslRequest, accessContractModel);
            ReclassificationOrders reclassificationOrders = this.selectReclassificationOrders(parsedReclassificationDslRequest, accessContractModel);
            this.checkMinUnitsToUpdate(reclassificationOrders);
            this.checkMaxDistinctUnits(reclassificationOrders);
            this.checkAttachmentAndDetachmentForSameParent(reclassificationOrders);
            this.storeReclassificationOrders(handler, reclassificationOrders);
        }
        catch (ProcessingStatusException e) {
            LOGGER.error("Reclassification request loading failed with status [" + e.getStatusCode() + "]", (Throwable)e);
            return PluginHelper.buildItemStatus(RECLASSIFICATION_PREPARATION_LOAD_REQUEST, e.getStatusCode(), e.getEventDetails());
        }
        LOGGER.info("Reclassification request loading succeeded");
        return PluginHelper.buildItemStatus(RECLASSIFICATION_PREPARATION_LOAD_REQUEST, StatusCode.OK, null);
    }

    private JsonNode loadReclassificationRequestJsonFromWorkspace(HandlerIO handler) throws ProcessingStatusException {
        try {
            return handler.getJsonFromWorkspace("request.json");
        }
        catch (ProcessingException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, COULD_NOT_LOAD_REQUEST_FROM_WORKSPACE, e);
        }
    }

    private ParsedReclassificationDslRequest parseReclassificationDslRequest(JsonNode reclassificationDslJson) throws ProcessingStatusException {
        ParsedReclassificationDslRequest parsedReclassificationDslRequest;
        try {
            parsedReclassificationDslRequest = this.reclassificationRequestDslParser.parseReclassificationRequest(reclassificationDslJson);
        }
        catch (InvalidParseOperationException e) {
            String error = COULD_NOT_PARSE_RECLASSIFICATION_REQUEST;
            throw new ProcessingStatusException(StatusCode.KO, new ReclassificationEventDetails().setError(error), error, e);
        }
        return parsedReclassificationDslRequest;
    }

    private void checkMaxRequestCount(ParsedReclassificationDslRequest parsedReclassificationDslRequest) throws ProcessingStatusException {
        if (parsedReclassificationDslRequest.getEntries().size() > this.maxBulkThreshold) {
            String error = String.format("Too many reclassification requests (count= %d, max= %d)", parsedReclassificationDslRequest.getEntries().size(), this.maxBulkThreshold);
            throw new ProcessingStatusException(StatusCode.KO, new ReclassificationEventDetails().setError(error), error);
        }
    }

    private AccessContractModel getAccessContract() throws ProcessingStatusException {
        AccessContractModel accessContractModel;
        block10: {
            String accessContractId = VitamThreadUtils.getVitamSession().getContractId();
            if (accessContractId == null) {
                throw new ProcessingStatusException(StatusCode.KO, new ReclassificationEventDetails().setError(NO_ACCESS_CONTRACT_PROVIDED), NO_ACCESS_CONTRACT_PROVIDED);
            }
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                Select select = new Select();
                BooleanQuery query = QueryHelper.and().add(new Query[]{QueryHelper.eq((String)"Identifier", (String)accessContractId), QueryHelper.eq((String)"Status", (String)ACCESS_CONTRACT_ACTIVE_STATUS)});
                select.setQuery((Query)query);
                ObjectNode queryDsl = select.getFinalSelect();
                RequestResponse response = client.findAccessContracts((JsonNode)queryDsl);
                if (!response.isOk() || ((RequestResponseOK)response).getResults().size() == 0) {
                    throw new ProcessingStatusException(StatusCode.KO, new ReclassificationEventDetails().setError(ACCESS_CONTRACT_NOT_FOUND_OR_NOT_ACTIVE), String.format("Access contract not found or not active '%s'", accessContractId));
                }
                List contracts = ((RequestResponseOK)response).getResults();
                accessContractModel = (AccessContractModel)contracts.get(0);
                if (client == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidCreateOperationException | InvalidParseOperationException | AdminManagementClientServerException e) {
                    throw new ProcessingStatusException(StatusCode.FATAL, String.format("An error occurred during access contract loading '%s'", accessContractId), e);
                }
            }
            client.close();
        }
        return accessContractModel;
    }

    private void checkParentAccessContract(ParsedReclassificationDslRequest parsedReclassificationDslRequest, AccessContractModel accessContractModel) throws ProcessingStatusException {
        try (MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();){
            HashSet<String> unitsToCheckIds = new HashSet<String>();
            for (ParsedReclassificationDslRequestEntry entry : parsedReclassificationDslRequest.getEntries()) {
                unitsToCheckIds.addAll(entry.getAttachments());
                unitsToCheckIds.addAll(entry.getDetachments());
            }
            Set<String> foundUnitIds = this.unitGraphInfoLoader.selectUnitsByIdsAndAccessContract(metaDataClient, unitsToCheckIds, accessContractModel);
            if (foundUnitIds.size() == unitsToCheckIds.size()) {
                return;
            }
            SetUtils.SetView notFoundUnitIds = SetUtils.difference(unitsToCheckIds, foundUnitIds);
            Set<String> firstNotFoundUnitIds = notFoundUnitIds.stream().limit(this.maxGuildListSizeInLogbookOperation).collect(Collectors.toSet());
            String error = ACCESS_DENIED_OR_MISSING_UNITS;
            ReclassificationEventDetails eventDetails = new ReclassificationEventDetails().setError(error).setMissingOrForbiddenUnits(firstNotFoundUnitIds);
            throw new ProcessingStatusException(StatusCode.KO, eventDetails, error);
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException | VitamDBException | MetaDataClientServerException | MetaDataDocumentSizeException | MetaDataExecutionException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not check unit ids", e);
        }
    }

    private ReclassificationOrders selectReclassificationOrders(ParsedReclassificationDslRequest parsedReclassificationDslRequest, AccessContractModel accessContractModel) throws ProcessingStatusException {
        ReclassificationOrders reclassificationOrders;
        block11: {
            MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();
            try {
                HashSetValuedHashMap childToParentAttachments = new HashSetValuedHashMap();
                HashSetValuedHashMap childToParentDetachments = new HashSetValuedHashMap();
                for (ParsedReclassificationDslRequestEntry entry : parsedReclassificationDslRequest.getEntries()) {
                    Set<String> childIds = this.unitGraphInfoLoader.selectUnitsByQueryDslAndAccessContract(metaDataClient, entry.getSelectMultiQuery(), accessContractModel);
                    for (String childId : childIds) {
                        childToParentAttachments.putAll((Object)childId, entry.getAttachments());
                        childToParentDetachments.putAll((Object)childId, entry.getDetachments());
                    }
                }
                reclassificationOrders = new ReclassificationOrders((HashSetValuedHashMap<String, String>)childToParentAttachments, (HashSetValuedHashMap<String, String>)childToParentDetachments);
                if (metaDataClient == null) break block11;
            }
            catch (Throwable childToParentAttachments) {
                try {
                    if (metaDataClient != null) {
                        try {
                            metaDataClient.close();
                        }
                        catch (Throwable throwable) {
                            childToParentAttachments.addSuppressed(throwable);
                        }
                    }
                    throw childToParentAttachments;
                }
                catch (InvalidCreateOperationException | InvalidParseOperationException e) {
                    String error = COULD_NOT_PARSE_RECLASSIFICATION_REQUEST;
                    throw new ProcessingStatusException(StatusCode.KO, new ReclassificationEventDetails().setError(error), error, e);
                }
                catch (VitamDBException | MetaDataClientServerException | MetaDataDocumentSizeException | MetaDataExecutionException e) {
                    String error = "Could not select units to update";
                    throw new ProcessingStatusException(StatusCode.FATAL, new ReclassificationEventDetails().setError(error), error, e);
                }
            }
            metaDataClient.close();
        }
        return reclassificationOrders;
    }

    private void checkMinUnitsToUpdate(ReclassificationOrders reclassificationOrders) throws ProcessingStatusException {
        if (reclassificationOrders.getChildToParentAttachments().isEmpty() && reclassificationOrders.getChildToParentDetachments().isEmpty()) {
            String error = NO_UNITS_TO_UPDATE;
            throw new ProcessingStatusException(StatusCode.KO, new ReclassificationEventDetails().setError(error), error);
        }
    }

    private void checkMaxDistinctUnits(ReclassificationOrders reclassificationUpdates) throws ProcessingStatusException {
        SetUtils.SetView childUnitIds = SetUtils.union((Set)reclassificationUpdates.getChildToParentAttachments().keySet(), (Set)reclassificationUpdates.getChildToParentDetachments().keySet());
        if (childUnitIds.size() > this.maxUnitsThreshold) {
            String error = String.format("Too many units in reclassification request (count= %d, max=%d)", childUnitIds.size(), this.maxUnitsThreshold);
            throw new ProcessingStatusException(StatusCode.KO, new ReclassificationEventDetails().setError(error), error);
        }
    }

    private void checkAttachmentAndDetachmentForSameParent(ReclassificationOrders reclassificationOrders) throws ProcessingStatusException {
        SetUtils.SetView unitsWithBothAttachmentsAndDetachments = SetUtils.intersection((Set)reclassificationOrders.getChildToParentAttachments().keySet(), (Set)reclassificationOrders.getChildToParentDetachments().keySet());
        for (String unitId : unitsWithBothAttachmentsAndDetachments) {
            Set detachments;
            Set attachments = reclassificationOrders.getChildToParentAttachments().get((Object)unitId);
            SetUtils.SetView duplicateIds = SetUtils.intersection((Set)attachments, (Set)(detachments = reclassificationOrders.getChildToParentDetachments().get((Object)unitId)));
            if (duplicateIds.isEmpty()) continue;
            String error = CANNOT_ATTACH_DETACH_SAME_PARENT_UNITS;
            throw new ProcessingStatusException(StatusCode.KO, new ReclassificationEventDetails().setError(error), error);
        }
    }

    private void storeReclassificationOrders(HandlerIO handler, ReclassificationOrders reclassificationOrders) throws ProcessingStatusException {
        try {
            handler.addOutputResult(0, (Object)reclassificationOrders, false);
        }
        catch (ProcessingException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not store reclassification orders", e);
        }
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }

    public static String getId() {
        return RECLASSIFICATION_PREPARATION_LOAD_REQUEST;
    }
}

