/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.reclassification;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.rules.InheritedRuleCategoryResponseModel;
import fr.gouv.vitam.common.model.rules.InheritedRuleResponseModel;
import fr.gouv.vitam.metadata.api.exception.MetaDataClientServerException;
import fr.gouv.vitam.metadata.api.exception.MetaDataDocumentSizeException;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.reclassification.model.ReclassificationEventDetails;
import fr.gouv.vitam.worker.core.plugin.reclassification.model.ReclassificationOrders;
import fr.gouv.vitam.worker.core.plugin.reclassification.utils.UnitGraphInfoLoader;
import fr.gouv.vitam.worker.core.utils.HoldRuleUtils;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.time.LocalDate;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.SetUtils;

public class ReclassificationPreparationCheckHoldRulesHandler
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ReclassificationPreparationCheckHoldRulesHandler.class);
    private static final String RECLASSIFICATION_PREPARATION_CHECK_HOLD_RULES = "RECLASSIFICATION_PREPARATION_CHECK_HOLD_RULES";
    static final int RECLASSIFICATION_ORDERS_PARAMETER_RANK = 0;
    static final String COULD_NOT_FIND_UNITS_INHERITED_RULES = "Could not find units inherited rules";
    static final String RECLASSIFICATION_BLOCKED_BY_HOLD_RULES = "Cannot apply reclassification request. Hold rules with PreventRearrangement found";
    private final int maxGuidListSizeInLogbookOperation;
    private final MetaDataClientFactory metaDataClientFactory;
    private final UnitGraphInfoLoader unitGraphInfoLoader;

    public ReclassificationPreparationCheckHoldRulesHandler() {
        this(MetaDataClientFactory.getInstance(), new UnitGraphInfoLoader(), VitamConfiguration.getReclassificationMaxGuildListSizeInLogbookOperation());
    }

    @VisibleForTesting
    ReclassificationPreparationCheckHoldRulesHandler(MetaDataClientFactory metaDataClientFactory, UnitGraphInfoLoader unitGraphInfoLoader, int maxGuidListSizeInLogbookOperation) {
        this.metaDataClientFactory = metaDataClientFactory;
        this.unitGraphInfoLoader = unitGraphInfoLoader;
        this.maxGuidListSizeInLogbookOperation = maxGuidListSizeInLogbookOperation;
    }

    private static boolean isPreventRearrangementEnabled(InheritedRuleResponseModel rule) {
        Object preventRearrangementAttribute = rule.getExtendedRuleAttributes().get("PreventRearrangement");
        if (preventRearrangementAttribute == null) {
            return false;
        }
        if (!(preventRearrangementAttribute instanceof Boolean)) {
            throw new IllegalStateException("Expected PreventRearrangement to be a Boolean type");
        }
        return (Boolean)preventRearrangementAttribute;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        try {
            ReclassificationOrders reclassificationOrders = this.loadReclassificationOrders(handler);
            this.checkHoldRules(reclassificationOrders);
        }
        catch (ProcessingStatusException e) {
            LOGGER.error("Reclassification hold rule check failed with status [" + e.getStatusCode() + "]", (Throwable)e);
            return PluginHelper.buildItemStatus(RECLASSIFICATION_PREPARATION_CHECK_HOLD_RULES, e.getStatusCode(), e.getEventDetails());
        }
        LOGGER.info("Reclassification hold rule check succeeded");
        return PluginHelper.buildItemStatus(RECLASSIFICATION_PREPARATION_CHECK_HOLD_RULES, StatusCode.OK, null);
    }

    private ReclassificationOrders loadReclassificationOrders(HandlerIO handler) {
        return (ReclassificationOrders)handler.getInput(0);
    }

    private void checkHoldRules(ReclassificationOrders reclassificationOrders) throws ProcessingStatusException {
        SetUtils.SetView unitsIdToRearrange = SetUtils.union((Set)reclassificationOrders.getChildToParentAttachments().keySet(), (Set)reclassificationOrders.getChildToParentDetachments().keySet());
        try (MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();){
            Map<String, InheritedRuleCategoryResponseModel> unitInheritedHoldRules = this.unitGraphInfoLoader.loadInheritedHoldRules(metaDataClient, (Set<String>)unitsIdToRearrange);
            this.checkNotFoundUnits((Set<String>)unitsIdToRearrange, unitInheritedHoldRules.keySet());
            this.checkActiveHoldRuleRearrangement(unitInheritedHoldRules);
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException | MetaDataClientServerException | MetaDataDocumentSizeException | MetaDataExecutionException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not load unit graph information", e);
        }
    }

    private void checkNotFoundUnits(Set<String> unitIds, Set<String> foundUnitIds) throws ProcessingStatusException {
        SetUtils.SetView notFoundUnits = SetUtils.difference(unitIds, foundUnitIds);
        if (!notFoundUnits.isEmpty()) {
            Set<String> firstNotFoundUnits = notFoundUnits.stream().limit(this.maxGuidListSizeInLogbookOperation).collect(Collectors.toSet());
            ReclassificationEventDetails eventDetails = new ReclassificationEventDetails().setError(COULD_NOT_FIND_UNITS_INHERITED_RULES).setNotFoundUnits(firstNotFoundUnits);
            throw new ProcessingStatusException(StatusCode.FATAL, eventDetails, COULD_NOT_FIND_UNITS_INHERITED_RULES);
        }
    }

    private void checkActiveHoldRuleRearrangement(Map<String, InheritedRuleCategoryResponseModel> unitInheritedHoldRules) throws ProcessingStatusException {
        Set<String> unitIdsBlockedByHoldRules = unitInheritedHoldRules.entrySet().stream().filter(entry -> this.hasActiveHoldRulesWithPreventRearrangement((String)entry.getKey(), (InheritedRuleCategoryResponseModel)entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (unitIdsBlockedByHoldRules.isEmpty()) {
            LOGGER.info("No HoldRules with PreventRearrangement found");
            return;
        }
        ReclassificationEventDetails eventDetails = new ReclassificationEventDetails().setError(RECLASSIFICATION_BLOCKED_BY_HOLD_RULES).setUnitsBlockedByHoldRules(unitIdsBlockedByHoldRules);
        throw new ProcessingStatusException(StatusCode.KO, eventDetails, RECLASSIFICATION_BLOCKED_BY_HOLD_RULES);
    }

    private boolean hasActiveHoldRulesWithPreventRearrangement(String unitId, InheritedRuleCategoryResponseModel inheritedHoldRules) {
        LocalDate today = LocalDate.now();
        Set<InheritedRuleResponseModel> activeHoldRules = HoldRuleUtils.listActiveHoldRules(unitId, inheritedHoldRules.getRules(), today);
        if (activeHoldRules.isEmpty()) {
            LOGGER.debug("No active hold rules found for unit " + unitId);
            return false;
        }
        Set activeHoldRulesWithPreventRearrangement = activeHoldRules.stream().filter(ReclassificationPreparationCheckHoldRulesHandler::isPreventRearrangementEnabled).map(InheritedRuleResponseModel::getRuleId).collect(Collectors.toSet());
        if (activeHoldRulesWithPreventRearrangement.isEmpty()) {
            LOGGER.debug("No active hold rules with PreventRearrangement found for unit " + unitId);
            return false;
        }
        LOGGER.warn("Active hold rules with PreventRearrangement found for unit " + unitId + ": " + activeHoldRulesWithPreventRearrangement);
        return true;
    }

    public static String getId() {
        return RECLASSIFICATION_PREPARATION_CHECK_HOLD_RULES;
    }
}

