/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.reclassification;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.UnitType;
import fr.gouv.vitam.metadata.api.exception.MetaDataClientServerException;
import fr.gouv.vitam.metadata.api.exception.MetaDataDocumentSizeException;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.reclassification.model.IllegalUnitTypeAttachment;
import fr.gouv.vitam.worker.core.plugin.reclassification.model.ReclassificationEventDetails;
import fr.gouv.vitam.worker.core.plugin.reclassification.model.ReclassificationOrders;
import fr.gouv.vitam.worker.core.plugin.reclassification.model.UnitGraphInfo;
import fr.gouv.vitam.worker.core.plugin.reclassification.utils.GraphCycleDetector;
import fr.gouv.vitam.worker.core.plugin.reclassification.utils.UnitGraphInfoLoader;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ReclassificationPreparationCheckGraphHandler
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ReclassificationPreparationCheckGraphHandler.class);
    private static final String RECLASSIFICATION_PREPARATION_CHECK_GRAPH = "RECLASSIFICATION_PREPARATION_CHECK_GRAPH";
    private static final int RECLASSIFICATION_ORDERS_PARAMETER_RANK = 0;
    static final String COULD_NOT_LOAD_UNITS = "Could not load units";
    static final String CANNOT_APPLY_RECLASSIFICATION_REQUEST_CYCLE_DETECTED = "Cannot apply reclassification request. Cycle detected";
    static final String INVALID_UNIT_TYPE_ATTACHMENTS = "Invalid unit type attachment(s)";
    private final int maxGuildListSizeInLogbookOperation;
    private final MetaDataClientFactory metaDataClientFactory;
    private final UnitGraphInfoLoader unitGraphInfoLoader;

    public ReclassificationPreparationCheckGraphHandler() {
        this(MetaDataClientFactory.getInstance(), new UnitGraphInfoLoader(), VitamConfiguration.getReclassificationMaxGuildListSizeInLogbookOperation());
    }

    @VisibleForTesting
    ReclassificationPreparationCheckGraphHandler(MetaDataClientFactory metaDataClientFactory, UnitGraphInfoLoader unitGraphInfoLoader, int maxGuildListSizeInLogbookOperation) {
        this.metaDataClientFactory = metaDataClientFactory;
        this.unitGraphInfoLoader = unitGraphInfoLoader;
        this.maxGuildListSizeInLogbookOperation = maxGuildListSizeInLogbookOperation;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        try {
            ReclassificationOrders reclassificationOrders = this.loadReclassificationOrders(handler);
            this.checkGraphCoherence(reclassificationOrders);
        }
        catch (ProcessingStatusException e) {
            LOGGER.error("Reclassification graph check failed with status [" + e.getStatusCode() + "]", (Throwable)e);
            return PluginHelper.buildItemStatus(RECLASSIFICATION_PREPARATION_CHECK_GRAPH, e.getStatusCode(), e.getEventDetails());
        }
        LOGGER.info("Reclassification graph check succeeded");
        return PluginHelper.buildItemStatus(RECLASSIFICATION_PREPARATION_CHECK_GRAPH, StatusCode.OK, null);
    }

    private ReclassificationOrders loadReclassificationOrders(HandlerIO handler) {
        return (ReclassificationOrders)handler.getInput(0);
    }

    private void checkGraphCoherence(ReclassificationOrders reclassificationUpdates) throws ProcessingStatusException {
        Map<String, UnitGraphInfo> unitGraphByIds = this.loadAllUnitGraphByIds(reclassificationUpdates);
        this.checkAttachmentUnitTypeCoherence(reclassificationUpdates, unitGraphByIds);
        this.checkCycles(reclassificationUpdates, unitGraphByIds);
    }

    private Map<String, UnitGraphInfo> loadAllUnitGraphByIds(ReclassificationOrders reclassificationOrders) throws ProcessingStatusException {
        Map<String, UnitGraphInfo> map;
        block9: {
            MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();
            try {
                Set<String> allUnitIds = this.getAllUnitIds(reclassificationOrders);
                Map<String, UnitGraphInfo> result = this.unitGraphInfoLoader.selectAllUnitGraphByIds(metaDataClient, allUnitIds);
                Set notFoundUnits = result.entrySet().stream().filter(entry -> entry.getValue() == null).map(Map.Entry::getKey).collect(Collectors.toSet());
                if (!notFoundUnits.isEmpty()) {
                    Set<String> firstNotFoundUnits = notFoundUnits.stream().limit(this.maxGuildListSizeInLogbookOperation).collect(Collectors.toSet());
                    ReclassificationEventDetails eventDetails = new ReclassificationEventDetails().setError(COULD_NOT_LOAD_UNITS).setNotFoundUnits(firstNotFoundUnits);
                    throw new ProcessingStatusException(StatusCode.FATAL, eventDetails, COULD_NOT_LOAD_UNITS);
                }
                map = result;
                if (metaDataClient == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (metaDataClient != null) {
                        try {
                            metaDataClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidCreateOperationException | InvalidParseOperationException | MetaDataClientServerException | MetaDataDocumentSizeException | MetaDataExecutionException e) {
                    throw new ProcessingStatusException(StatusCode.FATAL, "Could not load unit graph information", e);
                }
            }
            metaDataClient.close();
        }
        return map;
    }

    private Set<String> getAllUnitIds(ReclassificationOrders reclassificationOrders) {
        HashSet<String> result = new HashSet<String>();
        result.addAll(reclassificationOrders.getChildToParentAttachments().keySet());
        result.addAll(reclassificationOrders.getChildToParentAttachments().values());
        result.addAll(reclassificationOrders.getChildToParentDetachments().keySet());
        result.addAll(reclassificationOrders.getChildToParentDetachments().values());
        return result;
    }

    private void checkAttachmentUnitTypeCoherence(ReclassificationOrders reclassificationOrders, Map<String, UnitGraphInfo> unitGraphByIds) throws ProcessingStatusException {
        ArrayList<IllegalUnitTypeAttachment> illegalUnitTypeAttachments = new ArrayList<IllegalUnitTypeAttachment>();
        for (Map.Entry entry : reclassificationOrders.getChildToParentAttachments().entries()) {
            String childUnitId = (String)entry.getKey();
            String parentUnitId = (String)entry.getValue();
            UnitType childUnitType = unitGraphByIds.get(childUnitId).getUnitType();
            UnitType parentUnitType = unitGraphByIds.get(parentUnitId).getUnitType();
            if (childUnitType.ordinal() <= parentUnitType.ordinal()) continue;
            illegalUnitTypeAttachments.add(new IllegalUnitTypeAttachment(childUnitId, childUnitType, parentUnitId, parentUnitType));
        }
        if (!illegalUnitTypeAttachments.isEmpty()) {
            String error = INVALID_UNIT_TYPE_ATTACHMENTS;
            List<IllegalUnitTypeAttachment> firstIllegalUnitTypeAttachments = illegalUnitTypeAttachments.stream().limit(this.maxGuildListSizeInLogbookOperation).collect(Collectors.toList());
            ReclassificationEventDetails eventDetails = new ReclassificationEventDetails().setError(error).setIllegalUnitTypeAttachments(firstIllegalUnitTypeAttachments);
            throw new ProcessingStatusException(StatusCode.KO, eventDetails, error);
        }
    }

    private void checkCycles(ReclassificationOrders reclassificationOrders, Map<String, UnitGraphInfo> unitGraphByIds) throws ProcessingStatusException {
        GraphCycleDetector graphCycleDetector = new GraphCycleDetector();
        for (UnitGraphInfo unitGraph : unitGraphByIds.values()) {
            String unitId = unitGraph.getId();
            graphCycleDetector.addRelations(unitId, unitGraph.getUp());
            graphCycleDetector.addRelations(unitId, reclassificationOrders.getChildToParentAttachments().get((Object)unitId));
            graphCycleDetector.removeRelations(unitId, reclassificationOrders.getChildToParentDetachments().get((Object)unitId));
        }
        Set<String> graphCycles = graphCycleDetector.checkCycles();
        if (!graphCycles.isEmpty()) {
            Set<String> firstGraphCycles = graphCycles.stream().limit(this.maxGuildListSizeInLogbookOperation).collect(Collectors.toSet());
            String error = CANNOT_APPLY_RECLASSIFICATION_REQUEST_CYCLE_DETECTED;
            ReclassificationEventDetails eventDetails = new ReclassificationEventDetails().setError(error).setUnitsWithCycles(firstGraphCycles);
            throw new ProcessingStatusException(StatusCode.KO, eventDetails, error);
        }
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }

    public static String getId() {
        return RECLASSIFICATION_PREPARATION_CHECK_GRAPH;
    }
}

