/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.reclassification;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.GraphComputeResponse;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public abstract class AbstractGraphComputePlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AbstractGraphComputePlugin.class);
    private final MetaDataClientFactory metaDataClientFactory;

    public AbstractGraphComputePlugin() {
        this.metaDataClientFactory = MetaDataClientFactory.getInstance();
    }

    @VisibleForTesting
    public AbstractGraphComputePlugin(MetaDataClientFactory metaDataClientFactory) {
        this.metaDataClientFactory = metaDataClientFactory;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        throw new ProcessingException("No need to implements method");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public List<ItemStatus> executeList(WorkerParameters workerParameters, HandlerIO handler) {
        itemStatus = new ItemStatus(this.getPluginKeyName());
        aggregateItemStatus = new ArrayList<ItemStatus>();
        items = workerParameters.getObjectNameList();
        ids = new HashSet<E>(items);
        initialSize = ids.size();
        finalSize = 0;
        graphComputeResponse = null;
        try {
            metaDataClient = this.metaDataClientFactory.getClient();
            try {
                graphComputeResponse = metaDataClient.computeGraph(this.getGraphComputeAction(), ids);
                switch (1.$SwitchMap$fr$gouv$vitam$common$model$GraphComputeResponse$GraphComputeAction[this.getGraphComputeAction().ordinal()]) {
                    case 1: {
                        finalSize = graphComputeResponse.getUnitCount();
                        ** break;
lbl16:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        finalSize = graphComputeResponse.getGotCount();
                        ** break;
lbl20:
                        // 1 sources

                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected graph compute action " + this.getGraphComputeAction());
                    }
                }
            }
            finally {
                if (metaDataClient != null) {
                    metaDataClient.close();
                }
            }
        }
        catch (VitamClientException e) {
            AbstractGraphComputePlugin.LOGGER.error("Processing exception", (Throwable)e);
            itemStatus.increment(StatusCode.FATAL);
        }
        finally {
            handler.setCurrentObjectId(null);
        }
        fatal = Math.abs(initialSize - finalSize);
        if (0 == fatal) {
            itemStatus.increment(StatusCode.OK, finalSize);
        } else {
            if (null != graphComputeResponse && !Strings.isNullOrEmpty((String)graphComputeResponse.getErrorMessage())) {
                infoNode = JsonHandler.createObjectNode();
                infoNode.put("evDetTechData", graphComputeResponse.getErrorMessage());
                itemStatus.setEvDetailData(JsonHandler.unprettyPrint((Object)infoNode));
            }
            itemStatus.increment(StatusCode.OK, finalSize).increment(StatusCode.FATAL, fatal);
        }
        aggregateItemStatus.add(new ItemStatus(this.getPluginKeyName()).setItemsStatus(this.getPluginKeyName(), itemStatus));
        return aggregateItemStatus;
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }

    abstract GraphComputeResponse.GraphComputeAction getGraphComputeAction();

    abstract String getPluginKeyName();
}

