/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.purge;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.batch.report.model.entry.PurgeUnitReportEntry;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.utils.MetadataDocumentHelper;
import fr.gouv.vitam.common.exception.InvalidGuidOperationException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.guid.GUIDReader;
import fr.gouv.vitam.common.i18n.VitamLogbookMessages;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.LifeCycleStatusCode;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.objectgroup.PersistentIdentifierModel;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.logbook.common.exception.LogbookClientBadRequestException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientNotFoundException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientServerException;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookLifeCycleUnitParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClient;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClientFactory;
import fr.gouv.vitam.metadata.api.exception.MetaDataClientServerException;
import fr.gouv.vitam.metadata.api.exception.MetaDataDocumentSizeException;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.elimination.EliminationUtils;
import fr.gouv.vitam.worker.core.plugin.purge.PurgeDeleteService;
import fr.gouv.vitam.worker.core.plugin.purge.PurgeReportService;
import fr.gouv.vitam.worker.core.plugin.purge.PurgeUnitStatus;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.SetUtils;

public class PurgeUnitPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PurgeUnitPlugin.class);
    private static final String UNIT_DELETION_ABORT = "UNIT_DELETION_ABORT";
    private static final String REPORT_PERSISTENT_IDENTIFIER_FIELD = "PersistentIdentifier";
    public static final String ARCHIVAL_AGENCY_IDENTIFIER = "#archivalAgencyIdentifier";
    private final String actionId;
    private final PurgeDeleteService purgeDeleteService;
    private final MetaDataClientFactory metaDataClientFactory;
    private final PurgeReportService purgeReportService;
    private final LogbookLifeCyclesClientFactory lfcClientFactory;

    public PurgeUnitPlugin(String actionId) {
        this(actionId, new PurgeDeleteService(), MetaDataClientFactory.getInstance(), new PurgeReportService(), LogbookLifeCyclesClientFactory.getInstance());
    }

    @VisibleForTesting
    protected PurgeUnitPlugin(String actionId, PurgeDeleteService purgeDeleteService, MetaDataClientFactory metaDataClientFactory, PurgeReportService purgeReportService, LogbookLifeCyclesClientFactory llfcClientFactory) {
        this.actionId = actionId;
        this.purgeDeleteService = purgeDeleteService;
        this.metaDataClientFactory = metaDataClientFactory;
        this.purgeReportService = purgeReportService;
        this.lfcClientFactory = llfcClientFactory;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        throw new ProcessingException("No need to implements method");
    }

    public List<ItemStatus> executeList(WorkerParameters param, HandlerIO handler) {
        try {
            return this.processUnits(param.getContainerName(), param);
        }
        catch (ProcessingStatusException e) {
            LOGGER.error("Unit purge failed with status " + e.getStatusCode(), (Throwable)e);
            return Collections.singletonList(PluginHelper.buildItemStatus(this.actionId, e.getStatusCode(), e.getEventDetails()));
        }
    }

    private List<ItemStatus> processUnits(String processId, WorkerParameters param) throws ProcessingStatusException {
        List units = param.getObjectMetadataList();
        List unitIds = units.stream().map(unit -> unit.get(VitamFieldsHelper.id()).asText()).collect(Collectors.toList());
        Map<String, JsonNode> unitsById = units.stream().collect(Collectors.toMap(unit -> unit.get(VitamFieldsHelper.id()).asText(), unit -> unit));
        ArrayList<ItemStatus> itemStatuses = new ArrayList<ItemStatus>();
        ArrayList<PurgeUnitReportEntry> purgeUnitReportEntries = new ArrayList<PurgeUnitReportEntry>();
        Set<String> unitsToDelete = this.getUnitsToDelete(unitsById.keySet());
        Map<String, String> unitIdsWithStrategiesToDelete = unitsById.entrySet().stream().filter(e -> unitsToDelete.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, entry -> MetadataDocumentHelper.getStrategyIdFromUnit((JsonNode)((JsonNode)entry.getValue()))));
        for (String unitId : unitIds) {
            PurgeUnitStatus purgeUnitStatus;
            if (unitsToDelete.contains(unitId)) {
                LOGGER.info("Unit " + unitId + " will be deleted");
                purgeUnitStatus = PurgeUnitStatus.DELETED;
                itemStatuses.add(PluginHelper.buildItemStatus(this.actionId, StatusCode.OK, null));
            } else {
                String msg = "Unit cannot be deleted because it has child units attached to it.";
                LOGGER.info(unitId + " " + msg);
                purgeUnitStatus = PurgeUnitStatus.NON_DESTROYABLE_HAS_CHILD_UNITS;
                itemStatuses.add(PluginHelper.buildItemStatus(this.actionId, StatusCode.WARNING, PluginHelper.EventDetails.of(msg)));
                if ("TRANSFER_REPLY_DELETE_UNIT".equals(this.actionId)) {
                    try {
                        this.writeLfcForUnpurgedUnit(this.lfcClientFactory.getClient(), param, unitId);
                    }
                    catch (InvalidGuidOperationException | LogbookClientBadRequestException | LogbookClientNotFoundException | LogbookClientServerException e2) {
                        LOGGER.error(e2);
                    }
                }
            }
            PurgeUnitReportEntry reportEntry = PurgeUnitPlugin.createReportEntry(unitsById, unitId, purgeUnitStatus, this.actionId);
            purgeUnitReportEntries.add(reportEntry);
        }
        this.purgeReportService.appendUnitEntries(processId, purgeUnitReportEntries);
        try {
            this.purgeDeleteService.deleteUnits(unitIdsWithStrategiesToDelete);
        }
        catch (LogbookClientBadRequestException | LogbookClientServerException | MetaDataClientServerException | MetaDataExecutionException | StorageServerClientException e3) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not delete units [" + String.join((CharSequence)", ", unitsToDelete) + "]", e3);
        }
        return itemStatuses;
    }

    private static PurgeUnitReportEntry createReportEntry(Map<String, JsonNode> unitsById, String unitId, PurgeUnitStatus purgeUnitStatus, String actionId) {
        JsonNode unit = unitsById.get(unitId);
        String initialOperation = unit.get(VitamFieldsHelper.initialOperation()).asText();
        String objectGroupId = unit.has(VitamFieldsHelper.object()) ? unit.get(VitamFieldsHelper.object()).asText() : null;
        String originatingAgency = unit.has(VitamFieldsHelper.originatingAgency()) ? unit.get(VitamFieldsHelper.originatingAgency()).asText() : null;
        String unitType = unit.has(VitamFieldsHelper.unitType()) ? unit.get(VitamFieldsHelper.unitType()).asText() : null;
        String archivalAgencyIdentifier = null;
        if ("TRANSFER_REPLY_DELETE_UNIT".equals(actionId)) {
            String string = archivalAgencyIdentifier = unit.has(ARCHIVAL_AGENCY_IDENTIFIER) ? unit.get(ARCHIVAL_AGENCY_IDENTIFIER).asText() : null;
        }
        if (purgeUnitStatus.equals((Object)PurgeUnitStatus.DELETED)) {
            List<PersistentIdentifierModel> persistentIdentifier = PurgeUnitPlugin.extractPersistentIdentifiersFromUnit(unit);
            JsonNode extraInfo = PurgeUnitPlugin.extractExtraInfoFromUnit(unit);
            return new PurgeUnitReportEntry(unitId, originatingAgency, initialOperation, objectGroupId, purgeUnitStatus.name(), archivalAgencyIdentifier, extraInfo, persistentIdentifier, unitType);
        }
        return new PurgeUnitReportEntry(unitId, originatingAgency, initialOperation, objectGroupId, purgeUnitStatus.name(), archivalAgencyIdentifier, null, null, unitType);
    }

    @VisibleForTesting
    protected static List<PersistentIdentifierModel> extractPersistentIdentifiersFromUnit(JsonNode unit) {
        ArrayList<PersistentIdentifierModel> persistentIdentifiers = null;
        JsonNode persistentIdentifierArray = unit.get(REPORT_PERSISTENT_IDENTIFIER_FIELD);
        if (persistentIdentifierArray != null && persistentIdentifierArray.isArray() && !persistentIdentifierArray.isEmpty()) {
            persistentIdentifiers = new ArrayList<PersistentIdentifierModel>();
            for (JsonNode identifierNode : persistentIdentifierArray) {
                PersistentIdentifierModel identifierModel = PurgeUnitPlugin.mapJsonToPersistentIdentifierModel(identifierNode);
                persistentIdentifiers.add(identifierModel);
            }
        }
        return persistentIdentifiers;
    }

    @VisibleForTesting
    protected static PersistentIdentifierModel mapJsonToPersistentIdentifierModel(JsonNode identifierNode) {
        ObjectMapper objectMapper = new ObjectMapper();
        return (PersistentIdentifierModel)objectMapper.convertValue((Object)identifierNode, PersistentIdentifierModel.class);
    }

    private static JsonNode extractExtraInfoFromUnit(JsonNode unit) {
        ObjectNode extraInfo = JsonHandler.createObjectNode();
        for (String metadataKey : EliminationUtils.getReportExtraFields()) {
            if (!unit.has(metadataKey)) continue;
            extraInfo.set(metadataKey, unit.get(metadataKey));
        }
        return extraInfo;
    }

    private Set<String> getUnitsToDelete(Set<String> unitIds) throws ProcessingStatusException {
        Set<String> unitsWithChildren = this.getUnitsWithChildren(unitIds);
        return SetUtils.difference(unitIds, unitsWithChildren);
    }

    private Set<String> getUnitsWithChildren(Set<String> unitIds) throws ProcessingStatusException {
        HashSet<String> hashSet;
        block9: {
            MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();
            try {
                HashSet<String> unitsToFetch = new HashSet<String>(unitIds);
                HashSet<String> result = new HashSet<String>();
                while (!unitsToFetch.isEmpty()) {
                    RequestResponseOK<JsonNode> responseOK = this.selectChildUnits(metaDataClient, unitsToFetch);
                    Set<String> unitsWithChildren = this.parseUnitsWithChildren(responseOK.getResults(), unitsToFetch);
                    result.addAll(unitsWithChildren);
                    unitsToFetch.removeAll(unitsWithChildren);
                    if (!this.noMoreResults(responseOK)) continue;
                    break;
                }
                hashSet = result;
                if (metaDataClient == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (metaDataClient != null) {
                        try {
                            metaDataClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidCreateOperationException | InvalidParseOperationException | MetaDataClientServerException | MetaDataDocumentSizeException | MetaDataExecutionException e) {
                    throw new ProcessingStatusException(StatusCode.FATAL, "Could not check child units", e);
                }
            }
            metaDataClient.close();
        }
        return hashSet;
    }

    private RequestResponseOK<JsonNode> selectChildUnits(MetaDataClient metaDataClient, Set<String> unitsToFetch) throws InvalidCreateOperationException, InvalidParseOperationException, MetaDataExecutionException, MetaDataDocumentSizeException, MetaDataClientServerException {
        SelectMultiQuery selectAllUnitsUp = new SelectMultiQuery();
        selectAllUnitsUp.addQueries(new Query[]{QueryHelper.in((String)VitamFieldsHelper.unitups(), (String[])unitsToFetch.toArray(new String[0]))});
        selectAllUnitsUp.setLimitFilter(0L, (long)VitamConfiguration.getBatchSize());
        selectAllUnitsUp.addUsedProjection(new String[]{VitamFieldsHelper.unitups()});
        JsonNode response = metaDataClient.selectUnits((JsonNode)selectAllUnitsUp.getFinalSelect());
        return RequestResponseOK.getFromJsonNode((JsonNode)response);
    }

    private Set<String> parseUnitsWithChildren(List<JsonNode> results, Set<String> unitsToFetch) {
        HashSet<String> foundUnitIds = new HashSet<String>();
        for (JsonNode childUnit : results) {
            childUnit.get(VitamFieldsHelper.unitups()).elements().forEachRemaining(jsonNode -> {
                String unitId = jsonNode.asText();
                if (unitsToFetch.contains(unitId)) {
                    foundUnitIds.add(unitId);
                }
            });
        }
        return foundUnitIds;
    }

    private void writeLfcForUnpurgedUnit(LogbookLifeCyclesClient lfcClient, WorkerParameters param, String unitId) throws InvalidGuidOperationException, LogbookClientNotFoundException, LogbookClientBadRequestException, LogbookClientServerException {
        LogbookLifeCycleUnitParameters logbookLfcParam = LogbookParameterHelper.newLogbookLifeCycleUnitParameters((GUID)GUIDFactory.newEventGUID((int)ParameterHelper.getTenantParameter()), (String)VitamLogbookMessages.getEventTypeLfc((String)UNIT_DELETION_ABORT), (GUID)GUIDReader.getGUID((String)param.getContainerName()), (LogbookTypeProcess)param.getLogbookTypeProcess(), (StatusCode)StatusCode.OK, (String)VitamLogbookMessages.getOutcomeDetailLfc((String)UNIT_DELETION_ABORT, (StatusCode)StatusCode.OK), (String)VitamLogbookMessages.getCodeLfc((String)UNIT_DELETION_ABORT, (StatusCode)StatusCode.OK), (GUID)GUIDReader.getGUID((String)unitId));
        lfcClient.update((LogbookLifeCycleParameters)logbookLfcParam, LifeCycleStatusCode.LIFE_CYCLE_COMMITTED);
    }

    private boolean noMoreResults(RequestResponseOK<JsonNode> responseOK) {
        return responseOK.getHits().getTotal() < (long)VitamConfiguration.getBatchSize();
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }
}

