/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.purge;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.batch.report.client.BatchReportClient;
import fr.gouv.vitam.batch.report.client.BatchReportClientFactory;
import fr.gouv.vitam.batch.report.model.ReportBody;
import fr.gouv.vitam.batch.report.model.ReportExportRequest;
import fr.gouv.vitam.batch.report.model.ReportType;
import fr.gouv.vitam.batch.report.model.entry.PurgeObjectGroupReportEntry;
import fr.gouv.vitam.batch.report.model.entry.PurgeUnitReportEntry;
import fr.gouv.vitam.common.collection.CloseableIterator;
import fr.gouv.vitam.common.collection.CloseableIteratorUtils;
import fr.gouv.vitam.common.exception.VitamClientInternalException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.stream.VitamAsyncInputStream;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.distribution.JsonLineGenericIterator;
import fr.gouv.vitam.worker.core.distribution.JsonLineModel;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;

public class PurgeReportService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PurgeReportService.class);
    static final String OBJECT_GROUP_REPORT_JSONL = "objectGroupReport.jsonl";
    static final String DISTINCT_REPORT_JSONL = "unitObjectGroups.jsonl";
    static final String ACCESSION_REGISTER_REPORT_JSONL = "accession_register.jsonl";
    private static final TypeReference<JsonLineModel> JSON_LINE_MODEL_TYPE_REFERENCE = new TypeReference<JsonLineModel>(){};
    private final BatchReportClientFactory batchReportClientFactory;
    private final WorkspaceClientFactory workspaceClientFactory;

    public PurgeReportService() {
        this(BatchReportClientFactory.getInstance(), WorkspaceClientFactory.getInstance((WorkspaceType)WorkspaceType.VITAM));
    }

    @VisibleForTesting
    PurgeReportService(BatchReportClientFactory batchReportClientFactory, WorkspaceClientFactory workspaceClientFactory) {
        this.batchReportClientFactory = batchReportClientFactory;
        this.workspaceClientFactory = workspaceClientFactory;
    }

    public void appendUnitEntries(String processId, List<PurgeUnitReportEntry> entries) throws ProcessingStatusException {
        this.appendEntries(processId, entries, ReportType.PURGE_UNIT);
    }

    public void appendObjectGroupEntries(String processId, List<PurgeObjectGroupReportEntry> entries) throws ProcessingStatusException {
        this.appendEntries(processId, entries, ReportType.PURGE_OBJECTGROUP);
    }

    private <T> void appendEntries(String processId, List<T> entries, ReportType reportType) throws ProcessingStatusException {
        try (BatchReportClient batchReportClient = this.batchReportClientFactory.getClient();){
            ReportBody reportBody = new ReportBody();
            reportBody.setProcessId(processId);
            reportBody.setReportType(reportType);
            reportBody.setEntries(entries);
            batchReportClient.appendReportEntries(reportBody);
        }
        catch (VitamClientInternalException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not append entries into report", e);
        }
    }

    public CloseableIterator<String> exportDistinctObjectGroups(HandlerIO handler, String processId) throws ProcessingStatusException {
        this.generateDistinctObjectGroupsToWorkspace(processId);
        File distinctObjectGroupsReportFile = handler.getNewLocalFile(DISTINCT_REPORT_JSONL);
        try (WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();
             FileOutputStream os = new FileOutputStream(distinctObjectGroupsReportFile);){
            Response reportResponse = workspaceClient.getObject(processId, DISTINCT_REPORT_JSONL);
            IOUtils.copy((InputStream)new VitamAsyncInputStream(reportResponse), (OutputStream)os);
        }
        catch (ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException | IOException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not load report from workspace", e);
        }
        try {
            JsonLineGenericIterator jsonLineIterator = new JsonLineGenericIterator((InputStream)new FileInputStream(distinctObjectGroupsReportFile), JSON_LINE_MODEL_TYPE_REFERENCE);
            return CloseableIteratorUtils.map((CloseableIterator)jsonLineIterator, JsonLineModel::getId);
        }
        catch (IOException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not load local report file", e);
        }
    }

    private void generateDistinctObjectGroupsToWorkspace(String processId) throws ProcessingStatusException {
        if (this.isReportAlreadyExisting(processId, DISTINCT_REPORT_JSONL)) {
            LOGGER.info("unitObjectGroups.jsonl report already exists. No need for regeneration (idempotency)");
            return;
        }
        try (BatchReportClient batchReportClient = this.batchReportClientFactory.getClient();){
            batchReportClient.generatePurgeDistinctObjectGroupInUnitReport(processId, new ReportExportRequest(DISTINCT_REPORT_JSONL));
        }
        catch (VitamClientInternalException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not generate distinct object group report for deleted units to workspace", e);
        }
    }

    public void exportAccessionRegisters(String processId) throws ProcessingStatusException {
        if (this.isReportAlreadyExisting(processId, ACCESSION_REGISTER_REPORT_JSONL)) {
            LOGGER.info("accession_register.jsonl report already exists. No need for regeneration (idempotency)");
            return;
        }
        try (BatchReportClient batchReportClient = this.batchReportClientFactory.getClient();){
            batchReportClient.generatePurgeAccessionRegisterReport(processId, new ReportExportRequest(ACCESSION_REGISTER_REPORT_JSONL));
        }
        catch (VitamClientInternalException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not generate purge accession register reports (" + processId + ")", e);
        }
    }

    public void cleanupReport(String processId) throws ProcessingStatusException {
        try (BatchReportClient batchReportClient = this.batchReportClientFactory.getClient();){
            batchReportClient.cleanupReport(processId, ReportType.PURGE_UNIT);
            batchReportClient.cleanupReport(processId, ReportType.PURGE_OBJECTGROUP);
        }
        catch (VitamClientInternalException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not cleanup purge reports (" + processId + ")", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isReportAlreadyExisting(String processId, String reportFileName) throws ProcessingStatusException {
        try (WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();){
            if (!workspaceClient.isExistingObject(processId, reportFileName)) return false;
            boolean bl = true;
            return bl;
        }
        catch (ContentAddressableStorageServerException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not check report existence in workspace", e);
        }
    }
}

