/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.purge;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import fr.gouv.vitam.batch.report.model.entry.PurgeObjectGroupObjectVersion;
import fr.gouv.vitam.batch.report.model.entry.PurgeObjectGroupReportEntry;
import fr.gouv.vitam.common.collection.CloseableIterator;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.objectgroup.ObjectGroupResponse;
import fr.gouv.vitam.metadata.api.exception.MetaDataClientServerException;
import fr.gouv.vitam.metadata.api.exception.MetaDataDocumentSizeException;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.distribution.JsonLineModel;
import fr.gouv.vitam.worker.core.distribution.JsonLineWriter;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.purge.PurgeObjectGroupParams;
import fr.gouv.vitam.worker.core.plugin.purge.PurgeObjectGroupStatus;
import fr.gouv.vitam.worker.core.plugin.purge.PurgeObjectParams;
import fr.gouv.vitam.worker.core.plugin.purge.PurgeReportService;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.SetUtils;

public class PurgeObjectGroupPreparationHandler
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PurgeObjectGroupPreparationHandler.class);
    static final String OBJECT_GROUPS_TO_DELETE_FILE = "object_groups_to_delete.jsonl";
    static final String OBJECT_GROUPS_TO_DETACH_FILE = "object_groups_to_detach.jsonl";
    private static final int MAX_ELASTIC_SEARCH_IN_REQUEST_SIZE = 1000;
    private static final int DEFAULT_OBJECT_GROUP_BULK_SIZE = 1000;
    public static final String ARCHIVAL_AGENCY_IDENTIFIER = "archivalAgencyIdentifier";
    private final String actionId;
    private final MetaDataClientFactory metaDataClientFactory;
    private final PurgeReportService purgeReportService;
    private final int objectGroupBulkSize;

    public PurgeObjectGroupPreparationHandler(String actionId) {
        this(actionId, MetaDataClientFactory.getInstance(), new PurgeReportService(), 1000);
    }

    @VisibleForTesting
    protected PurgeObjectGroupPreparationHandler(String actionId, MetaDataClientFactory metaDataClientFactory, PurgeReportService purgeReportService, int objectGroupBulkSize) {
        this.actionId = actionId;
        this.metaDataClientFactory = metaDataClientFactory;
        this.purgeReportService = purgeReportService;
        this.objectGroupBulkSize = objectGroupBulkSize;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        try {
            JsonNode context = this.retrieveTransferReplyContext(handler);
            String archivalAgencyIdentifier = null;
            if (!context.isNull()) {
                archivalAgencyIdentifier = context.get(ARCHIVAL_AGENCY_IDENTIFIER).asText();
            }
            File objectGroupsToDeleteFile = handler.getNewLocalFile(OBJECT_GROUPS_TO_DELETE_FILE);
            File objectGroupsToDetachFile = handler.getNewLocalFile(OBJECT_GROUPS_TO_DETACH_FILE);
            try (FileOutputStream objectGroupsToDeleteStream = new FileOutputStream(objectGroupsToDeleteFile);
                 FileOutputStream objectGroupsToDetachStream = new FileOutputStream(objectGroupsToDetachFile);
                 JsonLineWriter objectGroupsToDeleteWriter = new JsonLineWriter((OutputStream)objectGroupsToDeleteStream);
                 JsonLineWriter objectGroupsToDetachWriter = new JsonLineWriter((OutputStream)objectGroupsToDetachStream);
                 CloseableIterator<String> iterator = this.purgeReportService.exportDistinctObjectGroups(handler, param.getContainerName());){
                UnmodifiableIterator bulkIterator = Iterators.partition(iterator, (int)this.objectGroupBulkSize);
                while (bulkIterator.hasNext()) {
                    List objectGroupIds = (List)bulkIterator.next();
                    this.process(new HashSet<String>(objectGroupIds), archivalAgencyIdentifier, objectGroupsToDeleteWriter, objectGroupsToDetachWriter, param.getContainerName());
                }
            }
            catch (InvalidParseOperationException | IOException e) {
                throw new ProcessingStatusException(StatusCode.FATAL, "Could not generate object group distribution", e);
            }
            handler.transferFileToWorkspace(OBJECT_GROUPS_TO_DELETE_FILE, objectGroupsToDeleteFile, true, false);
            handler.transferFileToWorkspace(OBJECT_GROUPS_TO_DETACH_FILE, objectGroupsToDetachFile, true, false);
            LOGGER.info("Purge of object group preparation succeeded");
            return PluginHelper.buildItemStatus(this.actionId, StatusCode.OK, null);
        }
        catch (ProcessingStatusException e) {
            LOGGER.error(String.format("Purge of object group preparation failed with status [%s]", e.getStatusCode()), (Throwable)e);
            return PluginHelper.buildItemStatus(this.actionId, e.getStatusCode(), e.getEventDetails());
        }
    }

    private void process(Set<String> objectGroupIds, String archivalAgencyIdentifier, JsonLineWriter objectGroupsToDeleteWriter, JsonLineWriter objectGroupsToDetachWriter, String processId) throws ProcessingStatusException, IOException, InvalidParseOperationException {
        Map<String, ObjectGroupResponse> objectGroups = this.loadObjectGroups(objectGroupIds);
        Set<String> foundObjectGroupIds = objectGroups.keySet();
        SetUtils.SetView notFoundUnitIds = SetUtils.difference(objectGroupIds, foundObjectGroupIds);
        for (Object objectGroupId : notFoundUnitIds) {
            LOGGER.warn("Object group " + (String)objectGroupId + " not found. Skipped");
        }
        HashSet<String> parentUnitIds = new HashSet<String>();
        for (ObjectGroupResponse objectGroup : objectGroups.values()) {
            parentUnitIds.addAll(objectGroup.getUp());
        }
        Set<String> existingParentUnits = this.getExistingParentUnits(parentUnitIds);
        ArrayList<PurgeObjectGroupReportEntry> purgeObjectGroupReportEntries = new ArrayList<PurgeObjectGroupReportEntry>();
        for (ObjectGroupResponse objectGroup : objectGroups.values()) {
            HashSet objectGroupParentUnits = new HashSet(objectGroup.getUp());
            SetUtils.SetView removedParentUnits = SetUtils.difference(objectGroupParentUnits, existingParentUnits);
            if (removedParentUnits.size() == objectGroupParentUnits.size()) {
                LOGGER.debug("Object group " + objectGroup.getId() + " will be deleted");
                PurgeObjectGroupParams params = PurgeObjectGroupParams.fromObjectGroup(objectGroup);
                objectGroupsToDeleteWriter.addEntry(new JsonLineModel(objectGroup.getId(), null, JsonHandler.toJsonNode((Object)params)));
                Set objectIds = params.getObjects().stream().map(PurgeObjectParams::getId).collect(Collectors.toSet());
                List<PurgeObjectGroupObjectVersion> objectVersions = this.getObjectVersions(objectGroup);
                purgeObjectGroupReportEntries.add(new PurgeObjectGroupReportEntry(objectGroup.getId(), objectGroup.getOriginatingAgency(), objectGroup.getOpi(), null, objectIds, PurgeObjectGroupStatus.DELETED.name(), archivalAgencyIdentifier, objectVersions));
                continue;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Object group " + objectGroup.getId() + " detached from deleted parents " + String.join((CharSequence)", ", (Iterable<? extends CharSequence>)removedParentUnits));
            }
            JsonLineModel entry = new JsonLineModel(objectGroup.getId(), null, JsonHandler.toJsonNode((Object)removedParentUnits));
            objectGroupsToDetachWriter.addEntry(entry);
            purgeObjectGroupReportEntries.add(new PurgeObjectGroupReportEntry(objectGroup.getId(), objectGroup.getOriginatingAgency(), objectGroup.getOpi(), (Set)removedParentUnits, null, PurgeObjectGroupStatus.PARTIAL_DETACHMENT.name(), archivalAgencyIdentifier, null));
        }
        this.purgeReportService.appendObjectGroupEntries(processId, purgeObjectGroupReportEntries);
    }

    private List<PurgeObjectGroupObjectVersion> getObjectVersions(ObjectGroupResponse objectGroup) {
        return ListUtils.emptyIfNull((List)objectGroup.getQualifiers()).stream().flatMap(qualifier -> ListUtils.emptyIfNull((List)qualifier.getVersions()).stream()).map(version -> new PurgeObjectGroupObjectVersion(version.getId(), version.getOpi(), Long.valueOf(version.getSize()), version.getDataObjectVersion(), version.getDataObjectUse(), version.getPersistentIdentifier())).collect(Collectors.toList());
    }

    private Map<String, ObjectGroupResponse> loadObjectGroups(Set<String> objectGroupIds) throws ProcessingStatusException {
        HashMap<String, ObjectGroupResponse> hashMap;
        block10: {
            MetaDataClient client = this.metaDataClientFactory.getClient();
            try {
                HashMap<String, ObjectGroupResponse> objectGroups = new HashMap<String, ObjectGroupResponse>();
                for (List ids : ListUtils.partition(new ArrayList<String>(objectGroupIds), (int)1000)) {
                    SelectMultiQuery selectMultiQuery = new SelectMultiQuery();
                    selectMultiQuery.addRoots(ids.toArray(new String[0]));
                    JsonNode jsonNode = client.selectObjectGroups((JsonNode)selectMultiQuery.getFinalSelect());
                    RequestResponseOK requestResponseOK = RequestResponseOK.getFromJsonNode((JsonNode)jsonNode);
                    for (JsonNode objectGroupJson : requestResponseOK.getResults()) {
                        ObjectGroupResponse objectGroup = (ObjectGroupResponse)JsonHandler.getFromJsonNode((JsonNode)objectGroupJson, ObjectGroupResponse.class);
                        objectGroups.put(objectGroup.getId(), objectGroup);
                    }
                }
                hashMap = objectGroups;
                if (client == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException | MetaDataClientServerException | MetaDataDocumentSizeException | MetaDataExecutionException e) {
                    throw new ProcessingStatusException(StatusCode.FATAL, "Could not load object groups", e);
                }
            }
            client.close();
        }
        return hashMap;
    }

    private Set<String> getExistingParentUnits(Set<String> parentUnitIds) throws ProcessingStatusException {
        HashSet<String> hashSet;
        block10: {
            MetaDataClient client = this.metaDataClientFactory.getClient();
            try {
                HashSet<String> foundUnitIds = new HashSet<String>();
                for (List ids : ListUtils.partition(new ArrayList<String>(parentUnitIds), (int)1000)) {
                    SelectMultiQuery selectMultiQuery = new SelectMultiQuery();
                    selectMultiQuery.addRoots(ids.toArray(new String[0]));
                    selectMultiQuery.addUsedProjection(new String[]{VitamFieldsHelper.id()});
                    JsonNode jsonNode = client.selectUnits((JsonNode)selectMultiQuery.getFinalSelect());
                    RequestResponseOK requestResponseOK = RequestResponseOK.getFromJsonNode((JsonNode)jsonNode);
                    for (JsonNode unit : requestResponseOK.getResults()) {
                        foundUnitIds.add(unit.get(VitamFieldsHelper.id()).asText());
                    }
                }
                hashSet = foundUnitIds;
                if (client == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException | MetaDataClientServerException | MetaDataDocumentSizeException | MetaDataExecutionException e) {
                    throw new ProcessingStatusException(StatusCode.FATAL, "Could not load object group parent units", e);
                }
            }
            client.close();
        }
        return hashSet;
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }

    public JsonNode retrieveTransferReplyContext(HandlerIO handler) throws ProcessingStatusException {
        return JsonHandler.createNullNode();
    }
}

