/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.purge;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.purge.PurgeDeleteService;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.util.Set;

public class PurgeDetachObjectGroupPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PurgeDetachObjectGroupPlugin.class);
    private static final TypeReference<Set<String>> STRING_SET_TYPE_REFERENCE = new TypeReference<Set<String>>(){};
    private final String actionId;
    private final PurgeDeleteService purgeDeleteService;

    public PurgeDetachObjectGroupPlugin(String actionId) {
        this(actionId, new PurgeDeleteService());
    }

    @VisibleForTesting
    protected PurgeDetachObjectGroupPlugin(String actionId, PurgeDeleteService purgeDeleteService) {
        this.actionId = actionId;
        this.purgeDeleteService = purgeDeleteService;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        String objectGroupId = param.getObjectName();
        try {
            Set<String> parentUnitsToRemove = this.getParentUnitsToRemove(param);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Detaching deleted parents [" + String.join((CharSequence)", ", parentUnitsToRemove) + "] from object group " + objectGroupId);
            }
            this.purgeDeleteService.detachObjectGroupFromDeleteParentUnits(objectGroupId, parentUnitsToRemove);
            LOGGER.info("Object group " + objectGroupId + " detachment from parents succeeded");
            return PluginHelper.buildItemStatus(this.actionId, StatusCode.OK, null);
        }
        catch (ProcessingStatusException e) {
            LOGGER.error("Object group " + objectGroupId + " detachment from parents failed with status [" + e.getStatusCode() + "]", (Throwable)e);
            return PluginHelper.buildItemStatus(this.actionId, e.getStatusCode(), e.getEventDetails());
        }
    }

    private Set<String> getParentUnitsToRemove(WorkerParameters params) throws ProcessingStatusException {
        try {
            return (Set)JsonHandler.getFromJsonNode((JsonNode)params.getObjectMetadata(), STRING_SET_TYPE_REFERENCE);
        }
        catch (Exception e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not retrieve parent units to detach", e);
        }
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }
}

