/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.purge;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.query.action.Action;
import fr.gouv.vitam.common.database.builder.query.action.UpdateActionHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.UpdateMultiQuery;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.logbook.common.exception.LogbookClientBadRequestException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientServerException;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClient;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClientFactory;
import fr.gouv.vitam.metadata.api.exception.MetaDataClientServerException;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.client.MetaDataClient;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import java.util.Map;
import java.util.Set;

public class PurgeDeleteService {
    private final StorageClientFactory storageClientFactory;
    private final MetaDataClientFactory metaDataClientFactory;
    private final LogbookLifeCyclesClientFactory logbookLifeCyclesClientFactory;

    @VisibleForTesting
    PurgeDeleteService(StorageClientFactory storageClientFactory, MetaDataClientFactory metaDataClientFactory, LogbookLifeCyclesClientFactory logbookLifeCyclesClientFactory) {
        this.storageClientFactory = storageClientFactory;
        this.metaDataClientFactory = metaDataClientFactory;
        this.logbookLifeCyclesClientFactory = logbookLifeCyclesClientFactory;
    }

    public PurgeDeleteService() {
        this(StorageClientFactory.getInstance(), MetaDataClientFactory.getInstance(), LogbookLifeCyclesClientFactory.getInstance());
    }

    public void deleteObjects(Map<String, String> objectsGuidsWithStrategies) throws StorageServerClientException {
        this.storageDelete(objectsGuidsWithStrategies, DataCategory.OBJECT, "");
    }

    public void deleteObjectGroups(Map<String, String> objectGroupsGuidsWithStrategies) throws InvalidParseOperationException, MetaDataExecutionException, MetaDataClientServerException, StorageServerClientException, LogbookClientBadRequestException, LogbookClientServerException {
        try (LogbookLifeCyclesClient logbookLifeCyclesClient = this.logbookLifeCyclesClientFactory.getClient();){
            logbookLifeCyclesClient.deleteLifecycleObjectGroupBulk(objectGroupsGuidsWithStrategies.keySet());
        }
        try (MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();){
            metaDataClient.deleteObjectGroupBulk(objectGroupsGuidsWithStrategies.keySet());
        }
        this.storageDelete(objectGroupsGuidsWithStrategies, DataCategory.OBJECTGROUP, ".json");
    }

    public void deleteUnits(Map<String, String> unitsGuidsWithStrategies) throws MetaDataExecutionException, MetaDataClientServerException, StorageServerClientException, LogbookClientBadRequestException, LogbookClientServerException {
        try (LogbookLifeCyclesClient logbookLifeCyclesClient = this.logbookLifeCyclesClientFactory.getClient();){
            logbookLifeCyclesClient.deleteLifecycleUnitsBulk(unitsGuidsWithStrategies.keySet());
        }
        try (MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();){
            metaDataClient.deleteUnitsBulk(unitsGuidsWithStrategies.keySet());
        }
        this.storageDelete(unitsGuidsWithStrategies, DataCategory.UNIT, ".json");
    }

    private void storageDelete(Map<String, String> idsWithStrategies, DataCategory dataCategory, String fileExtension) throws StorageServerClientException {
        try (StorageClient storageClient = this.storageClientFactory.getClient();){
            for (Map.Entry<String, String> idWithStrategy : idsWithStrategies.entrySet()) {
                storageClient.delete(idWithStrategy.getValue(), dataCategory, idWithStrategy.getKey() + fileExtension);
            }
        }
    }

    public void detachObjectGroupFromDeleteParentUnits(String objectGroupId, Set<String> parentUnitsToRemove) throws ProcessingStatusException {
        try (MetaDataClient metaDataClient = this.metaDataClientFactory.getClient();){
            UpdateMultiQuery updateMultiQuery = new UpdateMultiQuery();
            updateMultiQuery.addActions(new Action[]{UpdateActionHelper.pull((String)VitamFieldsHelper.unitups(), (String[])parentUnitsToRemove.toArray(new String[0])), UpdateActionHelper.add((String)VitamFieldsHelper.operations(), (String[])new String[]{VitamThreadUtils.getVitamSession().getRequestId()})});
            metaDataClient.updateObjectGroupById((JsonNode)updateMultiQuery.getFinalUpdate(), objectGroupId);
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException | MetaDataClientServerException | MetaDataExecutionException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "An error occurred during object group detachment", e);
        }
    }
}

