/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.purge;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.logbook.common.exception.LogbookClientBadRequestException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientServerException;
import fr.gouv.vitam.metadata.api.exception.MetaDataClientServerException;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.purge.PurgeDeleteService;
import fr.gouv.vitam.worker.core.plugin.purge.PurgeObjectGroupParams;
import fr.gouv.vitam.worker.core.plugin.purge.PurgeObjectParams;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PurgeDeleteObjectGroupPlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PurgeDeleteObjectGroupPlugin.class);
    private final String actionId;
    private final PurgeDeleteService purgeDeleteService;

    public PurgeDeleteObjectGroupPlugin(String actionId) {
        this(actionId, new PurgeDeleteService());
    }

    @VisibleForTesting
    protected PurgeDeleteObjectGroupPlugin(String actionId, PurgeDeleteService purgeDeleteService) {
        this.actionId = actionId;
        this.purgeDeleteService = purgeDeleteService;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        throw new ProcessingException("No need to implements method");
    }

    public List<ItemStatus> executeList(WorkerParameters param, HandlerIO handler) {
        try {
            List objectGroupParams = param.getObjectMetadataList().stream().map(og -> {
                try {
                    return (PurgeObjectGroupParams)JsonHandler.getFromJsonNode((JsonNode)og, PurgeObjectGroupParams.class);
                }
                catch (InvalidParseOperationException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
            Map<String, String> objectGroupIdsWithStrategies = objectGroupParams.stream().collect(Collectors.toMap(PurgeObjectGroupParams::getId, PurgeObjectGroupParams::getStrategyId));
            this.processObjectGroups(objectGroupIdsWithStrategies);
            Map<String, String> objectIdsWithStrategies = objectGroupParams.stream().flatMap(objectGroup -> objectGroup.getObjects().stream()).collect(Collectors.toMap(PurgeObjectParams::getId, PurgeObjectParams::getStrategyId));
            this.processObjects(objectIdsWithStrategies);
            return PluginHelper.buildBulkItemStatus(param, this.actionId, StatusCode.OK);
        }
        catch (ProcessingStatusException e) {
            LOGGER.error("Purge of object groups failed with status " + e.getStatusCode(), (Throwable)e);
            return Collections.singletonList(PluginHelper.buildItemStatus(this.actionId, e.getStatusCode(), e.getEventDetails()));
        }
    }

    private void processObjectGroups(Map<String, String> objectGroupIdsWithStrategies) throws ProcessingStatusException {
        LOGGER.info("Deleting object groups [" + String.join((CharSequence)", ", objectGroupIdsWithStrategies.keySet()) + "]");
        try {
            this.purgeDeleteService.deleteObjectGroups(objectGroupIdsWithStrategies);
        }
        catch (InvalidParseOperationException | LogbookClientBadRequestException | LogbookClientServerException | MetaDataClientServerException | MetaDataExecutionException | StorageServerClientException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not delete object groups [" + String.join((CharSequence)", ", objectGroupIdsWithStrategies.keySet()) + "]", e);
        }
    }

    private void processObjects(Map<String, String> objectIdsWithStrategies) throws ProcessingStatusException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Deleting object binaries [" + String.join((CharSequence)", ", objectIdsWithStrategies.keySet()) + "]");
        }
        try {
            this.purgeDeleteService.deleteObjects(objectIdsWithStrategies);
        }
        catch (StorageServerClientException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not delete object groups [" + String.join((CharSequence)", ", objectIdsWithStrategies.keySet()) + "]", e);
        }
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }
}

