/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.purge;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.batch.report.model.PurgeAccessionRegisterModel;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.metrics.VitamCommonMetrics;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.administration.AccessionRegisterDetailModel;
import fr.gouv.vitam.common.model.administration.AccessionRegisterStatus;
import fr.gouv.vitam.common.model.administration.RegisterValueDetailModel;
import fr.gouv.vitam.common.model.administration.RegisterValueEventModel;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.client.AdminManagementClient;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.functional.administration.common.exception.AdminManagementClientServerException;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.utils.PluginHelper;
import io.prometheus.client.Counter;

public class PurgeAccessionRegisterUpdatePlugin
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PurgeAccessionRegisterUpdatePlugin.class);
    private final String actionId;
    private final LogbookTypeProcess logbookTypeProcess;
    private final AdminManagementClientFactory adminManagementClientFactory;

    public PurgeAccessionRegisterUpdatePlugin(String actionId, LogbookTypeProcess logbookTypeProcess) {
        this(actionId, logbookTypeProcess, AdminManagementClientFactory.getInstance());
    }

    @VisibleForTesting
    protected PurgeAccessionRegisterUpdatePlugin(String actionId, LogbookTypeProcess logbookTypeProcess, AdminManagementClientFactory adminManagementClientFactory) {
        this.actionId = actionId;
        this.logbookTypeProcess = logbookTypeProcess;
        this.adminManagementClientFactory = adminManagementClientFactory;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        try {
            this.updateAccessionRegister(param);
            LOGGER.info("Purge accession register update succeeded");
            return PluginHelper.buildItemStatus(this.actionId, StatusCode.OK, null);
        }
        catch (ProcessingStatusException e) {
            LOGGER.error(String.format("Purge accession register update failed with status [%s]", e.getStatusCode()), (Throwable)e);
            return PluginHelper.buildItemStatus(this.actionId, e.getStatusCode(), e.getEventDetails());
        }
    }

    private void updateAccessionRegister(WorkerParameters param) throws ProcessingStatusException {
        PurgeAccessionRegisterModel purgeAccessionRegisterModel = this.loadPurgeAccessionRegisterModel(param);
        try (AdminManagementClient adminManagementClient = this.adminManagementClientFactory.getClient();){
            RegisterValueEventModel registerValueEvent = new RegisterValueEventModel().setOperation(param.getContainerName()).setOperationType(this.logbookTypeProcess.name()).setTotalUnits(-1L * purgeAccessionRegisterModel.getTotalUnits()).setTotalGots(-1L * purgeAccessionRegisterModel.getTotalObjectGroups()).setTotalObjects(-1L * purgeAccessionRegisterModel.getTotalObjects()).setObjectSize(-1L * purgeAccessionRegisterModel.getTotalSize()).setCreationdate(LocalDateUtil.nowFormatted());
            RegisterValueDetailModel totalUnits = new RegisterValueDetailModel().setIngested(0L).setDeleted(purgeAccessionRegisterModel.getTotalUnits()).setRemained(-1L * purgeAccessionRegisterModel.getTotalUnits());
            RegisterValueDetailModel totalObjectsGroups = new RegisterValueDetailModel().setIngested(0L).setDeleted(purgeAccessionRegisterModel.getTotalObjectGroups()).setRemained(-1L * purgeAccessionRegisterModel.getTotalObjectGroups());
            RegisterValueDetailModel totalObjects = new RegisterValueDetailModel().setIngested(0L).setDeleted(purgeAccessionRegisterModel.getTotalObjects()).setRemained(-1L * purgeAccessionRegisterModel.getTotalObjects());
            RegisterValueDetailModel objectSize = new RegisterValueDetailModel().setIngested(0L).setDeleted(purgeAccessionRegisterModel.getTotalSize()).setRemained(-1L * purgeAccessionRegisterModel.getTotalSize());
            String updateDate = LocalDateUtil.nowFormatted();
            int tenantId = VitamThreadUtils.getVitamSession().getTenantId();
            GUID guid = GUIDFactory.newAccessionRegisterDetailGUID((int)tenantId);
            AccessionRegisterDetailModel accessionRegisterDetailModel = new AccessionRegisterDetailModel().setId(guid.toString()).setOpc(param.getContainerName()).setOriginatingAgency(purgeAccessionRegisterModel.getOriginatingAgency()).setTotalObjectsGroups(totalObjectsGroups).setTotalUnits(totalUnits).setTotalObjects(totalObjects).setObjectSize(objectSize).setOpi(purgeAccessionRegisterModel.getOpi()).setOperationType(this.logbookTypeProcess.name()).addEvent(registerValueEvent).addOperationsId(param.getContainerName()).setTenant(Integer.valueOf(tenantId)).setLastUpdate(updateDate).setStatus(AccessionRegisterStatus.STORED_AND_UPDATED);
            adminManagementClient.createOrUpdateAccessionRegister(accessionRegisterDetailModel);
        }
        catch (AdminManagementClientServerException e) {
            ((Counter.Child)VitamCommonMetrics.CONSISTENCY_ERROR_COUNTER.labels(new String[]{String.valueOf(ParameterHelper.getTenantParameter()), "AccessionRegister"})).inc();
            throw new ProcessingStatusException(StatusCode.FATAL, "[Consistency ERROR] An error occurred during accession register update", e);
        }
    }

    private PurgeAccessionRegisterModel loadPurgeAccessionRegisterModel(WorkerParameters param) throws ProcessingStatusException {
        try {
            return (PurgeAccessionRegisterModel)JsonHandler.getFromJsonNode((JsonNode)param.getObjectMetadata(), PurgeAccessionRegisterModel.class);
        }
        catch (InvalidParseOperationException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not load accession register data", e);
        }
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }
}

