/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.purge;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.purge.PurgeReportService;
import fr.gouv.vitam.worker.core.utils.PluginHelper;

public class PurgeAccessionRegisterPreparationHandler
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PurgeAccessionRegisterPreparationHandler.class);
    private final String actionId;
    private final PurgeReportService purgeReportService;

    public PurgeAccessionRegisterPreparationHandler(String actionId) {
        this(actionId, new PurgeReportService());
    }

    @VisibleForTesting
    protected PurgeAccessionRegisterPreparationHandler(String actionId, PurgeReportService purgeReportService) {
        this.actionId = actionId;
        this.purgeReportService = purgeReportService;
    }

    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        try {
            this.exportAccessionRegister(param.getContainerName());
            LOGGER.info("Purge accession register preparation succeeded");
            return PluginHelper.buildItemStatus(this.actionId, StatusCode.OK, null);
        }
        catch (ProcessingStatusException e) {
            LOGGER.error(String.format("Purge accession register preparation failed with status [%s]", e.getStatusCode()), (Throwable)e);
            return PluginHelper.buildItemStatus(this.actionId, e.getStatusCode(), e.getEventDetails());
        }
    }

    private void exportAccessionRegister(String processId) throws ProcessingStatusException {
        this.purgeReportService.exportAccessionRegisters(processId);
    }

    public void checkMandatoryIOParameter(HandlerIO handler) throws ProcessingException {
    }
}

