/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.probativevalue.pojo;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.worker.core.plugin.probativevalue.pojo.ChecksInformation;
import fr.gouv.vitam.worker.core.plugin.probativevalue.pojo.ProbativeCheck;
import fr.gouv.vitam.worker.core.plugin.probativevalue.pojo.ProbativeOperation;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ProbativeReportEntry {
    private final List<String> unitIds;
    private final String objectGroupId;
    private final String objectId;
    private final String usageVersion;
    private final List<ProbativeOperation> operations;
    private final List<ProbativeCheck> checks;
    private final String evStartDateTime;
    private final String evEndDateTime;
    private final StatusCode status;

    @JsonCreator
    public ProbativeReportEntry(@JsonProperty(value="unitIds") List<String> unitIds, @JsonProperty(value="objectGroupId") String objectGroupId, @JsonProperty(value="objectId") String objectId, @JsonProperty(value="usageVersion") String usageVersion, @JsonProperty(value="operations") List<ProbativeOperation> operations, @JsonProperty(value="checks") List<ProbativeCheck> checks, @JsonProperty(value="evStartDateTime") String evStartDateTime, @JsonProperty(value="evEndDateTime") String evEndDateTime, @JsonProperty(value="status") StatusCode status) {
        this.unitIds = unitIds;
        this.objectGroupId = objectGroupId;
        this.objectId = objectId;
        this.usageVersion = usageVersion;
        this.operations = operations;
        this.checks = checks;
        this.evStartDateTime = evStartDateTime;
        this.evEndDateTime = evEndDateTime;
        this.status = status;
    }

    public ProbativeReportEntry(String evStartDateTime, List<String> unitIds, String objectGroupId, String objectId, String usageVersion, List<ProbativeOperation> operations, List<ProbativeCheck> checks) {
        this.unitIds = unitIds;
        this.objectGroupId = objectGroupId;
        this.objectId = objectId;
        this.usageVersion = usageVersion;
        this.operations = operations;
        this.checks = checks;
        this.evStartDateTime = evStartDateTime;
        this.evEndDateTime = LocalDateUtil.nowFormatted();
        this.status = this.getStatus(operations, checks);
    }

    @JsonIgnore
    private StatusCode getStatus(List<ProbativeOperation> operations, List<ProbativeCheck> checks) {
        if (operations.stream().allMatch(Objects::nonNull) && operations.size() == 3 && checks.stream().allMatch(Objects::nonNull) && checks.stream().allMatch(c -> StatusCode.OK.equals((Object)c.getStatus())) && checks.size() == ChecksInformation.values().length) {
            return StatusCode.OK;
        }
        if (operations.stream().allMatch(Objects::nonNull) && operations.size() == 3 && checks.stream().allMatch(Objects::nonNull) && checks.stream().noneMatch(c -> StatusCode.KO.equals((Object)c.getStatus())) && checks.size() == ChecksInformation.values().length) {
            return StatusCode.WARNING;
        }
        return StatusCode.KO;
    }

    private ProbativeReportEntry(String evStartDateTime, List<String> unitIds, String objectGroupId, String objectId, String usageVersion) {
        this.unitIds = unitIds;
        this.objectGroupId = objectGroupId;
        this.objectId = objectId;
        this.usageVersion = usageVersion;
        this.operations = Collections.emptyList();
        this.checks = Collections.emptyList();
        this.evStartDateTime = evStartDateTime;
        this.evEndDateTime = LocalDateUtil.nowFormatted();
        this.status = StatusCode.KO;
    }

    @JsonIgnore
    public static ProbativeReportEntry koFrom(String evStartDateTime, List<String> unitIds, String objectGroupId, String objectId, String usageVersion) {
        return new ProbativeReportEntry(evStartDateTime, unitIds, objectGroupId, objectId, usageVersion);
    }

    @JsonIgnore
    public static ProbativeReportEntry koFrom(String startEntryCreation, List<String> unitIds, String objectGroupId, String objectId, String usageVersion, List<ProbativeOperation> probativeOperations) {
        return new ProbativeReportEntry(startEntryCreation, unitIds, objectGroupId, objectId, usageVersion, probativeOperations, Collections.emptyList());
    }

    @JsonIgnore
    public static ProbativeReportEntry koFrom(String startEntryCreation, List<String> unitIds, String objectGroupId, String objectId, String usageVersion, List<ProbativeOperation> probativeOperations, List<ProbativeCheck> probativeChecks) {
        return new ProbativeReportEntry(startEntryCreation, unitIds, objectGroupId, objectId, usageVersion, probativeOperations, probativeChecks);
    }

    @JsonProperty(value="unitIds")
    public List<String> getUnitIds() {
        return this.unitIds;
    }

    @JsonProperty(value="objectGroupId")
    public String getObjectGroupId() {
        return this.objectGroupId;
    }

    @JsonProperty(value="objectId")
    public String getObjectId() {
        return this.objectId;
    }

    @JsonProperty(value="usageVersion")
    public String getUsageVersion() {
        return this.usageVersion;
    }

    @JsonProperty(value="operations")
    public List<ProbativeOperation> getOperations() {
        return this.operations;
    }

    @JsonProperty(value="checks")
    public List<ProbativeCheck> getChecks() {
        return this.checks;
    }

    @JsonProperty(value="evStartDateTime")
    public String getEvStartDateTime() {
        return this.evStartDateTime;
    }

    @JsonProperty(value="evEndDateTime")
    public String getEvEndDateTime() {
        return this.evEndDateTime;
    }

    @JsonProperty(value="status")
    public StatusCode getStatus() {
        return this.status;
    }
}

