/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.probativevalue.pojo;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.worker.core.plugin.probativevalue.pojo.ChecksInformation;

public class ProbativeCheck {
    private final String name;
    private final String details;
    private final ChecksInformation.ChecksType type;
    private final ChecksInformation.ChecksSourceDestination source;
    private final ChecksInformation.ChecksSourceDestination destination;
    private final String sourceComparable;
    private final String destinationComparable;
    private final ChecksInformation.ChecksAction action;
    private final ChecksInformation.CheckedItem item;
    private final StatusCode status;

    @JsonCreator
    public ProbativeCheck(@JsonProperty(value="name") String name, @JsonProperty(value="details") String details, @JsonProperty(value="type") ChecksInformation.ChecksType type, @JsonProperty(value="source") ChecksInformation.ChecksSourceDestination source, @JsonProperty(value="destination") ChecksInformation.ChecksSourceDestination destination, @JsonProperty(value="sourceComparable") String sourceComparable, @JsonProperty(value="destinationComparable") String destinationComparable, @JsonProperty(value="action") ChecksInformation.ChecksAction action, @JsonProperty(value="item") ChecksInformation.CheckedItem item, @JsonProperty(value="status") StatusCode status) {
        this.name = name;
        this.details = details;
        this.type = type;
        this.source = source;
        this.destination = destination;
        this.sourceComparable = sourceComparable;
        this.destinationComparable = destinationComparable;
        this.action = action;
        this.item = item;
        this.status = status;
    }

    @JsonIgnore
    public static ProbativeCheck from(ChecksInformation information, String source, String destination, StatusCode status) {
        return new ProbativeCheck(information.name(), information.explanation, information.checksType, information.source, information.destination, source, destination, information.action, information.item, status);
    }

    @JsonIgnore
    public static ProbativeCheck okFrom(ChecksInformation information, String source, String destination) {
        return new ProbativeCheck(information.name(), information.explanation, information.checksType, information.source, information.destination, source, destination, information.action, information.item, StatusCode.OK);
    }

    @JsonIgnore
    public static ProbativeCheck koFrom(ChecksInformation information, String source, String destination) {
        return new ProbativeCheck(information.name(), information.explanation, information.checksType, information.source, information.destination, source, destination, information.action, information.item, StatusCode.KO);
    }

    @JsonIgnore
    public static ProbativeCheck warnFrom(ChecksInformation information, String source, String destination) {
        return new ProbativeCheck(information.name(), information.explanation, information.checksType, information.source, information.destination, source, destination, information.action, information.item, StatusCode.WARNING);
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="details")
    public String getDetails() {
        return this.details;
    }

    @JsonProperty(value="type")
    public ChecksInformation.ChecksType getType() {
        return this.type;
    }

    @JsonProperty(value="source")
    public ChecksInformation.ChecksSourceDestination getSource() {
        return this.source;
    }

    @JsonProperty(value="destination")
    public ChecksInformation.ChecksSourceDestination getDestination() {
        return this.destination;
    }

    @JsonProperty(value="sourceComparable")
    public String getSourceComparable() {
        return this.sourceComparable;
    }

    @JsonProperty(value="destinationComparable")
    public String getDestinationComparable() {
        return this.destinationComparable;
    }

    @JsonProperty(value="action")
    public ChecksInformation.ChecksAction getAction() {
        return this.action;
    }

    @JsonProperty(value="item")
    public ChecksInformation.CheckedItem getItem() {
        return this.item;
    }

    @JsonProperty(value="status")
    public StatusCode getStatus() {
        return this.status;
    }
}

