/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.probativevalue.pojo;

import java.io.File;

public class OperationTraceabilityFiles {
    public static final String TRACEABILITY_DATA = "data.txt";
    public static final String TRACEABILITY_MERKLE_TREE = "merkleTree.json";
    public static final String TRACEABILITY_TOKEN = "token.tsp";
    public static final String TRACEABILITY_COMPUTING_INFORMATION = "computing_information.txt";
    public static final String TRACEABILITY_ADDITIONAL_INFORMATION = "additional_information.txt";
    public static final String TRACEABILITY_FILES_COMPLETE = "zip_complete.ready";
    public static final String TRACEABILITY_GENERAL_CHECKS_COMPLETE = "general_checks.ready";
    public static final String TRACEABILITY_GENERAL_CHECKS = "general_checks.json";
    private final File data;
    private final File merkleTree;
    private final File token;
    private final File computingInformation;
    private final File additionalInformation;

    public OperationTraceabilityFiles(File data, File merkleTree, File token, File computingInformation, File additionalInformation) {
        this.data = data;
        this.merkleTree = merkleTree;
        this.token = token;
        this.computingInformation = computingInformation;
        this.additionalInformation = additionalInformation;
    }

    public File getData() {
        return this.data;
    }

    public File getMerkleTree() {
        return this.merkleTree;
    }

    public File getToken() {
        return this.token;
    }

    public File getComputingInformation() {
        return this.computingInformation;
    }

    public File getAdditionalInformation() {
        return this.additionalInformation;
    }

    public static final class OperationTraceabilityFilesBuilder {
        private File data;
        private File merkleTree;
        private File token;
        private File computingInformation;
        private File additionalInformation;

        private OperationTraceabilityFilesBuilder() {
        }

        public static OperationTraceabilityFilesBuilder anOperationTraceabilityFiles() {
            return new OperationTraceabilityFilesBuilder();
        }

        public OperationTraceabilityFilesBuilder with(String name, File file) {
            switch (name) {
                case "data.txt": {
                    this.data = file;
                    return this;
                }
                case "merkleTree.json": {
                    this.merkleTree = file;
                    return this;
                }
                case "token.tsp": {
                    this.token = file;
                    return this;
                }
                case "computing_information.txt": {
                    this.computingInformation = file;
                    return this;
                }
                case "additional_information.txt": {
                    this.additionalInformation = file;
                    return this;
                }
            }
            throw new IllegalArgumentException(String.format("%s is illegal.", name));
        }

        public OperationTraceabilityFiles build() {
            return new OperationTraceabilityFiles(this.data, this.merkleTree, this.token, this.computingInformation, this.additionalInformation);
        }
    }
}

