/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.probativevalue.pojo;

public enum ChecksInformation {
    FILE_DIGEST_OFFER_DATABASE_COMPARISON(ChecksType.LOCAL_INTEGRITY, ChecksSourceDestination.OFFER, ChecksSourceDestination.DATABASE, ChecksAction.COMPARISON, CheckedItem.FILE_DIGEST, "Comparing binary file digest stored in offers with binary file digest found in object group database."),
    FILE_DIGEST_LFC_DATABASE_COMPARISON(ChecksType.LOCAL_INTEGRITY, ChecksSourceDestination.DATABASE, ChecksSourceDestination.DATABASE, ChecksAction.COMPARISON, CheckedItem.FILE_DIGEST, "Comparing binary file digest found in object group database with binary file digest found in logbook lifecycle object group database."),
    FILE_DIGEST_DATABASE_TRACEABILITY_COMPARISON(ChecksType.LOCAL_INTEGRITY, ChecksSourceDestination.DATABASE, ChecksSourceDestination.TRACEABILITY_FILE, ChecksAction.COMPARISON, CheckedItem.FILE_DIGEST, "Comparing binary file digest found in object group database with binary file digest found in traceability secured file."),
    EVENTS_OBJECT_GROUP_DIGEST_DATABASE_TRACEABILITY_COMPARISON(ChecksType.LOCAL_INTEGRITY, ChecksSourceDestination.DATABASE, ChecksSourceDestination.TRACEABILITY_FILE, ChecksAction.COMPARISON, CheckedItem.EVENT_OBJECT_GROUP, "Comparing object group lfc digest computed from logbook lifecycle object group database with object group lfc digest found in traceability secured file."),
    EVENTS_OPERATION_DATABASE_TRACEABILITY_COMPARISON(ChecksType.LOCAL_INTEGRITY, ChecksSourceDestination.DATABASE, ChecksSourceDestination.TRACEABILITY_FILE, ChecksAction.COMPARISON, CheckedItem.EVENT_OPERATION, "Comparing operation ID found in database with operation ID found in traceability secured file."),
    MERKLE_OPERATION_DIGEST_DATABASE_TRACEABILITY_COMPARISON(ChecksType.MERKLE_INTEGRITY, ChecksSourceDestination.DATABASE, ChecksSourceDestination.TRACEABILITY_FILE, ChecksAction.COMPARISON, CheckedItem.MERKLE_TREE_ROOT_OPERATION_DIGEST, "Comparing operation merkle digest found in database with operation merkle digest found in traceability secured file."),
    MERKLE_OPERATION_DIGEST_COMPUTATION_TRACEABILITY_COMPARISON(ChecksType.MERKLE_INTEGRITY, ChecksSourceDestination.COMPUTATION, ChecksSourceDestination.TRACEABILITY_FILE, ChecksAction.COMPARISON, CheckedItem.MERKLE_TREE_ROOT_OPERATION_DIGEST, "Comparing operation merkle digest computed from secured data with operation merkle digest found in traceability secured file."),
    MERKLE_OPERATION_DIGEST_COMPUTATION_ADDITIONAL_TRACEABILITY_COMPARISON(ChecksType.MERKLE_INTEGRITY, ChecksSourceDestination.COMPUTATION, ChecksSourceDestination.ADDITIONAL_TRACEABILITY, ChecksAction.COMPARISON, CheckedItem.MERKLE_TREE_ROOT_OPERATION_DIGEST, "Comparing operation merkle digest computed from secured data with operation merkle digest found in additional traceability secured file."),
    MERKLE_OBJECT_GROUP_DIGEST_DATABASE_TRACEABILITY_COMPARISON(ChecksType.MERKLE_INTEGRITY, ChecksSourceDestination.DATABASE, ChecksSourceDestination.TRACEABILITY_FILE, ChecksAction.COMPARISON, CheckedItem.MERKLE_TREE_ROOT_OBJECT_GROUP_DIGEST, "Comparing object group merkle digest found in database with object group merkle digest found in traceability secured file."),
    MERKLE_OBJECT_GROUP_DIGEST_COMPUTATION_TRACEABILITY_COMPARISON(ChecksType.MERKLE_INTEGRITY, ChecksSourceDestination.COMPUTATION, ChecksSourceDestination.TRACEABILITY_FILE, ChecksAction.COMPARISON, CheckedItem.MERKLE_TREE_ROOT_OBJECT_GROUP_DIGEST, "Comparing object group merkle digest computed from secured data with object group merkle digest found in traceability secured file."),
    MERKLE_OBJECT_GROUP_DIGEST_COMPUTATION_ADDITIONAL_TRACEABILITY_COMPARISON(ChecksType.MERKLE_INTEGRITY, ChecksSourceDestination.COMPUTATION, ChecksSourceDestination.ADDITIONAL_TRACEABILITY, ChecksAction.COMPARISON, CheckedItem.MERKLE_TREE_ROOT_OBJECT_GROUP_DIGEST, "Comparing object group merkle digest computed from secured data with object group merkle digest found in additional traceability secured file."),
    TIMESTAMP_OPERATION_DATABASE_TRACEABILITY_VALIDATION(ChecksType.TIMESTAMP_CHECKING, ChecksSourceDestination.DATABASE, ChecksSourceDestination.TRACEABILITY_FILE, ChecksAction.VALIDATION, CheckedItem.TIMESTAMP_OPERATION, "Validating timestamp operation found in database 'AND' timestamp operation found in traceability secured file."),
    TIMESTAMP_OPERATION_DATABASE_TRACEABILITY_COMPARISON(ChecksType.TIMESTAMP_CHECKING, ChecksSourceDestination.DATABASE, ChecksSourceDestination.TRACEABILITY_FILE, ChecksAction.COMPARISON, CheckedItem.TIMESTAMP_OPERATION, "Comparing timestamp operation found in database with timestamp operation found in traceability secured file."),
    TIMESTAMP_OPERATION_COMPUTATION_TRACEABILITY_COMPARISON(ChecksType.TIMESTAMP_CHECKING, ChecksSourceDestination.COMPUTATION, ChecksSourceDestination.TRACEABILITY_FILE, ChecksAction.COMPARISON, CheckedItem.TIMESTAMP_OPERATION, "Comparing timestamp operation computed from computing information traceability file with timestamp operation found in traceability secured file."),
    TIMESTAMP_OBJECT_GROUP_DATABASE_TRACEABILITY_VALIDATION(ChecksType.TIMESTAMP_CHECKING, ChecksSourceDestination.DATABASE, ChecksSourceDestination.TRACEABILITY_FILE, ChecksAction.VALIDATION, CheckedItem.TIMESTAMP_OBJECT_GROUP, "Validating timestamp object group found in database 'AND' timestamp object group found in traceability secured file."),
    TIMESTAMP_OBJECT_GROUP_DATABASE_TRACEABILITY_COMPARISON(ChecksType.TIMESTAMP_CHECKING, ChecksSourceDestination.DATABASE, ChecksSourceDestination.TRACEABILITY_FILE, ChecksAction.COMPARISON, CheckedItem.TIMESTAMP_OBJECT_GROUP, "Comparing timestamp object group found in database with timestamp object group found in secured file."),
    TIMESTAMP_OBJECT_GROUP_COMPUTATION_TRACEABILITY_COMPARISON(ChecksType.TIMESTAMP_CHECKING, ChecksSourceDestination.COMPUTATION, ChecksSourceDestination.TRACEABILITY_FILE, ChecksAction.COMPARISON, CheckedItem.TIMESTAMP_OBJECT_GROUP, "Comparing timestamp object group computed from computing information traceability file with timestamp object group found in secured file."),
    PREVIOUS_TIMESTAMP_OPERATION_DATABASE_TRACEABILITY_VALIDATION(ChecksType.CHAIN, ChecksSourceDestination.DATABASE, ChecksSourceDestination.TRACEABILITY_FILE, ChecksAction.VALIDATION, CheckedItem.PREVIOUS_TIMESTAMP_OPERATION, "Validating previous timestamp operation found in database 'AND' previous timestamp operation found in traceability secured file."),
    PREVIOUS_TIMESTAMP_OPERATION_DATABASE_TRACEABILITY_COMPARISON(ChecksType.CHAIN, ChecksSourceDestination.DATABASE, ChecksSourceDestination.TRACEABILITY_FILE, ChecksAction.COMPARISON, CheckedItem.PREVIOUS_TIMESTAMP_OPERATION, "Comparing previous timestamp operation found in database with previous timestamp operation found in traceability secured file."),
    PREVIOUS_TIMESTAMP_OBJECT_GROUP_DATABASE_TRACEABILITY_VALIDATION(ChecksType.CHAIN, ChecksSourceDestination.DATABASE, ChecksSourceDestination.TRACEABILITY_FILE, ChecksAction.VALIDATION, CheckedItem.PREVIOUS_TIMESTAMP_OBJECT_GROUP, "Validating previous timestamp object group found in database 'AND' previous timestamp object group found in traceability secured file."),
    PREVIOUS_TIMESTAMP_OBJECT_GROUP_DATABASE_TRACEABILITY_COMPARISON(ChecksType.CHAIN, ChecksSourceDestination.DATABASE, ChecksSourceDestination.TRACEABILITY_FILE, ChecksAction.COMPARISON, CheckedItem.PREVIOUS_TIMESTAMP_OBJECT_GROUP, "Comparing previous timestamp object group found in database with previous timestamp object group found in traceability secured file.");

    public final ChecksType checksType;
    public final ChecksSourceDestination source;
    public final ChecksSourceDestination destination;
    public final ChecksAction action;
    public final CheckedItem item;
    public final String explanation;

    private ChecksInformation(ChecksType checksType, ChecksSourceDestination source, ChecksSourceDestination destination, ChecksAction action, CheckedItem item, String explanation) {
        this.checksType = checksType;
        this.source = source;
        this.destination = destination;
        this.action = action;
        this.item = item;
        this.explanation = explanation;
    }

    public String toString() {
        return String.format("'%s' of type '%s' with explanation '%s'.\n", new Object[]{this.name(), this.checksType, this.explanation});
    }

    public static enum CheckedItem {
        FILE_DIGEST,
        EVENT_LFC,
        EVENT_OBJECT_GROUP,
        EVENT_OPERATION,
        MERKLE_TREE_ROOT_LFC_DIGEST,
        MERKLE_TREE_ROOT_OPERATION_DIGEST,
        TIMESTAMP_LFC,
        TIMESTAMP_OPERATION,
        PREVIOUS_TIMESTAMP_LFC,
        PREVIOUS_TIMESTAMP_OPERATION,
        MERKLE_TREE_ROOT_OBJECT_GROUP_DIGEST,
        TIMESTAMP_OBJECT_GROUP,
        PREVIOUS_TIMESTAMP_OBJECT_GROUP;

    }

    public static enum ChecksAction {
        COMPARISON,
        VALIDATION;

    }

    public static enum ChecksSourceDestination {
        OFFER,
        DATABASE,
        TRACEABILITY_FILE,
        ADDITIONAL_TRACEABILITY,
        COMPUTATION;

    }

    public static enum ChecksType {
        LOCAL_INTEGRITY,
        MERKLE_INTEGRITY,
        TIMESTAMP_CHECKING,
        CHAIN;

    }
}

