/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.worker.core.plugin.probativevalue;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.BaseXx;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.accesslog.AccessLogUtils;
import fr.gouv.vitam.common.database.builder.query.BooleanQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.LifeCycleTraceabilitySecureFileObject;
import fr.gouv.vitam.common.model.MetadataType;
import fr.gouv.vitam.common.model.ObjectGroupDocumentHash;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.logbook.LogbookEvent;
import fr.gouv.vitam.common.model.logbook.LogbookLifecycle;
import fr.gouv.vitam.common.model.logbook.LogbookOperation;
import fr.gouv.vitam.common.model.objectgroup.DbObjectGroupModel;
import fr.gouv.vitam.common.model.objectgroup.DbVersionsModel;
import fr.gouv.vitam.common.security.merkletree.MerkleTreeAlgo;
import fr.gouv.vitam.common.stream.StreamUtils;
import fr.gouv.vitam.logbook.common.exception.LogbookClientException;
import fr.gouv.vitam.logbook.common.model.TraceabilityEvent;
import fr.gouv.vitam.logbook.common.parameters.Contexts;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookMongoDbName;
import fr.gouv.vitam.logbook.common.traceability.TimeStampService;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClientFactory;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingException;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageNotFoundClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.referential.model.StorageStrategy;
import fr.gouv.vitam.worker.common.HandlerIO;
import fr.gouv.vitam.worker.core.exception.ProcessingStatusException;
import fr.gouv.vitam.worker.core.handler.ActionHandler;
import fr.gouv.vitam.worker.core.plugin.probativevalue.pojo.ChecksInformation;
import fr.gouv.vitam.worker.core.plugin.probativevalue.pojo.OperationTraceabilityFiles;
import fr.gouv.vitam.worker.core.plugin.probativevalue.pojo.OperationWithClosestPreviousOperation;
import fr.gouv.vitam.worker.core.plugin.probativevalue.pojo.ProbativeCheck;
import fr.gouv.vitam.worker.core.plugin.probativevalue.pojo.ProbativeOperation;
import fr.gouv.vitam.worker.core.plugin.probativevalue.pojo.ProbativeReportEntry;
import fr.gouv.vitam.worker.core.plugin.traceability.VerifyMerkleTreeActionHandler;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.ess.ESSCertIDv2;
import org.bouncycastle.asn1.ess.SigningCertificateV2;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;

public class ProbativeCreateReportEntry
extends ActionHandler {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ProbativeCreateReportEntry.class);
    private static final String HANDLER_ID = "PROBATIVE_VALUE_CREATE_PROBATIVE_REPORT_ENTRY";
    public static final String NO_BINARY_ID = "NO_BINARY_ID";
    private static final int STRATEGIES_IN_RANK = 0;
    private static final TypeReference<List<LogbookOperation>> OPERATIONS_TYPE = new TypeReference<List<LogbookOperation>>(){};
    private static final TypeReference<LogbookOperation> OPERATION_TYPE = new TypeReference<LogbookOperation>(){};
    private static final TypeReference<LifeCycleTraceabilitySecureFileObject> LIFECYCLE_TYPE = new TypeReference<LifeCycleTraceabilitySecureFileObject>(){};
    private static final TypeReference<List<String>> LIST_STRING = new TypeReference<List<String>>(){};
    private static final TypeReference<List<ProbativeCheck>> LIST_PROBATIVE = new TypeReference<List<ProbativeCheck>>(){};
    private final MetaDataClientFactory metaDataClientFactory;
    private final LogbookLifeCyclesClientFactory logbookLifeCyclesClientFactory;
    private final StorageClientFactory storageClientFactory;
    private final LogbookOperationsClientFactory logbookOperationsClientFactory;
    private final TimeStampService timeStampService;

    @VisibleForTesting
    public ProbativeCreateReportEntry(MetaDataClientFactory metaDataClientFactory, LogbookLifeCyclesClientFactory logbookLifeCyclesClientFactory, StorageClientFactory storageClientFactory, LogbookOperationsClientFactory logbookOperationsClientFactory, TimeStampService timeStampService) {
        this.metaDataClientFactory = metaDataClientFactory;
        this.logbookLifeCyclesClientFactory = logbookLifeCyclesClientFactory;
        this.storageClientFactory = storageClientFactory;
        this.logbookOperationsClientFactory = logbookOperationsClientFactory;
        this.timeStampService = timeStampService;
    }

    public ProbativeCreateReportEntry() {
        this(MetaDataClientFactory.getInstance(), LogbookLifeCyclesClientFactory.getInstance(), StorageClientFactory.getInstance(), LogbookOperationsClientFactory.getInstance(), new TimeStampService());
    }

    /*
     * Exception decompiling
     */
    public ItemStatus execute(WorkerParameters param, HandlerIO handler) throws ProcessingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [42[TRYBLOCK]], but top level block is 65[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getObjectGroupLFCLastPersistedDate(LogbookLifecycle logbookObjectGroupLFC, DbVersionsModel dbVersionsModel) {
        return logbookObjectGroupLFC.getEvents().stream().filter(this::isOKEvent).filter(event -> event.getOutDetail().contains("OBJECT_STORAGE_SUB_TASK")).filter(e -> e.getObId().equals(dbVersionsModel.getId())).map(LogbookEvent::getLastPersistedDate).findFirst().orElse(null);
    }

    private ProbativeOperation logbookOperationTo(LogbookOperation op) {
        return new ProbativeOperation(op.getId(), op.getEvType(), op.getEvIdAppSession(), op.getRightsStatementIdentifier(), op.getAgIdApp(), op.getEvDateTime());
    }

    private void tryTransferReportEntryToWorkspace(HandlerIO handler, String objectGroupId, ProbativeReportEntry probativeReportEntry) throws ProcessingException {
        try {
            this.transferReportEntryToWorkspace(handler, objectGroupId, probativeReportEntry);
        }
        catch (Exception e) {
            throw new ProcessingException((Throwable)e);
        }
    }

    private void transferReportEntryToWorkspace(HandlerIO handler, String objectGroupId, ProbativeReportEntry probativeReportEntry) throws InvalidParseOperationException, ProcessingException {
        File newLocalFile = handler.getNewLocalFile(objectGroupId);
        JsonHandler.writeAsFile((Object)probativeReportEntry, (File)newLocalFile);
        handler.transferFileToWorkspace(objectGroupId, newLocalFile, true, false);
    }

    private Stream<ProbativeCheck> doChecks(OperationTraceabilityFiles traceabilityFiles, OperationWithClosestPreviousOperation traceabilityLogbookOperations, DbVersionsModel objectModel, JsonNode logbookObjectGroupLFC, LogbookOperation logbookOperationVersionModel, HandlerIO handler) {
        String evType = traceabilityLogbookOperations.getOperation().getEvType();
        if (Contexts.OBJECTGROUP_LFC_TRACEABILITY.getEventType().equals(evType)) {
            return this.doObjectGroupChecks(traceabilityFiles, traceabilityLogbookOperations, logbookObjectGroupLFC, objectModel, handler);
        }
        if (Contexts.LOGBOOK_TRACEABILITY.getEventType().equals(evType)) {
            return this.doOperationChecks(traceabilityFiles, traceabilityLogbookOperations, logbookOperationVersionModel, objectModel, handler);
        }
        throw new IllegalArgumentException(String.format("unknown operationKey %s", evType));
    }

    /*
     * Exception decompiling
     */
    private Stream<ProbativeCheck> doOperationChecks(OperationTraceabilityFiles traceabilityFiles, OperationWithClosestPreviousOperation traceabilityLogbookOperations, LogbookOperation logbookOperationVersionModel, DbVersionsModel objectModel, HandlerIO handler) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isEventBeforeInSecured(LogbookOperation traceabilityLogbookOperation, JsonNode event) {
        LocalDateTime traceabilityDateTime;
        LocalDateTime eventDateTime = LocalDateUtil.parseMongoFormattedDate((String)event.get("evDateTime").asText());
        return eventDateTime.isBefore(traceabilityDateTime = LocalDateUtil.parseMongoFormattedDate((String)traceabilityLogbookOperation.getEvDateTime())) || eventDateTime.isEqual(traceabilityDateTime);
    }

    /*
     * Exception decompiling
     */
    private Stream<ProbativeCheck> doObjectGroupChecks(OperationTraceabilityFiles traceabilityFiles, OperationWithClosestPreviousOperation traceabilityLogbookOperations, JsonNode logbookObjectGroupLFC, DbVersionsModel objectModel, HandlerIO handler) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Stream<ProbativeCheck> getGeneralCheck(ChecksInformation timeStampValidation, ChecksInformation timeStampComparison, ChecksInformation previousTimeStampValidation, ChecksInformation previousTimeStampComparison, ChecksInformation checkMerkleTreeInformation, ChecksInformation checkMerkleTreeInformationComputed, ChecksInformation checkMerkleComputingInformation, ChecksInformation checkComputedTimestamp, LogbookOperation traceabilityLogbookOperation, OperationTraceabilityFiles traceabilityFiles, InputStream computingInformation, LogbookOperation closestTraceabilityLogbookOperation, HandlerIO handlerIO, String objectGroupId, String evType) throws Exception {
        List<ProbativeCheck> generalChecksFromWorkspace = this.getGeneralChecksFromWorkspace(handlerIO, objectGroupId, evType);
        if (!generalChecksFromWorkspace.isEmpty()) {
            return generalChecksFromWorkspace.stream();
        }
        String timeStampFromTraceabilityFile = new String(Files.readAllBytes(traceabilityFiles.getToken().toPath()));
        String timeStampFromLogbookOperation = this.getTimeStampFromLogbookOperation(traceabilityLogbookOperation);
        ProbativeCheck validateTimeStamp = this.validateTimeStamp(timeStampValidation, timeStampFromTraceabilityFile, timeStampFromLogbookOperation);
        ProbativeCheck compareTimeStamp = this.compare(timeStampComparison, timeStampFromTraceabilityFile, timeStampFromLogbookOperation);
        String digestFromDatabase = ((TraceabilityEvent)JsonHandler.getFromString((String)traceabilityLogbookOperation.getEvDetData(), TraceabilityEvent.class)).getHash();
        MerkleTreeAlgo merkleTreeAlgo = VerifyMerkleTreeActionHandler.computeMerkleTree(new FileInputStream(traceabilityFiles.getData()), VitamConfiguration.getDefaultDigestType());
        String digestRecalculated = BaseXx.getBase64((byte[])merkleTreeAlgo.generateMerkle().getRoot());
        String traceabilityMerkleFileMerkleTreeRootDigest = this.getTraceabilityMerkleFileMerkleTreeRootDigest(traceabilityFiles.getMerkleTree());
        ProbativeCheck checkFromMerkleTree = this.compare(checkMerkleTreeInformation, traceabilityMerkleFileMerkleTreeRootDigest, digestFromDatabase);
        ProbativeCheck checkFromMerkleTreeComputed = this.compare(checkMerkleTreeInformationComputed, traceabilityMerkleFileMerkleTreeRootDigest, digestRecalculated);
        Properties computingProperties = new Properties();
        computingProperties.load(computingInformation);
        ProbativeCheck merkleDigestInAdditionalInformation = this.compare(checkMerkleComputingInformation, digestRecalculated, computingProperties.getProperty("currentHash"));
        ProbativeCheck computedTimeStampComparison = this.computeAndCompareTimeStamp(checkComputedTimestamp, timeStampFromTraceabilityFile, computingProperties);
        String previousTimeStampFromTraceabilityFile = computingProperties.getProperty("previousTimestampToken");
        if (previousTimeStampFromTraceabilityFile == null || previousTimeStampFromTraceabilityFile.equals("null")) {
            List<ProbativeCheck> probativeChecks = Arrays.asList(validateTimeStamp, compareTimeStamp, checkFromMerkleTree, checkFromMerkleTreeComputed, merkleDigestInAdditionalInformation, computedTimeStampComparison, ProbativeCheck.warnFrom(previousTimeStampValidation, "No previous secured file.", "No previous secured file."), ProbativeCheck.warnFrom(previousTimeStampComparison, "No previous secured file.", "No previous secured file."));
            this.transferGeneralChecksToWorkspace(handlerIO, objectGroupId, evType, probativeChecks);
            return probativeChecks.stream();
        }
        String previousTimeStampFromLogbookOperation = this.getTimeStampFromLogbookOperation(closestTraceabilityLogbookOperation);
        ProbativeCheck validatePreviousTimeStamp = this.validateTimeStamp(previousTimeStampValidation, previousTimeStampFromTraceabilityFile, previousTimeStampFromLogbookOperation);
        ProbativeCheck comparePreviousTimeStamp = this.compare(previousTimeStampComparison, previousTimeStampFromTraceabilityFile, previousTimeStampFromLogbookOperation);
        List<ProbativeCheck> probativeChecks = Arrays.asList(validateTimeStamp, compareTimeStamp, checkFromMerkleTree, checkFromMerkleTreeComputed, merkleDigestInAdditionalInformation, validatePreviousTimeStamp, computedTimeStampComparison, comparePreviousTimeStamp);
        this.transferGeneralChecksToWorkspace(handlerIO, objectGroupId, evType, probativeChecks);
        return probativeChecks.stream();
    }

    private ProbativeCheck computeAndCompareTimeStamp(ChecksInformation checkComputedTimestamp, String timeStampFromTraceabilityFile, Properties computingProperties) {
        try {
            byte[] prevTimeStampToken = this.timeStampService.getDigestAsBytes(computingProperties.getProperty("previousTimestampToken"));
            byte[] prevTimestampTokenMinusOneMonth = this.timeStampService.getDigestAsBytes(computingProperties.getProperty("previousTimestampTokenMinusOneMonth"));
            byte[] prevTimestampTokenMinusOneYear = this.timeStampService.getDigestAsBytes(computingProperties.getProperty("previousTimestampTokenMinusOneYear"));
            byte[] rootMerkleTree = this.timeStampService.getDigestAsBytes(computingProperties.getProperty("currentHash"));
            TimeStampToken timeStampToken = this.timeStampService.getTimeStampFrom(timeStampFromTraceabilityFile);
            byte[] timeStampDataFromFile = timeStampToken.getTimeStampInfo().getMessageImprintDigest();
            byte[] computedTimeStampData = this.timeStampService.getDigestFrom((byte[][])new byte[][]{rootMerkleTree, prevTimeStampToken, prevTimestampTokenMinusOneMonth, prevTimestampTokenMinusOneYear});
            return ProbativeCheck.from(checkComputedTimestamp, BaseXx.getBase64((byte[])timeStampDataFromFile), BaseXx.getBase64((byte[])computedTimeStampData), Arrays.equals(timeStampDataFromFile, computedTimeStampData) ? StatusCode.OK : StatusCode.KO);
        }
        catch (Exception e) {
            LOGGER.warn((Throwable)e);
            return ProbativeCheck.koFrom(checkComputedTimestamp, timeStampFromTraceabilityFile, "NO_COMPUTED_TIMESTAMP_DATA");
        }
    }

    private List<ProbativeCheck> getGeneralChecksFromWorkspace(HandlerIO handlerIO, String objectGroupId, String evType) {
        if (this.isTraceabilityFilesAbsent(handlerIO, objectGroupId, evType, "general_checks.ready")) {
            return Collections.emptyList();
        }
        try {
            File fileFromWorkspace = handlerIO.getFileFromWorkspace(ProbativeCreateReportEntry.traceabilityFilesDirectoryName(objectGroupId, evType) + File.separator + "general_checks.json");
            return (List)JsonHandler.getFromFileAsTypeReference((File)fileFromWorkspace, LIST_PROBATIVE);
        }
        catch (Exception e) {
            LOGGER.warn((Throwable)e);
            return Collections.emptyList();
        }
    }

    private void transferGeneralChecksToWorkspace(HandlerIO handlerIO, String objectGroupId, String evType, List<ProbativeCheck> probativeChecks) throws InvalidParseOperationException, ProcessingException, IOException {
        File sourceFile = File.createTempFile("tmp", null, new File(VitamConfiguration.getVitamTmpFolder()));
        JsonHandler.writeAsFile(probativeChecks, (File)sourceFile);
        handlerIO.transferFileToWorkspace(ProbativeCreateReportEntry.traceabilityFilesDirectoryName(objectGroupId, evType) + File.separator + "general_checks.json", sourceFile, false, false);
        handlerIO.transferInputStreamToWorkspace(ProbativeCreateReportEntry.traceabilityFilesDirectoryName(objectGroupId, evType) + File.separator + "general_checks.ready", (InputStream)new ByteArrayInputStream(new byte[0]), null, false);
    }

    private ProbativeCheck compare(ChecksInformation information, String digest, String otherDigest) {
        return ProbativeCheck.from(information, otherDigest, digest, otherDigest.equals(digest) ? StatusCode.OK : StatusCode.KO);
    }

    private ProbativeCheck validateTimeStamp(ChecksInformation information, String timeStampFromTraceabilityFile, String timeStampFromLogbookOperation) {
        return ProbativeCheck.from(information, timeStampFromLogbookOperation, timeStampFromTraceabilityFile, this.isTimeStampValid(timeStampFromLogbookOperation) && this.isTimeStampValid(timeStampFromTraceabilityFile) ? StatusCode.OK : StatusCode.KO);
    }

    private String getTimeStampFromLogbookOperation(LogbookOperation traceabilityLogbookOperation) throws InvalidParseOperationException {
        String evDetData = traceabilityLogbookOperation.getEvDetData();
        JsonNode eventDetail = JsonHandler.getFromString((String)evDetData);
        TraceabilityEvent traceabilityEvent = (TraceabilityEvent)JsonHandler.getFromJsonNode((JsonNode)eventDetail, TraceabilityEvent.class);
        return BaseXx.getBase64((byte[])traceabilityEvent.getTimeStampToken());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<OperationTraceabilityFiles> getTraceabilityFile(LogbookOperation logbookEventOperation, StorageClient storageClient, HandlerIO handlerIO, String objectGroupId) {
        Response response = null;
        try {
            TraceabilityEvent traceabilityEvent = (TraceabilityEvent)JsonHandler.getFromString((String)logbookEventOperation.getEvDetData(), TraceabilityEvent.class);
            String evType = logbookEventOperation.getEvType();
            Optional<OperationTraceabilityFiles> operationTraceabilityFilesFromWorkspace = this.tryGetOperationTraceabilityFileFromWorkspace(handlerIO, objectGroupId, evType);
            if (operationTraceabilityFilesFromWorkspace.isPresent()) {
                Optional<OperationTraceabilityFiles> optional = operationTraceabilityFilesFromWorkspace;
                return optional;
            }
            response = storageClient.getContainerAsync(VitamConfiguration.getDefaultStrategy(), traceabilityEvent.getFileName(), DataCategory.LOGBOOK, AccessLogUtils.getNoLogAccessLog());
            Optional<OperationTraceabilityFiles> optional = Optional.of(this.extractZipFiles(response, handlerIO, objectGroupId, evType));
            StreamUtils.consumeAnyEntityAndClose((Response)response);
            return optional;
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            Optional<OperationTraceabilityFiles> optional = Optional.empty();
            return optional;
        }
        finally {
            StreamUtils.consumeAnyEntityAndClose(response);
        }
    }

    private Optional<OperationTraceabilityFiles> tryGetOperationTraceabilityFileFromWorkspace(HandlerIO handlerIO, String objectGroupId, String evType) {
        if (this.isTraceabilityFilesAbsent(handlerIO, objectGroupId, evType, "zip_complete.ready")) {
            return Optional.empty();
        }
        try {
            return Optional.of(new OperationTraceabilityFiles(handlerIO.getFileFromWorkspace(ProbativeCreateReportEntry.traceabilityFilesDirectoryName(objectGroupId, evType) + File.separator + "data.txt"), handlerIO.getFileFromWorkspace(ProbativeCreateReportEntry.traceabilityFilesDirectoryName(objectGroupId, evType) + File.separator + "merkleTree.json"), handlerIO.getFileFromWorkspace(ProbativeCreateReportEntry.traceabilityFilesDirectoryName(objectGroupId, evType) + File.separator + "token.tsp"), handlerIO.getFileFromWorkspace(ProbativeCreateReportEntry.traceabilityFilesDirectoryName(objectGroupId, evType) + File.separator + "computing_information.txt"), handlerIO.getFileFromWorkspace(ProbativeCreateReportEntry.traceabilityFilesDirectoryName(objectGroupId, evType) + File.separator + "additional_information.txt")));
        }
        catch (Exception e) {
            LOGGER.warn((Throwable)e);
            return Optional.empty();
        }
    }

    private boolean isTraceabilityFilesAbsent(HandlerIO handlerIO, String objectGroupId, String evType, String complete) {
        try {
            handlerIO.getFileFromWorkspace(ProbativeCreateReportEntry.traceabilityFilesDirectoryName(objectGroupId, evType) + File.separator + complete);
            return false;
        }
        catch (Exception e) {
            LOGGER.warn((Throwable)e);
            return true;
        }
    }

    private OperationTraceabilityFiles extractZipFiles(Response response, HandlerIO handlerIO, String objectGroupId, String evType) throws IOException, ProcessingException {
        OperationTraceabilityFiles.OperationTraceabilityFilesBuilder filesBuilder = OperationTraceabilityFiles.OperationTraceabilityFilesBuilder.anOperationTraceabilityFiles();
        try (InputStream inputStream = (InputStream)response.readEntity(InputStream.class);
             ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
            ZipEntry entry;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                File file = File.createTempFile("tmp", null, new File(VitamConfiguration.getVitamTmpFolder()));
                try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                    IOUtils.copy((InputStream)zipInputStream, (OutputStream)fileOutputStream);
                }
                filesBuilder.with(entry.getName(), file);
                handlerIO.transferFileToWorkspace(ProbativeCreateReportEntry.traceabilityFilesDirectoryName(objectGroupId, evType) + File.separator + entry.getName(), file, false, false);
            }
            handlerIO.transferInputStreamToWorkspace(ProbativeCreateReportEntry.traceabilityFilesDirectoryName(objectGroupId, evType) + File.separator + "zip_complete.ready", (InputStream)new ByteArrayInputStream(new byte[0]), null, false);
        }
        return filesBuilder.build();
    }

    private Optional<OperationWithClosestPreviousOperation> getTraceabilityOperation(LogbookOperationsClient logbookOperationsClient, LogbookOperation operation) {
        try {
            Select select = new Select();
            BooleanQuery query = QueryHelper.and().add(new Query[]{QueryHelper.eq((String)LogbookMongoDbName.eventType.getDbname(), (String)operation.getEvType()), QueryHelper.in((String)"events.outDetail", (String[])new String[]{operation.getEvType() + "." + StatusCode.OK, operation.getEvType() + "." + StatusCode.WARNING}), QueryHelper.exists((String)"events.evDetData.FileName"), QueryHelper.ne((String)"#id", (String)operation.getId()), QueryHelper.lte((String)LogbookMongoDbName.eventDateTime.getDbname(), (String)operation.getEvDateTime())});
            select.setQuery((Query)query);
            select.setLimitFilter(0L, 1L);
            select.addOrderByDescFilter(new String[]{"evDateTime"});
            JsonNode jsonNode = logbookOperationsClient.selectOperation((JsonNode)select.getFinalSelect());
            List closestToReferenceOperations = (List)JsonHandler.getFromJsonNode((JsonNode)jsonNode.get("$results"), OPERATIONS_TYPE);
            TraceabilityEvent emptyEvent = new TraceabilityEvent();
            emptyEvent.setTimeStampToken("NO_TIMESTAMP".getBytes());
            LogbookOperation closestToReferenceOperation = closestToReferenceOperations.stream().findFirst().orElse(LogbookOperation.emptyWithEvDetData((String)JsonHandler.writeAsString((Object)emptyEvent)));
            return Optional.of(new OperationWithClosestPreviousOperation(operation, closestToReferenceOperation));
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException | LogbookClientException e) {
            LOGGER.warn(e);
            return Optional.empty();
        }
    }

    private List<LogbookOperation> getTraceabilityLogbookOperation(LogbookOperationsClient logbookOperationsClient, String ingestEvDate, String lastPersistedGOTLFCDate) throws LogbookClientException, InvalidParseOperationException, InvalidCreateOperationException {
        if (StringUtils.isBlank((CharSequence)ingestEvDate) || StringUtils.isBlank((CharSequence)lastPersistedGOTLFCDate)) {
            return Collections.emptyList();
        }
        Optional<LogbookOperation> logbook = this.getOperationId(logbookOperationsClient, ingestEvDate, Contexts.LOGBOOK_TRACEABILITY.getEventType());
        Optional<LogbookOperation> objectGroupLFC = this.getOperationId(logbookOperationsClient, lastPersistedGOTLFCDate, Contexts.OBJECTGROUP_LFC_TRACEABILITY.getEventType());
        if (logbook.isPresent() && objectGroupLFC.isPresent()) {
            return Arrays.asList(logbook.get(), objectGroupLFC.get());
        }
        return Collections.emptyList();
    }

    private Optional<LogbookOperation> getOperationId(LogbookOperationsClient logbookOperationsClient, String lastPersistedIngestOperationDate, String eventType) throws InvalidCreateOperationException, InvalidParseOperationException, LogbookClientException {
        Select select = new Select();
        BooleanQuery query = QueryHelper.and().add(new Query[]{QueryHelper.eq((String)LogbookMongoDbName.eventType.getDbname(), (String)eventType), QueryHelper.in((String)"events.outDetail", (String[])new String[]{eventType + "." + StatusCode.OK, eventType + "." + StatusCode.WARNING}), QueryHelper.exists((String)"events.evDetData.FileName"), QueryHelper.lte((String)"events.evDetData.StartDate", (String)lastPersistedIngestOperationDate), QueryHelper.gte((String)"events.evDetData.EndDate", (String)lastPersistedIngestOperationDate)});
        select.setQuery((Query)query);
        select.setLimitFilter(0L, 1L);
        select.addOrderByDescFilter(new String[]{"events.evDateTime"});
        RequestResponseOK requestResponseOK = RequestResponseOK.getFromJsonNode((JsonNode)logbookOperationsClient.selectOperation((JsonNode)select.getFinalSelect()));
        if (requestResponseOK.getResults().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((LogbookOperation)JsonHandler.getFromJsonNode((JsonNode)((JsonNode)requestResponseOK.getFirstResult()), LogbookOperation.class));
    }

    private Set<String> getLifeCycleDigests(LogbookLifecycle logbookLifeCycles, DbVersionsModel versionsModel) {
        if (Objects.isNull(logbookLifeCycles) || Objects.isNull(logbookLifeCycles.getEvents())) {
            return Collections.emptySet();
        }
        return logbookLifeCycles.getEvents().stream().filter(event -> this.isBinaryEvent(versionsModel, (LogbookEvent)event)).filter(this::isDigestEvent).filter(this::isOKEvent).map(this::toJsonNode).map(evDetData -> this.getDigest((JsonNode)evDetData, versionsModel.getId())).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
    }

    private List<String> getOfferDigests(StorageClient storageClient, String objectGuid, String strategyId, List<String> offerIds) throws StorageNotFoundClientException, StorageServerClientException {
        JsonNode information = storageClient.getInformation(strategyId, DataCategory.OBJECT, objectGuid, offerIds, false);
        return offerIds.stream().map(arg_0 -> ((JsonNode)information).get(arg_0)).filter(Objects::nonNull).filter(jsonNode -> !jsonNode.isMissingNode()).filter(jsonNode -> !jsonNode.isNull()).map(jsonNode -> jsonNode.get("digest").textValue()).filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    private ProbativeCheck fileDigestComparison(ChecksInformation information, String databaseDigest, Set<String> otherDigests) {
        if (otherDigests.size() != 1 || !otherDigests.contains(databaseDigest)) {
            return ProbativeCheck.koFrom(information, String.join((CharSequence)", ", otherDigests), databaseDigest);
        }
        return ProbativeCheck.okFrom(information, String.join((CharSequence)", ", otherDigests), databaseDigest);
    }

    private String getDigest(JsonNode evDetData, String id) {
        boolean isDigestFromPreservationEvent = evDetData.path("MessageDigest").isNull() || evDetData.path("MessageDigest").isMissingNode();
        return isDigestFromPreservationEvent ? this.getDigestFromPreservation(evDetData, id) : this.getDigestFromIngest(evDetData);
    }

    private String getDigestFromIngest(JsonNode jsonNode) {
        return jsonNode.get("MessageDigest").asText();
    }

    private String getDigestFromPreservation(JsonNode jsonNode, String id) {
        return jsonNode.get(id).get("MessageDigest").asText();
    }

    private JsonNode toJsonNode(LogbookEvent event) {
        try {
            return JsonHandler.getFromString((String)event.getEvDetData());
        }
        catch (InvalidParseOperationException e) {
            throw new VitamRuntimeException((Throwable)e);
        }
    }

    private boolean isOKEvent(LogbookEvent event) {
        return event.getOutDetail().toUpperCase().contains(StatusCode.OK.name());
    }

    private boolean isBinaryEvent(DbVersionsModel versionsModel, LogbookEvent event) {
        return event.getObId().equals(versionsModel.getId());
    }

    private boolean isDigestEvent(LogbookEvent event) {
        return event.getOutDetail().contains("OBJECT_STORAGE_SUB_TASK") || event.getOutDetail().contains("CALC_CHECK") || event.getOutDetail().contains("PRESERVATION_BINARY_HASH") || event.getOutDetail().contains("OBJECT_STORAGE_TASK");
    }

    private Optional<DbVersionsModel> getVersion(String usageVersion, RequestResponse<JsonNode> requestResponse) throws InvalidParseOperationException {
        DbObjectGroupModel objectGroup = (DbObjectGroupModel)JsonHandler.getFromJsonNode((JsonNode)((JsonNode)((RequestResponseOK)requestResponse).getFirstResult()), DbObjectGroupModel.class);
        return objectGroup.getQualifiers().stream().flatMap(qualifier -> qualifier.getVersions().stream()).filter(version -> usageVersion.equals(version.getDataObjectVersion())).findFirst();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JsonIgnore
    private boolean isTimeStampValid(String timeStampTokenAsString) {
        try {
            TimeStampToken timeStampToken = this.timeStampService.getTimeStampFrom(timeStampTokenAsString);
            CMSSignedData cmsSignedData = timeStampToken.toCMSSignedData();
            Store certificates = cmsSignedData.getCertificates();
            SignerId selectX509Certificate = timeStampToken.getSID();
            Collection x509Certificates = certificates.getMatches((Selector)selectX509Certificate);
            Optional x509CertificateOptional = x509Certificates.stream().findFirst();
            if (!x509CertificateOptional.isPresent()) {
                return false;
            }
            X509CertificateHolder x509Certificate = (X509CertificateHolder)x509CertificateOptional.get();
            SignerInformationVerifier sigVerifier = new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(x509Certificate);
            if (!this.isValid(timeStampToken, sigVerifier)) {
                return false;
            }
            AlgorithmIdentifier digestAlgorithmIdentifier = new AlgorithmIdentifier(timeStampToken.getTimeStampInfo().getMessageImprintAlgOID());
            BcDigestCalculatorProvider digestCalculatorProvider = new BcDigestCalculatorProvider();
            DigestCalculator digestCalculator = digestCalculatorProvider.get(digestAlgorithmIdentifier);
            try (OutputStream dOut = digestCalculator.getOutputStream();){
                ASN1Encodable firstAsn1Encodable;
                SigningCertificateV2 signingCertificate;
                ESSCertIDv2 cert;
                byte[] certificateTimeStampFile;
                dOut.write(x509Certificate.getEncoded());
                dOut.close();
                byte[] x509CertificateFromProvider = digestCalculator.getDigest();
                AttributeTable timeStampTokenSignedAttributes = timeStampToken.getSignedAttributes();
                if (timeStampTokenSignedAttributes == null) {
                    boolean bl = false;
                    return bl;
                }
                Attribute attribute = timeStampTokenSignedAttributes.get(PKCSObjectIdentifiers.id_aa_signingCertificate);
                if (attribute == null) {
                    attribute = timeStampTokenSignedAttributes.get(PKCSObjectIdentifiers.id_aa_signingCertificateV2);
                }
                if (Arrays.equals(certificateTimeStampFile = (cert = (signingCertificate = SigningCertificateV2.getInstance((Object)(firstAsn1Encodable = attribute.getAttrValues().getObjectAt(0)))).getCerts()[0]).getCertHash(), x509CertificateFromProvider)) return true;
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            LOGGER.warn((Throwable)e);
            return false;
        }
    }

    @JsonIgnore
    private boolean isValid(TimeStampToken timeStampToken, SignerInformationVerifier sigVerifier) {
        try {
            timeStampToken.validate(sigVerifier);
            return true;
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return false;
        }
    }

    private List<StorageStrategy> loadStorageStrategies(HandlerIO handler) throws ProcessingStatusException {
        try {
            return (List)JsonHandler.getFromFileAsTypeReference((File)((File)handler.getInput(0)), (TypeReference)new TypeReference<List<StorageStrategy>>(){});
        }
        catch (InvalidParseOperationException e) {
            throw new ProcessingStatusException(StatusCode.FATAL, "Could not load storage strategies datas", e);
        }
    }

    private String getTraceabilityMerkleFileMerkleTreeRootDigest(File merkleFile) throws InvalidParseOperationException {
        return JsonHandler.getFromFile((File)merkleFile).get("Root").asText();
    }

    public static String traceabilityFilesDirectoryName(String objectGroupId, String evType) {
        return String.format("%s-%s", objectGroupId, evType);
    }

    private static /* synthetic */ boolean lambda$doObjectGroupChecks$11(DbVersionsModel objectModel, ObjectGroupDocumentHash o) {
        return o.getId().equals(objectModel.getId());
    }

    private static /* synthetic */ Stream lambda$doObjectGroupChecks$10(LifeCycleTraceabilitySecureFileObject line) {
        return line.getObjectGroupDocumentHashList().stream();
    }

    private static /* synthetic */ boolean lambda$doObjectGroupChecks$9(DbVersionsModel objectModel, LifeCycleTraceabilitySecureFileObject l) {
        return Objects.nonNull(l) && MetadataType.OBJECTGROUP.equals((Object)l.getMetadataType()) && objectModel.getDataObjectGroupId().equalsIgnoreCase(l.getLfcId());
    }

    private /* synthetic */ boolean lambda$doObjectGroupChecks$8(LogbookOperation traceabilityLogbookOperation, JsonNode jsonNode) {
        return this.isEventBeforeInSecured(traceabilityLogbookOperation, jsonNode);
    }

    private static /* synthetic */ boolean lambda$doOperationChecks$7(LogbookOperation logbookOperationVersionModel, LogbookOperation op) {
        return op.getId().equals(logbookOperationVersionModel.getId());
    }

    private /* synthetic */ Stream lambda$execute$4(Map traceabilityFiles, DbVersionsModel dbVersionsModel, JsonNode rawLogbookObjectGroupLFC, LogbookOperation logbookOperationVersionModel, HandlerIO handler, OperationWithClosestPreviousOperation operationWithClosestPreviousOperation) {
        return this.doChecks((OperationTraceabilityFiles)((Optional)traceabilityFiles.get(operationWithClosestPreviousOperation.getOperation().getEvType())).get(), operationWithClosestPreviousOperation, dbVersionsModel, rawLogbookObjectGroupLFC, logbookOperationVersionModel, handler);
    }

    private /* synthetic */ Optional lambda$execute$3(StorageClient storageClient, HandlerIO handler, String objectGroupId, OperationWithClosestPreviousOperation op) {
        return this.getTraceabilityFile(op.getOperation(), storageClient, handler, objectGroupId);
    }

    private static /* synthetic */ String lambda$execute$2(OperationWithClosestPreviousOperation op) {
        return op.getOperation().getEvType();
    }

    private /* synthetic */ ProbativeOperation lambda$execute$1(OperationWithClosestPreviousOperation op) {
        return this.logbookOperationTo(op.getOperation());
    }

    private /* synthetic */ Optional lambda$execute$0(LogbookOperationsClient logbookOperationsClient, LogbookOperation op) {
        return this.getTraceabilityOperation(logbookOperationsClient, op);
    }
}

